/************************************************************************************************/
/* Stata User File for H192 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H192.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H192.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H192.DO                                               */
/* The program below will output the Stata dataset H192.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL 17-18
  str    FAMID31 19-20
  str    FAMID42 21-22
  str    FAMID53 23-24
  str    FAMID16 25-26
  str    FAMIDYR 27-28
  str    CPSFAMID 29-30
  byte   FCSZ1231 31-32
  byte   FCRP1231 33-34
  str    RULETR31 35-36
  str    RULETR42 37-38
  str    RULETR53 39-40
  str    RULETR16 41-42
  byte   RUSIZE31 43-44
  byte   RUSIZE42 45-46
  byte   RUSIZE53 47-48
  byte   RUSIZE16 49-50
  byte   RUCLAS31 51-52
  byte   RUCLAS42 53-54
  byte   RUCLAS53 55-56
  byte   RUCLAS16 57-57
  byte   FAMSZE31 58-59
  byte   FAMSZE42 60-61
  byte   FAMSZE53 62-63
  byte   FAMSZE16 64-65
  byte   FMRS1231 66-67
  byte   FAMS1231 68-69
  byte   FAMSZEYR 70-71
  byte   FAMRFPYR 72-72
  byte   REGION31 73-74
  byte   REGION42 75-76
  byte   REGION53 77-78
  byte   REGION16 79-80
  int    REFPRS31 81-83
  int    REFPRS42 84-86
  int    REFPRS53 87-89
  int    REFPRS16 90-92
  byte   RESP31 93-93
  byte   RESP42 94-94
  byte   RESP53 95-95
  byte   RESP16 96-96
  byte   PROXY31 97-98
  byte   PROXY42 99-100
  byte   PROXY53 101-102
  byte   PROXY16 103-103
  byte   INTVLANG 104-105
  byte   BEGRFM31 106-107
  int    BEGRFY31 108-111
  byte   ENDRFM31 112-113
  int    ENDRFY31 114-117
  byte   BEGRFM42 118-119
  int    BEGRFY42 120-123
  byte   ENDRFM42 124-125
  int    ENDRFY42 126-129
  byte   BEGRFM53 130-131
  int    BEGRFY53 132-135
  byte   ENDRFM53 136-137
  int    ENDRFY53 138-141
  byte   ENDRFM16 142-143
  int    ENDRFY16 144-147
  byte   KEYNESS 148-148
  byte   INSCOP31 149-149
  byte   INSCOP42 150-150
  byte   INSCOP53 151-151
  byte   INSCOP16 152-152
  byte   INSC1231 153-153
  byte   INSCOPE 154-154
  byte   ELGRND31 155-155
  byte   ELGRND42 156-156
  byte   ELGRND53 157-157
  byte   ELGRND16 158-158
  byte   PSTATS31 159-160
  byte   PSTATS42 161-162
  byte   PSTATS53 163-164
  str    RURSLT31 165-166
  str    RURSLT42 167-168
  str    RURSLT53 169-170
  byte   AGE31X 171-172
  byte   AGE42X 173-174
  byte   AGE53X 175-176
  byte   AGE16X 177-178
  byte   AGELAST 179-180
  byte   DOBMM 181-182
  int    DOBYY 183-186
  byte   SEX 187-187
  byte   RACEV1X 188-188
  byte   RACEV2X 189-190
  byte   RACEAX 191-191
  byte   RACEBX 192-192
  byte   RACEWX 193-193
  byte   RACETHX 194-194
  byte   HISPANX 195-195
  byte   HISPNCAT 196-196
  byte   MARRY31X 197-198
  byte   MARRY42X 199-200
  byte   MARRY53X 201-202
  byte   MARRY16X 203-204
  int    SPOUID31 205-207
  int    SPOUID42 208-210
  int    SPOUID53 211-213
  int    SPOUID16 214-216
  byte   SPOUIN31 217-218
  byte   SPOUIN42 219-220
  byte   SPOUIN53 221-222
  byte   SPOUIN16 223-224
  byte   EDUCYR 225-226
  byte   HIDEG 227-228
  byte   FTSTU31X 229-230
  byte   FTSTU42X 231-232
  byte   FTSTU53X 233-234
  byte   FTSTU16X 235-236
  byte   ACTDTY31 237-238
  byte   ACTDTY42 239-240
  byte   ACTDTY53 241-242
  byte   HONRDC31 243-244
  byte   HONRDC42 245-246
  byte   HONRDC53 247-248
  byte   REFRL31X 249-250
  byte   REFRL42X 251-252
  byte   REFRL53X 253-254
  byte   REFRL16X 255-256
  byte   OTHLANG 257-258
  byte   LANGSPK 259-260
  byte   HWELLSPE 261-262
  byte   BORNUSA 263-264
  byte   YRSINUS 265-266
  int    MOPID31X 267-269
  int    MOPID42X 270-272
  int    MOPID53X 273-275
  int    DAPID31X 276-278
  int    DAPID42X 279-281
  int    DAPID53X 282-284
  byte   RTHLTH31 285-286
  byte   RTHLTH42 287-288
  byte   RTHLTH53 289-290
  byte   MNHLTH31 291-292
  byte   MNHLTH42 293-294
  byte   MNHLTH53 295-296
  byte   HIBPDX 297-298
  byte   HIBPAGED 299-300
  byte   BPMLDX 301-302
  byte   CHDDX 303-304
  byte   CHDAGED 305-306
  byte   ANGIDX 307-308
  byte   ANGIAGED 309-310
  byte   MIDX 311-312
  byte   MIAGED 313-314
  byte   OHRTDX 315-316
  byte   OHRTAGED 317-318
  byte   STRKDX 319-320
  byte   STRKAGED 321-322
  byte   EMPHDX 323-324
  byte   EMPHAGED 325-326
  byte   CHBRON31 327-328
  byte   CHBRON53 329-330
  byte   CHOLDX 331-332
  byte   CHOLAGED 333-334
  byte   CANCERDX 335-336
  byte   CABLADDR 337-338
  byte   CABREAST 339-340
  byte   CACERVIX 341-342
  byte   CACOLON 343-344
  byte   CALUNG 345-346
  byte   CALYMPH 347-348
  byte   CAMELANO 349-350
  byte   CAOTHER 351-352
  byte   CAPROSTA 353-354
  byte   CASKINNM 355-356
  byte   CASKINDK 357-358
  byte   CAUTERUS 359-360
  byte   DIABDX 361-362
  byte   DIABAGED 363-364
  byte   JTPAIN31 365-366
  byte   JTPAIN53 367-368
  byte   ARTHDX 369-370
  byte   ARTHTYPE 371-372
  byte   ARTHAGED 373-374
  byte   ASTHDX 375-376
  byte   ASTHAGED 377-378
  byte   ASSTIL31 379-380
  byte   ASSTIL53 381-382
  byte   ASATAK31 383-384
  byte   ASATAK53 385-386
  byte   ASTHEP31 387-388
  byte   ASTHEP53 389-390
  byte   ASACUT53 391-392
  byte   ASMRCN53 393-394
  byte   ASPREV53 395-396
  byte   ASDALY53 397-398
  byte   ASPKFL53 399-400
  byte   ASEVFL53 401-402
  byte   ASWNFL53 403-404
  byte   ADHDADDX 405-406
  byte   ADHDAGED 407-408
  byte   PREGNT31 409-410
  byte   PREGNT42 411-412
  byte   PREGNT53 413-414
  byte   IADLHP31 415-416
  byte   IADLHP53 417-418
  byte   ADLHLP31 419-420
  byte   ADLHLP53 421-422
  byte   AIDHLP31 423-424
  byte   AIDHLP53 425-426
  byte   WLKLIM31 427-428
  byte   WLKLIM53 429-430
  byte   LFTDIF31 431-432
  byte   LFTDIF53 433-434
  byte   STPDIF31 435-436
  byte   STPDIF53 437-438
  byte   WLKDIF31 439-440
  byte   WLKDIF53 441-442
  byte   MILDIF31 443-444
  byte   MILDIF53 445-446
  byte   STNDIF31 447-448
  byte   STNDIF53 449-450
  byte   BENDIF31 451-452
  byte   BENDIF53 453-454
  byte   RCHDIF31 455-456
  byte   RCHDIF53 457-458
  byte   FNGRDF31 459-460
  byte   FNGRDF53 461-462
  byte   ACTLIM31 463-464
  byte   ACTLIM53 465-466
  byte   WRKLIM31 467-468
  byte   WRKLIM53 469-470
  byte   HSELIM31 471-472
  byte   HSELIM53 473-474
  byte   SCHLIM31 475-476
  byte   SCHLIM53 477-478
  byte   UNABLE31 479-480
  byte   UNABLE53 481-482
  byte   SOCLIM31 483-484
  byte   SOCLIM53 485-486
  byte   COGLIM31 487-488
  byte   COGLIM53 489-490
  byte   DFHEAR42 491-492
  byte   DEAF42 493-494
  byte   DFSEE42 495-496
  byte   BLIND42 497-498
  byte   DFCOG42 499-500
  byte   DFWLKC42 501-502
  byte   DFDRSB42 503-504
  byte   DFERND42 505-506
  byte   HEARAD42 507-508
  byte   WRGLAS42 509-510
  byte   ANYLMT16 511-512
  byte   CHPMED42 513-514
  byte   CHPMHB42 515-516
  byte   CHPMCN42 517-518
  byte   CHSERV42 519-520
  byte   CHSRHB42 521-522
  byte   CHSRCN42 523-524
  byte   CHLIMI42 525-526
  byte   CHLIHB42 527-528
  byte   CHLICO42 529-530
  byte   CHTHER42 531-532
  byte   CHTHHB42 533-534
  byte   CHTHCO42 535-536
  byte   CHCOUN42 537-538
  byte   CHEMPB42 539-540
  byte   CSHCN42 541-542
  byte   MOMPRO42 543-544
  byte   DADPRO42 545-546
  byte   UNHAP42 547-548
  byte   SCHLBH42 549-550
  byte   HAVFUN42 551-552
  byte   ADUPRO42 553-554
  byte   NERVAF42 555-556
  byte   SIBPRO42 557-558
  byte   KIDPRO42 559-560
  byte   SPRPRO42 561-562
  byte   SCHPRO42 563-564
  byte   HOMEBH42 565-566
  byte   TRBLE42 567-568
  byte   CHILCR42 569-570
  byte   CHILWW42 571-572
  byte   CHRTCR42 573-574
  byte   CHRTWW42 575-576
  byte   CHAPPT42 577-578
  byte   CHNDCR42 579-580
  byte   CHENEC42 581-582
  byte   CHLIST42 583-584
  byte   CHEXPL42 585-586
  byte   CHRESP42 587-588
  byte   CHPRTM42 589-590
  byte   CHHECR42 591-592
  byte   CHSPEC42 593-594
  byte   CHEYRE42 595-596
  byte   MESHGT42 597-598
  byte   WHNHGT42 599-600
  byte   MESWGT42 601-602
  byte   WHNWGT42 603-604
  double CHBMIX42 605-608
  byte   MESVIS42 609-610
  byte   MESBPR42 611-612
  byte   WHNBPR42 613-614
  byte   DENTAL42 615-616
  byte   WHNDEN42 617-618
  byte   EATHLT42 619-620
  byte   WHNEAT42 621-622
  byte   PHYSCL42 623-624
  byte   WHNPHY42 625-626
  byte   SAFEST42 627-628
  byte   WHNSAF42 629-630
  byte   BOOST42 631-632
  byte   WHNBST42 633-634
  byte   LAPBLT42 635-636
  byte   WHNLAP42 637-638
  byte   HELMET42 639-640
  byte   WHNHEL42 641-642
  byte   NOSMOK42 643-644
  byte   WHNSMK42 645-646
  byte   TIMALN42 647-648
  byte   DENTCK53 649-650
  byte   BPCHEK53 651-652
  byte   CHOLCK53 653-654
  byte   CHECK53 655-656
  byte   NOFAT53 657-658
  byte   EXRCIS53 659-660
  byte   FLUSHT53 661-662
  byte   ASPRIN53 663-664
  byte   NOASPR53 665-666
  byte   STOMCH53 667-668
  byte   LSTETH53 669-670
  byte   PSA53 671-672
  byte   HYSTER53 673-674
  byte   PAPSMR53 675-676
  byte   BRSTEX53 677-678
  byte   MAMOGR53 679-680
  byte   BSTST53 681-682
  byte   BSTSRE53 683-684
  byte   CLNTST53 685-686
  byte   CLNTRE53 687-688
  byte   SGMTST53 689-690
  byte   SGMTRE53 691-692
  byte   PHYEXE53 693-694
  double BMINDX53 695-699
  byte   SEATBE53 700-701
  byte   SAQELIG 702-702
  int    ADPRXY42 703-705
  byte   ADILCR42 706-707
  byte   ADILWW42 708-709
  byte   ADRTCR42 710-711
  byte   ADRTWW42 712-713
  byte   ADAPPT42 714-715
  byte   ADNDCR42 716-717
  byte   ADEGMC42 718-719
  byte   ADLIST42 720-721
  byte   ADEXPL42 722-723
  byte   ADRESP42 724-725
  byte   ADPRTM42 726-727
  byte   ADINST42 728-729
  byte   ADEZUN42 730-731
  byte   ADTLHW42 732-733
  byte   ADFFRM42 734-735
  byte   ADFHLP42 736-737
  byte   ADHECR42 738-739
  byte   ADSMOK42 740-741
  byte   ADNSMK42 742-743
  byte   ADDRBP42 744-745
  byte   ADSPEC42 746-747
  byte   ADESSP42 748-749
  byte   ADGENH42 750-751
  byte   ADDAYA42 752-753
  byte   ADCLIM42 754-755
  byte   ADPALS42 756-757
  byte   ADPWLM42 758-759
  byte   ADMALS42 760-761
  byte   ADMWLM42 762-763
  byte   ADPAIN42 764-765
  byte   ADCAPE42 766-767
  byte   ADNRGY42 768-769
  byte   ADDOWN42 770-771
  byte   ADSOCA42 772-773
  double PCS42 774-778
  double MCS42 779-783
  byte   SFFLAG42 784-785
  byte   ADNERV42 786-787
  byte   ADHOPE42 788-789
  byte   ADREST42 790-791
  byte   ADSAD42 792-793
  byte   ADEFRT42 794-795
  byte   ADWRTH42 796-797
  byte   K6SUM42 798-799
  byte   ADINTR42 800-801
  byte   ADDPRS42 802-803
  byte   PHQ242 804-805
  byte   ADINSA42 806-807
  byte   ADINSB42 808-809
  byte   ADRISK42 810-811
  byte   ADOVER42 812-813
  byte   ADCMPM42 814-815
  int    ADCMPY42 816-819
  byte   ADLANG42 820-821
  byte   DSDIA53 822-823
  byte   DSA1C53 824-825
  byte   DSFT1753 826-827
  byte   DSFT1653 828-829
  byte   DSFT1553 830-831
  byte   DSFB1553 832-833
  byte   DSFTNV53 834-835
  byte   DSEY1753 836-837
  byte   DSEY1653 838-839
  byte   DSEY1553 840-841
  byte   DSEB1553 842-843
  byte   DSEYNV53 844-845
  byte   DSCH1753 846-847
  byte   DSCH1653 848-849
  byte   DSCH1553 850-851
  byte   DSCB1553 852-853
  byte   DSCHNV53 854-855
  byte   DSFL1753 856-857
  byte   DSFL1653 858-859
  byte   DSFL1553 860-861
  byte   DSVB1553 862-863
  byte   DSFLNV53 864-865
  byte   DSKIDN53 866-867
  byte   DSEYPR53 868-869
  byte   DSDIET53 870-871
  byte   DSMED53 872-873
  byte   DSINSU53 874-875
  byte   DSCPCP53 876-877
  byte   DSCNPC53 878-879
  byte   DSCPHN53 880-881
  byte   DSCINT53 882-883
  byte   DSCGRP53 884-885
  byte   DSCONF53 886-887
  byte   DSPRX53 888-889
  byte   CCNRDI31 890-891
  byte   CDIAG31 892-893
  byte   CTRTMT31 894-895
  byte   CLSTRT31 896-897
  byte   CBCK31 898-899
  int    CBCKYR31 900-903
  byte   CFTRT31 904-905
  byte   CWRKP31 906-907
  byte   CTMOFF31 908-909
  byte   CWYCNG31 910-911
  byte   CEXTM31 912-913
  byte   CEXTDI31 914-915
  byte   CEXTRT31 916-917
  byte   CEXTLT31 918-919
  byte   CEXTMT31 920-921
  byte   CNPTLD31 922-923
  byte   CNGFLX31 924-925
  byte   CPROM31 926-927
  byte   CERET31 928-929
  byte   CPTASK31 930-931
  byte   CMTASK31 932-933
  byte   CLPROD31 934-935
  byte   CFRET31 936-937
  byte   CLHINS31 938-939
  byte   CCLHIN31 940-941
  byte   CSLHIN31 942-943
  byte   CFMEM31 944-945
  byte   CFMSPS31 946-947
  byte   CFMCHD31 948-949
  byte   CFMSIB31 950-951
  byte   CFMPAR31 952-953
  byte   CFMREL31 954-955
  byte   CFMFND31 956-957
  byte   CFMOTR31 958-959
  byte   CFMTOF31 960-961
  byte   CFM2MT31 962-963
  byte   CINCOV31 964-965
  byte   CINPRV31 966-967
  byte   CINMDC31 968-969
  byte   CINMDG31 970-971
  byte   CINMDA31 972-973
  byte   CINMLT31 974-975
  byte   CINIHS31 976-977
  byte   CINSHP31 978-979
  byte   CINOGP31 980-981
  byte   CINSSP31 982-983
  byte   CINNCV31 984-985
  byte   CINNOC31 986-987
  byte   CINADQ31 988-989
  byte   CINCMP31 990-991
  byte   CINDIF31 992-993
  byte   CINAFD31 994-995
  byte   CNCMED31 996-997
  byte   CNCTRP31 998-999
  byte   CNCLOD31 1000-1001
  byte   CNCCHD31 1002-1003
  byte   CNCHME31 1004-1005
  byte   CNCNON31 1006-1007
  byte   CNCNTS31 1008-1009
  byte   CFNDBT31 1010-1011
  byte   CFNAMT31 1012-1013
  byte   CFNVAC31 1014-1015
  byte   CFNPUR31 1016-1017
  byte   CFNSPD31 1018-1019
  byte   CFNSAV31 1020-1021
  byte   CFNLIV31 1022-1023
  byte   CFNOTH31 1024-1025
  byte   CFNUNB31 1026-1027
  byte   CFNBNK31 1028-1029
  byte   CFNPMT31 1030-1031
  byte   CFNSTB31 1032-1033
  byte   CFNINC31 1034-1035
  byte   CMCFUP31 1036-1037
  byte   CMCEFF31 1038-1039
  byte   CMCPSY31 1040-1041
  byte   CMCSTY31 1042-1043
  byte   CMCOST31 1044-1045
  byte   CMCTRT31 1046-1047
  byte   CDLPRS31 1048-1049
  byte   CDLVST31 1050-1051
  byte   CDLTRT31 1052-1053
  byte   CDLFUP31 1054-1055
  byte   CDLMNT31 1056-1057
  byte   CDLOTH31 1058-1059
  byte   CMCNEC31 1060-1061
  byte   CMNAFF31 1062-1063
  byte   CMNINS31 1064-1065
  byte   CMNACC31 1066-1067
  byte   CMNOFF31 1068-1069
  byte   CMNTIM31 1070-1071
  byte   CMNPLC31 1072-1073
  byte   CMNCRE31 1074-1075
  byte   CMNLNG31 1076-1077
  byte   CEFACT31 1078-1079
  byte   CEFLCT31 1080-1081
  byte   CEFOG31 1082-1083
  byte   CEFMTL31 1084-1085
  byte   CEFUND31 1086-1087
  byte   CEFBCK31 1088-1089
  byte   CEFSTG31 1090-1091
  byte   CEFCOP31 1092-1093
  byte   CEFPOS31 1094-1095
  byte   CEFHLT31 1096-1097
  byte   CEFPHL31 1098-1099
  byte   CEFPAC31 1100-1101
  byte   CEFPIN31 1102-1103
  byte   CEFFTG31 1104-1105
  byte   CEFQLF31 1106-1107
  byte   CEFMHL31 1108-1109
  byte   CEFRLT31 1110-1111
  byte   CEFMPR31 1112-1113
  byte   DDNWRK16 1114-1115
  byte   DDNSCL16 1116-1117
  byte   OTHDYS16 1118-1119
  byte   OTHNDD16 1120-1121
  byte   ACCELI42 1122-1123
  byte   HAVEUS42 1124-1125
  byte   YNOUSC42 1126-1127
  byte   NOREAS42 1128-1129
  byte   SELDSI42 1130-1131
  byte   NEWARE42 1132-1133
  byte   DKWHRU42 1134-1135
  byte   USCNOT42 1136-1137
  byte   PERSLA42 1138-1139
  byte   DIFFPL42 1140-1141
  byte   INSRPL42 1142-1143
  byte   MYSELF42 1144-1145
  byte   CARECO42 1146-1147
  byte   NOHINS42 1148-1149
  byte   OTHINS42 1150-1151
  byte   JOBRSN42 1152-1153
  byte   NEWDOC42 1154-1155
  byte   DOCELS42 1156-1157
  byte   NOLIKE42 1158-1159
  byte   HEALTH42 1160-1161
  byte   KNOWDR42 1162-1163
  byte   ONJOB42 1164-1165
  byte   NOGODR42 1166-1167
  byte   TRANS42 1168-1169
  byte   CLINIC42 1170-1171
  byte   OTHREA42 1172-1173
  byte   PROVTY42 1174-1175
  byte   PLCTYP42 1176-1177
  byte   TMTKUS42 1178-1179
  byte   TYPEPE42 1180-1181
  byte   LOCATN42 1182-1183
  byte   HSPLAP42 1184-1185
  byte   WHITPR42 1186-1187
  byte   BLCKPR42 1188-1189
  byte   ASIANP42 1190-1191
  byte   NATAMP42 1192-1193
  byte   PACISP42 1194-1195
  byte   OTHRCP42 1196-1197
  byte   GENDRP42 1198-1199
  byte   MINORP42 1200-1201
  byte   PREVEN42 1202-1203
  byte   REFFRL42 1204-1205
  byte   ONGONG42 1206-1207
  byte   PHNREG42 1208-1209
  byte   OFFHOU42 1210-1211
  byte   AFTHOU42 1212-1213
  byte   TREATM42 1214-1215
  byte   RESPCT42 1216-1217
  byte   DECIDE42 1218-1219
  byte   EXPLOP42 1220-1221
  byte   PRVSPK42 1222-1223
  byte   MDUNAB42 1224-1225
  byte   MDUNRS42 1226-1227
  byte   MDDLAY42 1228-1229
  byte   MDDLRS42 1230-1231
  byte   DNUNAB42 1232-1233
  byte   DNUNRS42 1234-1235
  byte   DNDLAY42 1236-1237
  byte   DNDLRS42 1238-1239
  byte   PMUNAB42 1240-1241
  byte   PMUNRS42 1242-1243
  byte   PMDLAY42 1244-1245
  byte   PMDLRS42 1246-1247
  byte   EMPST31 1248-1249
  byte   EMPST42 1250-1251
  byte   EMPST53 1252-1253
  byte   RNDFLG31 1254-1255
  byte   MORJOB31 1256-1257
  byte   MORJOB42 1258-1259
  byte   MORJOB53 1260-1261
  byte   EVRWRK 1262-1263
  double HRWG31X 1264-1269
  double HRWG42X 1270-1275
  double HRWG53X 1276-1281
  byte   HRWGIM31 1282-1282
  byte   HRWGIM42 1283-1283
  byte   HRWGIM53 1284-1284
  byte   HRHOW31 1285-1286
  byte   HRHOW42 1287-1288
  byte   HRHOW53 1289-1290
  byte   DIFFWG31 1291-1292
  byte   DIFFWG42 1293-1294
  byte   DIFFWG53 1295-1296
  double NHRWG31 1297-1302
  double NHRWG42 1303-1308
  double NHRWG53 1309-1314
  int    HOUR31 1315-1317
  int    HOUR42 1318-1320
  byte   HOUR53 1321-1322
  byte   TEMPJB31 1323-1324
  byte   TEMPJB42 1325-1326
  byte   TEMPJB53 1327-1328
  byte   SSNLJB31 1329-1330
  byte   SSNLJB42 1331-1332
  byte   SSNLJB53 1333-1334
  byte   SELFCM31 1335-1336
  byte   SELFCM42 1337-1338
  byte   SELFCM53 1339-1340
  byte   DISVW31X 1341-1342
  byte   DISVW42X 1343-1344
  byte   DISVW53X 1345-1346
  byte   CHOIC31 1347-1348
  byte   CHOIC42 1349-1350
  byte   CHOIC53 1351-1352
  byte   INDCAT31 1353-1354
  byte   INDCAT42 1355-1356
  byte   INDCAT53 1357-1358
  int    NUMEMP31 1359-1361
  int    NUMEMP42 1362-1364
  int    NUMEMP53 1365-1367
  byte   MORE31 1368-1369
  byte   MORE42 1370-1371
  byte   MORE53 1372-1373
  byte   UNION31 1374-1375
  byte   UNION42 1376-1377
  byte   UNION53 1378-1379
  byte   NWK31 1380-1381
  byte   NWK42 1382-1383
  byte   NWK53 1384-1385
  byte   CHGJ3142 1386-1387
  byte   CHGJ4253 1388-1389
  byte   YCHJ3142 1390-1391
  byte   YCHJ4253 1392-1393
  byte   STJBMM31 1394-1395
  int    STJBYY31 1396-1399
  byte   STJBMM42 1400-1401
  int    STJBYY42 1402-1405
  byte   STJBMM53 1406-1407
  int    STJBYY53 1408-1411
  byte   EVRETIRE 1412-1413
  byte   OCCCAT31 1414-1415
  byte   OCCCAT42 1416-1417
  byte   OCCCAT53 1418-1419
  byte   PAYVAC31 1420-1421
  byte   PAYVAC42 1422-1423
  byte   PAYVAC53 1424-1425
  byte   SICPAY31 1426-1427
  byte   SICPAY42 1428-1429
  byte   SICPAY53 1430-1431
  byte   PAYDR31 1432-1433
  byte   PAYDR42 1434-1435
  byte   PAYDR53 1436-1437
  byte   RETPLN31 1438-1439
  byte   RETPLN42 1440-1441
  byte   RETPLN53 1442-1443
  byte   BSNTY31 1444-1445
  byte   BSNTY42 1446-1447
  byte   BSNTY53 1448-1449
  byte   JOBORG31 1450-1451
  byte   JOBORG42 1452-1453
  byte   JOBORG53 1454-1455
  byte   HELD31X 1456-1457
  byte   HELD42X 1458-1459
  byte   HELD53X 1460-1461
  byte   OFFER31X 1462-1463
  byte   OFFER42X 1464-1465
  byte   OFFER53X 1466-1467
  byte   OFREMP31 1468-1469
  byte   OFREMP42 1470-1471
  byte   OFREMP53 1472-1473
  byte   EMPST31H 1474-1475
  byte   EMPST42H 1476-1477
  byte   EMPST53H 1478-1479
  byte   SLFCM31H 1480-1481
  byte   SLFCM42H 1482-1483
  byte   SLFCM53H 1484-1485
  int    NMEMP31H 1486-1488
  int    NMEMP42H 1489-1491
  int    NMEMP53H 1492-1494
  byte   MORE31H 1495-1496
  byte   MORE42H 1497-1498
  byte   MORE53H 1499-1500
  byte   INDCT31H 1501-1502
  byte   INDCT42H 1503-1504
  byte   INDCT53H 1505-1506
  byte   OCCCT31H 1507-1508
  byte   OCCCT42H 1509-1510
  byte   OCCCT53H 1511-1512
  int    HOUR31H 1513-1515
  int    HOUR42H 1516-1518
  int    HOUR53H 1519-1521
  byte   JBORG31H 1522-1523
  byte   JBORG42H 1524-1525
  byte   JBORG53H 1526-1527
  byte   UNION31H 1528-1529
  byte   UNION42H 1530-1531
  byte   UNION53H 1532-1533
  byte   BSNTY31H 1534-1535
  byte   BSNTY42H 1536-1537
  byte   BSNTY53H 1538-1539
  double HRWG31H 1540-1545
  double HRWG42H 1546-1551
  double HRWG53H 1552-1557
  byte   CMJHLD31 1558-1559
  byte   CMJHLD42 1560-1561
  byte   CMJHLD53 1562-1563
  byte   OFFER31H 1564-1565
  byte   OFFER42H 1566-1567
  byte   OFFER53H 1568-1569
  byte   OFEMP31H 1570-1571
  byte   OFEMP42H 1572-1573
  byte   OFEMP53H 1574-1575
  byte   PYVAC31H 1576-1577
  byte   PYVAC42H 1578-1579
  byte   PYVAC53H 1580-1581
  byte   SCPAY31H 1582-1583
  byte   SCPAY42H 1584-1585
  byte   SCPAY53H 1586-1587
  byte   PAYDR31H 1588-1589
  byte   PAYDR42H 1590-1591
  byte   PAYDR53H 1592-1593
  byte   RTPLN31H 1594-1595
  byte   RTPLN42H 1596-1597
  byte   RTPLN53H 1598-1599
  byte   AFDC16 1600-1601
  byte   FILEDR16 1602-1603
  byte   WILFIL16 1604-1605
  byte   FLSTAT16 1606-1607
  byte   FILER16 1608-1609
  byte   JTINRU16 1610-1611
  int    JNTPID16 1612-1614
  byte   CLMDEP16 1615-1616
  byte   DEPDNT16 1617-1618
  byte   DPINRU16 1619-1620
  byte   DPOTSD16 1621-1622
  byte   TAXFRM16 1623-1624
  byte   CLMHIP16 1625-1626
  byte   EICRDT16 1627-1628
  byte   FOODST16 1629-1630
  byte   FOODMN16 1631-1632
  int    FOODVL16 1633-1636
  long   TTLP16X 1637-1643
  long   FAMINC16 1644-1650
  byte   POVCAT16 1651-1651
  double POVLEV16 1652-1663
  long   WAGEP16X 1664-1669
  byte   WAGIMP16 1670-1670
  long   BUSNP16X 1671-1676
  byte   BUSIMP16 1677-1677
  long   UNEMP16X 1678-1682
  byte   UNEIMP16 1683-1683
  long   WCMPP16X 1684-1688
  byte   WCPIMP16 1689-1689
  long   INTRP16X 1690-1695
  byte   INTIMP16 1696-1696
  long   DIVDP16X 1697-1701
  byte   DIVIMP16 1702-1702
  long   SALEP16X 1703-1709
  byte   SALIMP16 1710-1710
  long   PENSP16X 1711-1716
  byte   PENIMP16 1717-1717
  long   SSECP16X 1718-1722
  byte   SSCIMP16 1723-1723
  long   TRSTP16X 1724-1730
  byte   TRTIMP16 1731-1731
  long   VETSP16X 1732-1736
  byte   VETIMP16 1737-1737
  long   IRASP16X 1738-1742
  byte   IRAIMP16 1743-1743
  long   ALIMP16X 1744-1748
  byte   ALIIMP16 1749-1749
  long   CHLDP16X 1750-1754
  byte   CHLIMP16 1755-1755
  long   CASHP16X 1756-1760
  byte   CSHIMP16 1761-1761
  long   SSIP16X 1762-1766
  byte   SSIIMP16 1767-1767
  int    PUBP16X 1768-1771
  byte   PUBIMP16 1772-1772
  long   OTHRP16X 1773-1778
  byte   OTHIMP16 1779-1779
  str    HIEUIDX 1780-1786
  byte   TRIJA16X 1787-1788
  byte   TRIFE16X 1789-1790
  byte   TRIMA16X 1791-1792
  byte   TRIAP16X 1793-1794
  byte   TRIMY16X 1795-1796
  byte   TRIJU16X 1797-1798
  byte   TRIJL16X 1799-1800
  byte   TRIAU16X 1801-1802
  byte   TRISE16X 1803-1804
  byte   TRIOC16X 1805-1806
  byte   TRINO16X 1807-1808
  byte   TRIDE16X 1809-1810
  byte   MCRJA16 1811-1812
  byte   MCRFE16 1813-1814
  byte   MCRMA16 1815-1816
  byte   MCRAP16 1817-1818
  byte   MCRMY16 1819-1820
  byte   MCRJU16 1821-1822
  byte   MCRJL16 1823-1824
  byte   MCRAU16 1825-1826
  byte   MCRSE16 1827-1828
  byte   MCROC16 1829-1830
  byte   MCRNO16 1831-1832
  byte   MCRDE16 1833-1834
  byte   MCRJA16X 1835-1836
  byte   MCRFE16X 1837-1838
  byte   MCRMA16X 1839-1840
  byte   MCRAP16X 1841-1842
  byte   MCRMY16X 1843-1844
  byte   MCRJU16X 1845-1846
  byte   MCRJL16X 1847-1848
  byte   MCRAU16X 1849-1850
  byte   MCRSE16X 1851-1852
  byte   MCROC16X 1853-1854
  byte   MCRNO16X 1855-1856
  byte   MCRDE16X 1857-1858
  byte   MCDJA16 1859-1860
  byte   MCDFE16 1861-1862
  byte   MCDMA16 1863-1864
  byte   MCDAP16 1865-1866
  byte   MCDMY16 1867-1868
  byte   MCDJU16 1869-1870
  byte   MCDJL16 1871-1872
  byte   MCDAU16 1873-1874
  byte   MCDSE16 1875-1876
  byte   MCDOC16 1877-1878
  byte   MCDNO16 1879-1880
  byte   MCDDE16 1881-1882
  byte   MCDJA16X 1883-1884
  byte   MCDFE16X 1885-1886
  byte   MCDMA16X 1887-1888
  byte   MCDAP16X 1889-1890
  byte   MCDMY16X 1891-1892
  byte   MCDJU16X 1893-1894
  byte   MCDJL16X 1895-1896
  byte   MCDAU16X 1897-1898
  byte   MCDSE16X 1899-1900
  byte   MCDOC16X 1901-1902
  byte   MCDNO16X 1903-1904
  byte   MCDDE16X 1905-1906
  byte   OPAJA16 1907-1908
  byte   OPAFE16 1909-1910
  byte   OPAMA16 1911-1912
  byte   OPAAP16 1913-1914
  byte   OPAMY16 1915-1916
  byte   OPAJU16 1917-1918
  byte   OPAJL16 1919-1920
  byte   OPAAU16 1921-1922
  byte   OPASE16 1923-1924
  byte   OPAOC16 1925-1926
  byte   OPANO16 1927-1928
  byte   OPADE16 1929-1930
  byte   OPBJA16 1931-1932
  byte   OPBFE16 1933-1934
  byte   OPBMA16 1935-1936
  byte   OPBAP16 1937-1938
  byte   OPBMY16 1939-1940
  byte   OPBJU16 1941-1942
  byte   OPBJL16 1943-1944
  byte   OPBAU16 1945-1946
  byte   OPBSE16 1947-1948
  byte   OPBOC16 1949-1950
  byte   OPBNO16 1951-1952
  byte   OPBDE16 1953-1954
  byte   STAJA16 1955-1956
  byte   STAFE16 1957-1958
  byte   STAMA16 1959-1960
  byte   STAAP16 1961-1962
  byte   STAMY16 1963-1964
  byte   STAJU16 1965-1966
  byte   STAJL16 1967-1968
  byte   STAAU16 1969-1970
  byte   STASE16 1971-1972
  byte   STAOC16 1973-1974
  byte   STANO16 1975-1976
  byte   STADE16 1977-1978
  byte   PUBJA16X 1979-1980
  byte   PUBFE16X 1981-1982
  byte   PUBMA16X 1983-1984
  byte   PUBAP16X 1985-1986
  byte   PUBMY16X 1987-1988
  byte   PUBJU16X 1989-1990
  byte   PUBJL16X 1991-1992
  byte   PUBAU16X 1993-1994
  byte   PUBSE16X 1995-1996
  byte   PUBOC16X 1997-1998
  byte   PUBNO16X 1999-2000
  byte   PUBDE16X 2001-2002
  byte   PEGJA16 2003-2004
  byte   PEGFE16 2005-2006
  byte   PEGMA16 2007-2008
  byte   PEGAP16 2009-2010
  byte   PEGMY16 2011-2012
  byte   PEGJU16 2013-2014
  byte   PEGJL16 2015-2016
  byte   PEGAU16 2017-2018
  byte   PEGSE16 2019-2020
  byte   PEGOC16 2021-2022
  byte   PEGNO16 2023-2024
  byte   PEGDE16 2025-2026
  byte   PDKJA16 2027-2028
  byte   PDKFE16 2029-2030
  byte   PDKMA16 2031-2032
  byte   PDKAP16 2033-2034
  byte   PDKMY16 2035-2036
  byte   PDKJU16 2037-2038
  byte   PDKJL16 2039-2040
  byte   PDKAU16 2041-2042
  byte   PDKSE16 2043-2044
  byte   PDKOC16 2045-2046
  byte   PDKNO16 2047-2048
  byte   PDKDE16 2049-2050
  byte   PNGJA16 2051-2052
  byte   PNGFE16 2053-2054
  byte   PNGMA16 2055-2056
  byte   PNGAP16 2057-2058
  byte   PNGMY16 2059-2060
  byte   PNGJU16 2061-2062
  byte   PNGJL16 2063-2064
  byte   PNGAU16 2065-2066
  byte   PNGSE16 2067-2068
  byte   PNGOC16 2069-2070
  byte   PNGNO16 2071-2072
  byte   PNGDE16 2073-2074
  byte   POGJA16 2075-2076
  byte   POGFE16 2077-2078
  byte   POGMA16 2079-2080
  byte   POGAP16 2081-2082
  byte   POGMY16 2083-2084
  byte   POGJU16 2085-2086
  byte   POGJL16 2087-2088
  byte   POGAU16 2089-2090
  byte   POGSE16 2091-2092
  byte   POGOC16 2093-2094
  byte   POGNO16 2095-2096
  byte   POGDE16 2097-2098
  byte   PRSJA16 2099-2100
  byte   PRSFE16 2101-2102
  byte   PRSMA16 2103-2104
  byte   PRSAP16 2105-2106
  byte   PRSMY16 2107-2108
  byte   PRSJU16 2109-2110
  byte   PRSJL16 2111-2112
  byte   PRSAU16 2113-2114
  byte   PRSSE16 2115-2116
  byte   PRSOC16 2117-2118
  byte   PRSNO16 2119-2120
  byte   PRSDE16 2121-2122
  byte   POUJA16 2123-2124
  byte   POUFE16 2125-2126
  byte   POUMA16 2127-2128
  byte   POUAP16 2129-2130
  byte   POUMY16 2131-2132
  byte   POUJU16 2133-2134
  byte   POUJL16 2135-2136
  byte   POUAU16 2137-2138
  byte   POUSE16 2139-2140
  byte   POUOC16 2141-2142
  byte   POUNO16 2143-2144
  byte   POUDE16 2145-2146
  byte   PRXJA16 2147-2148
  byte   PRXFE16 2149-2150
  byte   PRXMA16 2151-2152
  byte   PRXAP16 2153-2154
  byte   PRXMY16 2155-2156
  byte   PRXJU16 2157-2158
  byte   PRXJL16 2159-2160
  byte   PRXAU16 2161-2162
  byte   PRXSE16 2163-2164
  byte   PRXOC16 2165-2166
  byte   PRXNO16 2167-2168
  byte   PRXDE16 2169-2170
  byte   PRIJA16 2171-2172
  byte   PRIFE16 2173-2174
  byte   PRIMA16 2175-2176
  byte   PRIAP16 2177-2178
  byte   PRIMY16 2179-2180
  byte   PRIJU16 2181-2182
  byte   PRIJL16 2183-2184
  byte   PRIAU16 2185-2186
  byte   PRISE16 2187-2188
  byte   PRIOC16 2189-2190
  byte   PRINO16 2191-2192
  byte   PRIDE16 2193-2194
  byte   HPEJA16 2195-2196
  byte   HPEFE16 2197-2198
  byte   HPEMA16 2199-2200
  byte   HPEAP16 2201-2202
  byte   HPEMY16 2203-2204
  byte   HPEJU16 2205-2206
  byte   HPEJL16 2207-2208
  byte   HPEAU16 2209-2210
  byte   HPESE16 2211-2212
  byte   HPEOC16 2213-2214
  byte   HPENO16 2215-2216
  byte   HPEDE16 2217-2218
  byte   HPDJA16 2219-2220
  byte   HPDFE16 2221-2222
  byte   HPDMA16 2223-2224
  byte   HPDAP16 2225-2226
  byte   HPDMY16 2227-2228
  byte   HPDJU16 2229-2230
  byte   HPDJL16 2231-2232
  byte   HPDAU16 2233-2234
  byte   HPDSE16 2235-2236
  byte   HPDOC16 2237-2238
  byte   HPDNO16 2239-2240
  byte   HPDDE16 2241-2242
  byte   HPNJA16 2243-2244
  byte   HPNFE16 2245-2246
  byte   HPNMA16 2247-2248
  byte   HPNAP16 2249-2250
  byte   HPNMY16 2251-2252
  byte   HPNJU16 2253-2254
  byte   HPNJL16 2255-2256
  byte   HPNAU16 2257-2258
  byte   HPNSE16 2259-2260
  byte   HPNOC16 2261-2262
  byte   HPNNO16 2263-2264
  byte   HPNDE16 2265-2266
  byte   HPOJA16 2267-2268
  byte   HPOFE16 2269-2270
  byte   HPOMA16 2271-2272
  byte   HPOAP16 2273-2274
  byte   HPOMY16 2275-2276
  byte   HPOJU16 2277-2278
  byte   HPOJL16 2279-2280
  byte   HPOAU16 2281-2282
  byte   HPOSE16 2283-2284
  byte   HPOOC16 2285-2286
  byte   HPONO16 2287-2288
  byte   HPODE16 2289-2290
  byte   HPSJA16 2291-2292
  byte   HPSFE16 2293-2294
  byte   HPSMA16 2295-2296
  byte   HPSAP16 2297-2298
  byte   HPSMY16 2299-2300
  byte   HPSJU16 2301-2302
  byte   HPSJL16 2303-2304
  byte   HPSAU16 2305-2306
  byte   HPSSE16 2307-2308
  byte   HPSOC16 2309-2310
  byte   HPSNO16 2311-2312
  byte   HPSDE16 2313-2314
  byte   HPXJA16 2315-2316
  byte   HPXFE16 2317-2318
  byte   HPXMA16 2319-2320
  byte   HPXAP16 2321-2322
  byte   HPXMY16 2323-2324
  byte   HPXJU16 2325-2326
  byte   HPXJL16 2327-2328
  byte   HPXAU16 2329-2330
  byte   HPXSE16 2331-2332
  byte   HPXOC16 2333-2334
  byte   HPXNO16 2335-2336
  byte   HPXDE16 2337-2338
  byte   HPRJA16 2339-2340
  byte   HPRFE16 2341-2342
  byte   HPRMA16 2343-2344
  byte   HPRAP16 2345-2346
  byte   HPRMY16 2347-2348
  byte   HPRJU16 2349-2350
  byte   HPRJL16 2351-2352
  byte   HPRAU16 2353-2354
  byte   HPRSE16 2355-2356
  byte   HPROC16 2357-2358
  byte   HPRNO16 2359-2360
  byte   HPRDE16 2361-2362
  byte   INSJA16X 2363-2364
  byte   INSFE16X 2365-2366
  byte   INSMA16X 2367-2368
  byte   INSAP16X 2369-2370
  byte   INSMY16X 2371-2372
  byte   INSJU16X 2373-2374
  byte   INSJL16X 2375-2376
  byte   INSAU16X 2377-2378
  byte   INSSE16X 2379-2380
  byte   INSOC16X 2381-2382
  byte   INSNO16X 2383-2384
  byte   INSDE16X 2385-2386
  byte   PRVEV16 2387-2387
  byte   TRIEV16 2388-2388
  byte   MCREV16 2389-2389
  byte   MCDEV16 2390-2390
  byte   OPAEV16 2391-2391
  byte   OPBEV16 2392-2392
  byte   UNINS16 2393-2393
  byte   INSCOV16 2394-2394
  byte   INSURC16 2395-2395
  byte   TRIST31X 2396-2397
  byte   TRIST42X 2398-2399
  byte   TRIST16X 2400-2401
  byte   TRIPR31X 2402-2403
  byte   TRIPR42X 2404-2405
  byte   TRIPR16X 2406-2407
  byte   TRIEX31X 2408-2409
  byte   TRIEX42X 2410-2411
  byte   TRIEX16X 2412-2413
  byte   TRILI31X 2414-2415
  byte   TRILI42X 2416-2417
  byte   TRILI16X 2418-2419
  byte   TRICH31X 2420-2421
  byte   TRICH42X 2422-2423
  byte   TRICH16X 2424-2425
  byte   MCRPD31 2426-2427
  byte   MCRPD42 2428-2429
  byte   MCRPD16 2430-2431
  byte   MCRPD31X 2432-2433
  byte   MCRPD42X 2434-2435
  byte   MCRPD16X 2436-2437
  byte   MCRPB31 2438-2439
  byte   MCRPB42 2440-2441
  byte   MCRPB16 2442-2443
  byte   MCRPHO31 2444-2445
  byte   MCRPHO42 2446-2447
  byte   MCRPHO16 2448-2449
  byte   MCDHMO31 2450-2451
  byte   MCDHMO42 2452-2453
  byte   MCDHMO16 2454-2455
  byte   MCDMC31 2456-2457
  byte   MCDMC42 2458-2459
  byte   MCDMC16 2460-2461
  byte   PRVHMO31 2462-2463
  byte   PRVHMO42 2464-2465
  byte   PRVHMO16 2466-2467
  byte   FSAGT31 2468-2469
  byte   HASFSA31 2470-2471
  double FSAAMT31 2472-2478
  byte   PROBPY42 2479-2480
  byte   CRFMPY42 2481-2482
  byte   PYUNBL42 2483-2484
  byte   PREVCOVR 2485-2486
  byte   COVRMM 2487-2488
  int    COVRYY 2489-2492
  byte   WASESTB 2493-2494
  byte   WASMCARE 2495-2496
  byte   WASMCAID 2497-2498
  byte   WASCHAMP 2499-2500
  byte   WASVA 2501-2502
  byte   WASPRIV 2503-2504
  byte   WASOTGOV 2505-2506
  byte   WASAFDC 2507-2508
  byte   WASSSI 2509-2510
  byte   WASSTAT1 2511-2512
  byte   WASSTAT2 2513-2514
  byte   WASSTAT3 2515-2516
  byte   WASSTAT4 2517-2518
  byte   WASOTHER 2519-2520
  byte   NOINSBEF 2521-2522
  byte   NOINSTM 2523-2524
  byte   NOINUNIT 2525-2526
  byte   MORECOVR 2527-2528
  byte   INSENDMM 2529-2530
  int    INSENDYY 2531-2534
  byte   TRICR31X 2535-2536
  byte   TRICR42X 2537-2538
  byte   TRICR53X 2539-2540
  byte   TRICR16X 2541-2542
  byte   TRIAT31X 2543-2544
  byte   TRIAT42X 2545-2546
  byte   TRIAT53X 2547-2548
  byte   TRIAT16X 2549-2550
  byte   MCAID31 2551-2552
  byte   MCAID42 2553-2554
  byte   MCAID53 2555-2556
  byte   MCAID16 2557-2558
  byte   MCAID31X 2559-2560
  byte   MCAID42X 2561-2562
  byte   MCAID53X 2563-2564
  byte   MCAID16X 2565-2566
  byte   MCARE31 2567-2568
  byte   MCARE42 2569-2570
  byte   MCARE53 2571-2572
  byte   MCARE16 2573-2574
  byte   MCARE31X 2575-2576
  byte   MCARE42X 2577-2578
  byte   MCARE53X 2579-2580
  byte   MCARE16X 2581-2582
  byte   MCDAT31X 2583-2584
  byte   MCDAT42X 2585-2586
  byte   MCDAT53X 2587-2588
  byte   MCDAT16X 2589-2590
  byte   OTPAAT31 2591-2592
  byte   OTPAAT42 2593-2594
  byte   OTPAAT53 2595-2596
  byte   OTPAAT16 2597-2598
  byte   OTPBAT31 2599-2600
  byte   OTPBAT42 2601-2602
  byte   OTPBAT53 2603-2604
  byte   OTPBAT16 2605-2606
  byte   OTPUBA31 2607-2608
  byte   OTPUBA42 2609-2610
  byte   OTPUBA53 2611-2612
  byte   OTPUBA16 2613-2614
  byte   OTPUBB31 2615-2616
  byte   OTPUBB42 2617-2618
  byte   OTPUBB53 2619-2620
  byte   OTPUBB16 2621-2622
  byte   PRIDK31 2623-2624
  byte   PRIDK42 2625-2626
  byte   PRIDK53 2627-2628
  byte   PRIDK16 2629-2630
  byte   PRIEU31 2631-2632
  byte   PRIEU42 2633-2634
  byte   PRIEU53 2635-2636
  byte   PRIEU16 2637-2638
  byte   PRING31 2639-2640
  byte   PRING42 2641-2642
  byte   PRING53 2643-2644
  byte   PRING16 2645-2646
  byte   PRIOG31 2647-2648
  byte   PRIOG42 2649-2650
  byte   PRIOG53 2651-2652
  byte   PRIOG16 2653-2654
  byte   PRIS31 2655-2656
  byte   PRIS42 2657-2658
  byte   PRIS53 2659-2660
  byte   PRIS16 2661-2662
  byte   PROUT31 2663-2664
  byte   PROUT42 2665-2666
  byte   PROUT53 2667-2668
  byte   PROUT16 2669-2670
  byte   PRSTX31 2671-2672
  byte   PRSTX42 2673-2674
  byte   PRSTX53 2675-2676
  byte   PRSTX16 2677-2678
  byte   PRIV31 2679-2680
  byte   PRIV42 2681-2682
  byte   PRIV53 2683-2684
  byte   PRIV16 2685-2686
  byte   PRIVAT31 2687-2688
  byte   PRIVAT42 2689-2690
  byte   PRIVAT53 2691-2692
  byte   PRIVAT16 2693-2694
  byte   PUB31X 2695-2696
  byte   PUB42X 2697-2698
  byte   PUB53X 2699-2700
  byte   PUB16X 2701-2702
  byte   PUBAT31X 2703-2704
  byte   PUBAT42X 2705-2706
  byte   PUBAT53X 2707-2708
  byte   PUBAT16X 2709-2710
  byte   INS31X 2711-2712
  byte   INS42X 2713-2714
  byte   INS53X 2715-2716
  byte   INS16X 2717-2718
  byte   INSAT31X 2719-2720
  byte   INSAT42X 2721-2722
  byte   INSAT53X 2723-2724
  byte   INSAT16X 2725-2726
  byte   STAPR31 2727-2728
  byte   STAPR42 2729-2730
  byte   STAPR53 2731-2732
  byte   STAPR16 2733-2734
  byte   STPRAT31 2735-2736
  byte   STPRAT42 2737-2738
  byte   STPRAT53 2739-2740
  byte   STPRAT16 2741-2742
  byte   DENTIN31 2743-2744
  byte   DENTIN42 2745-2746
  byte   DENTIN53 2747-2748
  byte   DNTINS31 2749-2750
  byte   DNTINS16 2751-2752
  byte   PMEDIN31 2753-2754
  byte   PMEDIN42 2755-2756
  byte   PMEDIN53 2757-2758
  byte   PMDINS31 2759-2760
  byte   PMDINS16 2761-2762
  byte   PMEDUP31 2763-2764
  byte   PMEDUP42 2765-2766
  byte   PMEDUP53 2767-2768
  byte   PMEDPY31 2769-2770
  byte   PMEDPY42 2771-2772
  byte   PMEDPY53 2773-2774
  long   TOTTCH16 2775-2781
  long   TOTEXP16 2782-2787
  long   TOTSLF16 2788-2793
  long   TOTMCR16 2794-2799
  long   TOTMCD16 2800-2805
  long   TOTPRV16 2806-2811
  long   TOTVA16 2812-2817
  long   TOTTRI16 2818-2822
  long   TOTOFD16 2823-2827
  long   TOTSTL16 2828-2832
  long   TOTWCP16 2833-2838
  long   TOTOPR16 2839-2844
  long   TOTOPU16 2845-2850
  long   TOTOSR16 2851-2856
  long   TOTPTR16 2857-2862
  long   TOTOTH16 2863-2868
  int    OBTOTV16 2869-2871
  long   OBVTCH16 2872-2878
  long   OBVEXP16 2879-2884
  long   OBVSLF16 2885-2889
  long   OBVMCR16 2890-2895
  long   OBVMCD16 2896-2901
  long   OBVPRV16 2902-2907
  long   OBVVA16 2908-2912
  long   OBVTRI16 2913-2917
  long   OBVOFD16 2918-2922
  long   OBVSTL16 2923-2927
  long   OBVWCP16 2928-2933
  long   OBVOPR16 2934-2938
  long   OBVOPU16 2939-2944
  long   OBVOSR16 2945-2950
  long   OBVPTR16 2951-2956
  long   OBVOTH16 2957-2962
  int    OBDRV16 2963-2965
  long   OBDTCH16 2966-2971
  long   OBDEXP16 2972-2977
  long   OBDSLF16 2978-2982
  long   OBDMCR16 2983-2987
  long   OBDMCD16 2988-2992
  long   OBDPRV16 2993-2998
  long   OBDVA16 2999-3003
  long   OBDTRI16 3004-3008
  int    OBDOFD16 3009-3012
  long   OBDSTL16 3013-3017
  long   OBDWCP16 3018-3023
  long   OBDOPR16 3024-3028
  long   OBDOPU16 3029-3034
  long   OBDOSR16 3035-3040
  long   OBDPTR16 3041-3046
  long   OBDOTH16 3047-3052
  int    OBOTHV16 3053-3055
  long   OBOTCH16 3056-3062
  long   OBOEXP16 3063-3068
  long   OBOSLF16 3069-3073
  long   OBOMCR16 3074-3078
  long   OBOMCD16 3079-3084
  long   OBOPRV16 3085-3089
  long   OBOVA16 3090-3094
  long   OBOTRI16 3095-3099
  long   OBOOFD16 3100-3104
  int    OBOSTL16 3105-3108
  long   OBOWCP16 3109-3113
  long   OBOOPR16 3114-3118
  int    OBOOPU16 3119-3122
  long   OBOOSR16 3123-3127
  long   OBOPTR16 3128-3132
  long   OBOOTH16 3133-3137
  byte   OBCHIR16 3138-3139
  long   OBCTCH16 3140-3145
  long   OBCEXP16 3146-3150
  long   OBCSLF16 3151-3155
  long   OBCMCR16 3156-3160
  int    OBCMCD16 3161-3164
  int    OBCPRV16 3165-3168
  int    OBCVA16 3169-3171
  int    OBCTRI16 3172-3175
  byte   OBCOFD16 3176-3176
  int    OBCSTL16 3177-3179
  long   OBCWCP16 3180-3184
  int    OBCOPR16 3185-3188
  int    OBCOPU16 3189-3191
  long   OBCOSR16 3192-3196
  int    OBCPTR16 3197-3200
  long   OBCOTH16 3201-3205
  int    OBNURS16 3206-3208
  long   OBNTCH16 3209-3215
  long   OBNEXP16 3216-3220
  int    OBNSLF16 3221-3224
  long   OBNMCR16 3225-3229
  long   OBNMCD16 3230-3234
  long   OBNPRV16 3235-3239
  long   OBNVA16 3240-3244
  int    OBNTRI16 3245-3248
  long   OBNOFD16 3249-3253
  int    OBNSTL16 3254-3256
  int    OBNWCP16 3257-3259
  long   OBNOPR16 3260-3264
  int    OBNOPU16 3265-3268
  long   OBNOSR16 3269-3273
  long   OBNPTR16 3274-3278
  long   OBNOTH16 3279-3283
  byte   OBOPTO16 3284-3285
  long   OBETCH16 3286-3290
  int    OBEEXP16 3291-3294
  int    OBESLF16 3295-3298
  int    OBEMCR16 3299-3302
  int    OBEMCD16 3303-3306
  int    OBEPRV16 3307-3310
  int    OBEVA16 3311-3314
  int    OBETRI16 3315-3317
  int    OBEOFD16 3318-3320
  byte   OBESTL16 3321-3321
  int    OBEWCP16 3322-3324
  int    OBEOPR16 3325-3327
  int    OBEOPU16 3328-3330
  int    OBEOSR16 3331-3333
  int    OBEPTR16 3334-3337
  int    OBEOTH16 3338-3340
  byte   OBASST16 3341-3342
  long   OBATCH16 3343-3347
  long   OBAEXP16 3348-3352
  int    OBASLF16 3353-3356
  int    OBAMCR16 3357-3360
  int    OBAMCD16 3361-3364
  int    OBAPRV16 3365-3368
  int    OBAVA16 3369-3372
  int    OBATRI16 3373-3375
  int    OBAOFD16 3376-3378
  int    OBASTL16 3379-3381
  int    OBAWCP16 3382-3384
  int    OBAOPR16 3385-3388
  byte   OBAOPU16 3389-3390
  int    OBAOSR16 3391-3394
  int    OBAPTR16 3395-3398
  int    OBAOTH16 3399-3402
  int    OBTHER16 3403-3405
  long   OBTTCH16 3406-3411
  long   OBTEXP16 3412-3416
  int    OBTSLF16 3417-3420
  long   OBTMCR16 3421-3425
  long   OBTMCD16 3426-3430
  long   OBTPRV16 3431-3435
  int    OBTVA16 3436-3439
  long   OBTTRI16 3440-3444
  int    OBTOFD16 3445-3447
  int    OBTSTL16 3448-3451
  long   OBTWCP16 3452-3456
  int    OBTOPR16 3457-3460
  int    OBTOPU16 3461-3464
  long   OBTOSR16 3465-3469
  long   OBTPTR16 3470-3474
  long   OBTOTH16 3475-3479
  int    OPTOTV16 3480-3482
  long   OPTTCH16 3483-3488
  long   OPTEXP16 3489-3494
  long   OPTSLF16 3495-3499
  long   OPTMCR16 3500-3505
  long   OPTMCD16 3506-3511
  long   OPTPRV16 3512-3517
  long   OPTVA16 3518-3522
  long   OPTTRI16 3523-3527
  int    OPTOFD16 3528-3531
  int    OPTSTL16 3532-3535
  long   OPTWCP16 3536-3540
  long   OPTOPR16 3541-3545
  int    OPTOPU16 3546-3549
  long   OPTOSR16 3550-3554
  long   OPTPTR16 3555-3560
  long   OPTOTH16 3561-3565
  long   OPFTCH16 3566-3571
  long   OPFEXP16 3572-3577
  long   OPFSLF16 3578-3582
  long   OPFMCR16 3583-3588
  long   OPFMCD16 3589-3594
  long   OPFPRV16 3595-3600
  long   OPFVA16 3601-3605
  long   OPFTRI16 3606-3610
  int    OPFOFD16 3611-3614
  int    OPFSTL16 3615-3618
  long   OPFWCP16 3619-3623
  long   OPFOPR16 3624-3628
  int    OPFOPU16 3629-3632
  long   OPFOSR16 3633-3637
  long   OPFPTR16 3638-3643
  long   OPFOTH16 3644-3648
  long   OPDEXP16 3649-3653
  long   OPDTCH16 3654-3659
  int    OPDSLF16 3660-3663
  long   OPDMCR16 3664-3668
  int    OPDMCD16 3669-3672
  long   OPDPRV16 3673-3677
  int    OPDVA16 3678-3681
  int    OPDTRI16 3682-3685
  byte   OPDOFD16 3686-3687
  byte   OPDSTL16 3688-3689
  int    OPDWCP16 3690-3693
  int    OPDOPR16 3694-3697
  int    OPDOPU16 3698-3701
  long   OPDOSR16 3702-3706
  long   OPDPTR16 3707-3711
  long   OPDOTH16 3712-3716
  byte   OPDRV16 3717-3718
  long   OPVTCH16 3719-3724
  long   OPVEXP16 3725-3730
  int    OPVSLF16 3731-3734
  long   OPVMCR16 3735-3739
  long   OPVMCD16 3740-3744
  long   OPVPRV16 3745-3750
  long   OPVVA16 3751-3755
  long   OPVTRI16 3756-3760
  int    OPVOFD16 3761-3764
  int    OPVSTL16 3765-3768
  long   OPVWCP16 3769-3773
  long   OPVOPR16 3774-3778
  int    OPVOPU16 3779-3782
  int    OPVOSR16 3783-3786
  long   OPVPTR16 3787-3792
  long   OPVOTH16 3793-3797
  long   OPSEXP16 3798-3802
  long   OPSTCH16 3803-3808
  int    OPSSLF16 3809-3812
  int    OPSMCR16 3813-3816
  int    OPSMCD16 3817-3820
  long   OPSPRV16 3821-3825
  int    OPSVA16 3826-3829
  int    OPSTRI16 3830-3832
  byte   OPSOFD16 3833-3833
  byte   OPSSTL16 3834-3835
  int    OPSWCP16 3836-3839
  int    OPSOPR16 3840-3843
  int    OPSOPU16 3844-3847
  int    OPSOSR16 3848-3851
  long   OPSPTR16 3852-3856
  int    OPSOTH16 3857-3860
  int    OPOTHV16 3861-3863
  long   OPOTCH16 3864-3869
  long   OPOEXP16 3870-3875
  long   OPOSLF16 3876-3880
  long   OPOMCR16 3881-3886
  long   OPOMCD16 3887-3892
  long   OPOPRV16 3893-3897
  long   OPOVA16 3898-3902
  int    OPOTRI16 3903-3906
  int    OPOOFD16 3907-3909
  int    OPOSTL16 3910-3913
  int    OPOWCP16 3914-3917
  int    OPOOPR16 3918-3921
  int    OPOOPU16 3922-3924
  int    OPOOSR16 3925-3928
  long   OPOPTR16 3929-3933
  int    OPOOTH16 3934-3937
  long   OPPEXP16 3938-3942
  long   OPPTCH16 3943-3947
  int    OPPSLF16 3948-3951
  long   OPPMCR16 3952-3956
  int    OPPMCD16 3957-3960
  int    OPPPRV16 3961-3964
  int    OPPVA16 3965-3967
  int    OPPTRI16 3968-3971
  byte   OPPOFD16 3972-3973
  byte   OPPSTL16 3974-3975
  int    OPPWCP16 3976-3979
  int    OPPOPR16 3980-3982
  int    OPPOPU16 3983-3985
  long   OPPOSR16 3986-3990
  int    OPPPTR16 3991-3994
  long   OPPOTH16 3995-3999
  byte   AMCHIR16 4000-4001
  long   AMCTCH16 4002-4007
  long   AMCEXP16 4008-4012
  long   AMCSLF16 4013-4017
  long   AMCMCR16 4018-4022
  int    AMCMCD16 4023-4026
  int    AMCPRV16 4027-4030
  int    AMCVA16 4031-4033
  int    AMCTRI16 4034-4037
  byte   AMCOFD16 4038-4038
  int    AMCSTL16 4039-4041
  long   AMCWCP16 4042-4046
  int    AMCOPR16 4047-4050
  int    AMCOPU16 4051-4053
  long   AMCOSR16 4054-4058
  int    AMCPTR16 4059-4062
  long   AMCOTH16 4063-4067
  int    AMNURS16 4068-4070
  long   AMNTCH16 4071-4077
  long   AMNEXP16 4078-4083
  int    AMNSLF16 4084-4087
  long   AMNMCR16 4088-4092
  long   AMNMCD16 4093-4098
  long   AMNPRV16 4099-4103
  long   AMNVA16 4104-4108
  int    AMNTRI16 4109-4112
  long   AMNOFD16 4113-4117
  int    AMNSTL16 4118-4121
  int    AMNWCP16 4122-4125
  long   AMNOPR16 4126-4130
  int    AMNOPU16 4131-4134
  long   AMNOSR16 4135-4139
  long   AMNPTR16 4140-4144
  long   AMNOTH16 4145-4149
  byte   AMOPTO16 4150-4151
  long   AMETCH16 4152-4156
  int    AMEEXP16 4157-4160
  int    AMESLF16 4161-4164
  int    AMEMCR16 4165-4168
  int    AMEMCD16 4169-4172
  int    AMEPRV16 4173-4176
  int    AMEVA16 4177-4180
  int    AMETRI16 4181-4183
  int    AMEOFD16 4184-4186
  byte   AMESTL16 4187-4187
  int    AMEWCP16 4188-4191
  int    AMEOPR16 4192-4194
  int    AMEOPU16 4195-4197
  int    AMEOSR16 4198-4200
  int    AMEPTR16 4201-4204
  int    AMEOTH16 4205-4207
  byte   AMASST16 4208-4209
  long   AMATCH16 4210-4214
  long   AMAEXP16 4215-4219
  int    AMASLF16 4220-4223
  int    AMAMCR16 4224-4227
  int    AMAMCD16 4228-4231
  long   AMAPRV16 4232-4236
  int    AMAVA16 4237-4240
  int    AMATRI16 4241-4243
  int    AMAOFD16 4244-4246
  int    AMASTL16 4247-4249
  int    AMAWCP16 4250-4252
  int    AMAOPR16 4253-4256
  byte   AMAOPU16 4257-4258
  int    AMAOSR16 4259-4262
  long   AMAPTR16 4263-4267
  int    AMAOTH16 4268-4271
  int    AMTHER16 4272-4274
  long   AMTTCH16 4275-4280
  long   AMTEXP16 4281-4285
  int    AMTSLF16 4286-4289
  long   AMTMCR16 4290-4294
  long   AMTMCD16 4295-4299
  long   AMTPRV16 4300-4304
  long   AMTVA16 4305-4309
  long   AMTTRI16 4310-4314
  int    AMTOFD16 4315-4317
  int    AMTSTL16 4318-4321
  long   AMTWCP16 4322-4326
  int    AMTOPR16 4327-4330
  int    AMTOPU16 4331-4334
  long   AMTOSR16 4335-4339
  long   AMTPTR16 4340-4344
  long   AMTOTH16 4345-4349
  byte   AMTOTC16 4350-4351
  byte   AMDRC16 4352-4352
  byte   ERTOT16 4353-4354
  long   ERTTCH16 4355-4360
  long   ERTEXP16 4361-4366
  long   ERTSLF16 4367-4371
  long   ERTMCR16 4372-4376
  long   ERTMCD16 4377-4381
  long   ERTPRV16 4382-4387
  long   ERTVA16 4388-4392
  long   ERTTRI16 4393-4397
  int    ERTOFD16 4398-4401
  int    ERTSTL16 4402-4405
  long   ERTWCP16 4406-4410
  long   ERTOPR16 4411-4415
  int    ERTOPU16 4416-4419
  long   ERTOSR16 4420-4424
  long   ERTPTR16 4425-4430
  long   ERTOTH16 4431-4435
  long   ERFTCH16 4436-4441
  long   ERFEXP16 4442-4447
  long   ERFSLF16 4448-4452
  long   ERFMCR16 4453-4457
  long   ERFMCD16 4458-4462
  long   ERFPRV16 4463-4468
  long   ERFVA16 4469-4473
  long   ERFTRI16 4474-4478
  int    ERFOFD16 4479-4482
  int    ERFSTL16 4483-4486
  long   ERFWCP16 4487-4491
  long   ERFOPR16 4492-4496
  int    ERFOPU16 4497-4500
  long   ERFOSR16 4501-4505
  long   ERFPTR16 4506-4511
  long   ERFOTH16 4512-4516
  int    ERDEXP16 4517-4520
  long   ERDTCH16 4521-4525
  int    ERDSLF16 4526-4529
  int    ERDMCR16 4530-4533
  int    ERDMCD16 4534-4537
  int    ERDPRV16 4538-4541
  int    ERDVA16 4542-4545
  int    ERDTRI16 4546-4548
  byte   ERDOFD16 4549-4549
  int    ERDSTL16 4550-4552
  int    ERDWCP16 4553-4556
  int    ERDOPR16 4557-4560
  int    ERDOPU16 4561-4563
  int    ERDOSR16 4564-4567
  int    ERDPTR16 4568-4571
  int    ERDOTH16 4572-4575
  byte   IPZERO16 4576-4576
  long   ZIFTCH16 4577-4582
  long   ZIFEXP16 4583-4587
  int    ZIFSLF16 4588-4591
  long   ZIFMCR16 4592-4596
  long   ZIFMCD16 4597-4601
  long   ZIFPRV16 4602-4606
  int    ZIFVA16 4607-4609
  int    ZIFTRI16 4610-4613
  byte   ZIFOFD16 4614-4614
  byte   ZIFSTL16 4615-4616
  byte   ZIFWCP16 4617-4617
  byte   ZIFOPR16 4618-4618
  int    ZIFOPU16 4619-4621
  int    ZIFOSR16 4622-4625
  long   ZIFPTR16 4626-4630
  int    ZIFOTH16 4631-4634
  long   ZIDEXP16 4635-4639
  long   ZIDTCH16 4640-4644
  int    ZIDSLF16 4645-4647
  int    ZIDMCR16 4648-4651
  long   ZIDMCD16 4652-4656
  int    ZIDPRV16 4657-4660
  byte   ZIDVA16 4661-4661
  int    ZIDTRI16 4662-4664
  byte   ZIDOFD16 4665-4665
  byte   ZIDSTL16 4666-4666
  byte   ZIDWCP16 4667-4667
  byte   ZIDOPR16 4668-4669
  int    ZIDOPU16 4670-4672
  int    ZIDOSR16 4673-4675
  int    ZIDPTR16 4676-4679
  int    ZIDOTH16 4680-4682
  byte   IPDIS16 4683-4683
  long   IPTEXP16 4684-4689
  long   IPTTCH16 4690-4696
  long   IPTSLF16 4697-4701
  long   IPTMCR16 4702-4707
  long   IPTMCD16 4708-4713
  long   IPTPRV16 4714-4719
  long   IPTVA16 4720-4725
  long   IPTTRI16 4726-4730
  long   IPTOFD16 4731-4735
  long   IPTSTL16 4736-4740
  long   IPTWCP16 4741-4745
  long   IPTOPR16 4746-4751
  long   IPTOPU16 4752-4756
  long   IPTOSR16 4757-4762
  long   IPTPTR16 4763-4768
  long   IPTOTH16 4769-4774
  long   IPFEXP16 4775-4780
  long   IPFTCH16 4781-4787
  long   IPFSLF16 4788-4792
  long   IPFMCR16 4793-4798
  long   IPFMCD16 4799-4804
  long   IPFPRV16 4805-4810
  long   IPFVA16 4811-4816
  long   IPFTRI16 4817-4821
  long   IPFOFD16 4822-4826
  long   IPFSTL16 4827-4831
  long   IPFWCP16 4832-4836
  long   IPFOPR16 4837-4842
  long   IPFOPU16 4843-4847
  long   IPFOSR16 4848-4853
  long   IPFPTR16 4854-4859
  long   IPFOTH16 4860-4865
  long   IPDEXP16 4866-4870
  long   IPDTCH16 4871-4876
  int    IPDSLF16 4877-4880
  long   IPDMCR16 4881-4885
  long   IPDMCD16 4886-4890
  long   IPDPRV16 4891-4895
  int    IPDVA16 4896-4899
  int    IPDTRI16 4900-4903
  byte   IPDOFD16 4904-4904
  int    IPDSTL16 4905-4907
  int    IPDWCP16 4908-4911
  int    IPDOPR16 4912-4915
  int    IPDOPU16 4916-4919
  long   IPDOSR16 4920-4924
  long   IPDPTR16 4925-4929
  long   IPDOTH16 4930-4934
  int    IPNGTD16 4935-4937
  byte   DVTOT16 4938-4939
  long   DVTTCH16 4940-4944
  long   DVTEXP16 4945-4949
  long   DVTSLF16 4950-4954
  int    DVTMCR16 4955-4958
  long   DVTMCD16 4959-4963
  long   DVTPRV16 4964-4968
  int    DVTVA16 4969-4972
  long   DVTTRI16 4973-4977
  int    DVTOFD16 4978-4981
  int    DVTSTL16 4982-4984
  int    DVTWCP16 4985-4987
  int    DVTOPR16 4988-4991
  int    DVTOPU16 4992-4995
  int    DVTOSR16 4996-4999
  long   DVTPTR16 5000-5004
  int    DVTOTH16 5005-5008
  byte   DVGEN16 5009-5010
  long   DVGTCH16 5011-5015
  long   DVGEXP16 5016-5020
  long   DVGSLF16 5021-5025
  int    DVGMCR16 5026-5029
  long   DVGMCD16 5030-5034
  long   DVGPRV16 5035-5039
  int    DVGVA16 5040-5043
  int    DVGTRI16 5044-5047
  int    DVGOFD16 5048-5051
  int    DVGSTL16 5052-5054
  int    DVGWCP16 5055-5057
  int    DVGOPR16 5058-5061
  int    DVGOPU16 5062-5065
  int    DVGOSR16 5066-5069
  long   DVGPTR16 5070-5074
  int    DVGOTH16 5075-5078
  byte   DVORTH16 5079-5080
  long   DVOTCH16 5081-5085
  long   DVOEXP16 5086-5090
  long   DVOSLF16 5091-5095
  int    DVOMCR16 5096-5099
  long   DVOMCD16 5100-5104
  long   DVOPRV16 5105-5109
  byte   DVOVA16 5110-5111
  int    DVOTRI16 5112-5115
  byte   DVOOFD16 5116-5116
  int    DVOSTL16 5117-5119
  byte   DVOWCP16 5120-5120
  int    DVOOPR16 5121-5124
  byte   DVOOPU16 5125-5126
  int    DVOOSR16 5127-5130
  long   DVOPTR16 5131-5135
  int    DVOOTH16 5136-5139
  int    HHTOTD16 5140-5142
  int    HHAGD16 5143-5145
  long   HHATCH16 5146-5151
  long   HHAEXP16 5152-5157
  long   HHASLF16 5158-5162
  long   HHAMCR16 5163-5168
  long   HHAMCD16 5169-5174
  long   HHAPRV16 5175-5179
  long   HHAVA16 5180-5184
  byte   HHATRI16 5185-5185
  long   HHAOFD16 5186-5190
  long   HHASTL16 5191-5195
  byte   HHAWCP16 5196-5196
  long   HHAOPR16 5197-5201
  long   HHAOPU16 5202-5206
  long   HHAOSR16 5207-5211
  long   HHAPTR16 5212-5216
  long   HHAOTH16 5217-5221
  int    HHINDD16 5222-5224
  long   HHNTCH16 5225-5229
  long   HHNEXP16 5230-5234
  long   HHNSLF16 5235-5239
  long   HHNMCD16 5240-5244
  int    HHNMCR16 5245-5248
  int    HHNPRV16 5249-5252
  int    HHNVA16 5253-5256
  byte   HHNTRI16 5257-5258
  byte   HHNOFD16 5259-5259
  int    HHNSTL16 5260-5263
  byte   HHNWCP16 5264-5264
  long   HHNOPR16 5265-5269
  byte   HHNOPU16 5270-5270
  int    HHNOSR16 5271-5274
  int    HHNPTR16 5275-5278
  long   HHNOTH16 5279-5283
  int    HHINFD16 5284-5286
  int    VISEXP16 5287-5290
  int    VISTCH16 5291-5294
  int    VISSLF16 5295-5298
  int    VISMCR16 5299-5302
  int    VISMCD16 5303-5306
  int    VISPRV16 5307-5310
  int    VISVA16 5311-5314
  int    VISTRI16 5315-5318
  int    VISOFD16 5319-5322
  int    VISSTL16 5323-5325
  int    VISWCP16 5326-5328
  int    VISOPR16 5329-5332
  int    VISOPU16 5333-5335
  int    VISOSR16 5336-5339
  int    VISPTR16 5340-5343
  int    VISOTH16 5344-5347
  long   OTHTCH16 5348-5352
  long   OTHEXP16 5353-5357
  long   OTHSLF16 5358-5362
  int    OTHMCR16 5363-5366
  int    OTHMCD16 5367-5370
  long   OTHPRV16 5371-5375
  int    OTHVA16 5376-5379
  int    OTHTRI16 5380-5383
  int    OTHOFD16 5384-5386
  byte   OTHSTL16 5387-5387
  int    OTHWCP16 5388-5391
  int    OTHOPR16 5392-5395
  int    OTHOPU16 5396-5399
  long   OTHOSR16 5400-5404
  long   OTHPTR16 5405-5409
  long   OTHOTH16 5410-5414
  int    RXTOT16 5415-5417
  long   RXEXP16 5418-5423
  long   RXSLF16 5424-5428
  long   RXMCR16 5429-5434
  long   RXMCD16 5435-5439
  long   RXPRV16 5440-5445
  long   RXVA16 5446-5450
  long   RXTRI16 5451-5455
  long   RXOFD16 5456-5460
  long   RXSTL16 5461-5465
  long   RXWCP16 5466-5470
  long   RXOPR16 5471-5475
  long   RXOPU16 5476-5480
  long   RXOSR16 5481-5485
  long   RXPTR16 5486-5491
  long   RXOTH16 5492-5496
  double PERWT16F 5497-5508
  double FAMWT16F 5509-5520
  double FAMWT16C 5521-5532
  double SAQWT16F 5533-5545
  double DIABW16F 5546-5557
  double CSAQW16F 5558-5569
  int    VARSTR 5570-5573
  byte   VARPSU 5574-5574
using H192.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSON ID (DUID + PID)";
label variable PANEL "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID16 "FAMILY ID (STUDENT MERGED IN) - 12/31/16";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR16 "RU LETTER AS OF 12/31/16";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE16 "RU SIZE AS OF 12/31/16";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS16 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/16";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE16 "RU SIZE INCLUDING STUDENT AS OF 12/31/16";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION16 "CENSUS REGION AS OF 12/31/16";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS16 "REFERENCE PERSON AS OF 12/31/16";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP16 "1ST RESPONDENT INDICATOR AS OF 12/31/16";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY16 "WAS RESPONDENT A PROXY AS OF 12/31/16";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFM16 "2016 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY16 "2016 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP16 "INSCOPE - R5/3 START THROUGH 12/31/16";
label variable INSC1231 "INSCOPE STATUS ON 12/31/16";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2016";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND16 "ELIGIBILITY STATUS AS OF 12/31/16";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE16X "AGE AS OF 12/31/16 (EDITED/IMPUTED)";
label variable AGELAST "PERSON S AGE LAST TIME ELIGIBLE";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEV1X "RACE (EDITED/IMPUTED)";
label variable RACEV2X "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPNCAT "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY16X "MARITAL STATUS-12/31/16 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID16 "SPOUSE ID - 12/31/16";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN16 "MARITAL STATUS W/SPOUSE PRESENT-12/31/16";
label variable EDUCYR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable HIDEG "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU16X "STUDENT STATUS IF AGES 17-23 - 12/31/16";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable HONRDC31 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC42 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC53 "HONORABLY DISCHARGED FROM MILITARY";
label variable REFRL31X "RELATION TO REF PERS- R3/1 (EDIT/IMP)";
label variable REFRL42X "RELATION TO REF PERS- R4/2 (EDIT/IMP)";
label variable REFRL53X "RELATION TO REF PERS- R5/3 (EDIT/IMP)";
label variable REFRL16X "RELATION TO REF PERS-12/31/16 (EDIT/IMP)";
label variable OTHLANG "IN FAMILY WITH SOMEONE SPKNG OTHER LANG";
label variable LANGSPK "LANGUAGE SPOKEN AT HOME OTHER THAN ENGL";
label variable HWELLSPE "HOW WELL PERSON SPEAKS ENGLISH";
label variable BORNUSA "PERSON BORN IN THE US";
label variable YRSINUS "YEARS PERSON LIVED IN THE US";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable HIBPDX "HIGH BLOOD PRESSURE DIAG (>17)";
label variable HIBPAGED "AGE OF DIAGNOSIS-HIGH BLOOD PRESSURE";
label variable BPMLDX "MULT DIAG HIGH BLOOD PRESS (>17)";
label variable CHDDX "CORONARY HRT DISEASE DIAG (>17)";
label variable CHDAGED "AGE OF DIAGNOSIS-CORONARY HEART DISEASE";
label variable ANGIDX "ANGINA DIAGNOSIS (>17)";
label variable ANGIAGED "AGE OF DIAGNOSIS-ANGINA";
label variable MIDX "HEART ATTACK (MI) DIAG (>17)";
label variable MIAGED "AGE OF DIAGNOSIS-HEART ATTACK(MI)";
label variable OHRTDX "OTHER HEART DISEASE DIAG (>17)";
label variable OHRTAGED "AGE OF DIAGNOSIS-OTHER HEART DISEASE";
label variable STRKDX "STROKE DIAGNOSIS (>17)";
label variable STRKAGED "AGE OF DIAGNOSIS-STROKE";
label variable EMPHDX "EMPHYSEMA DIAGNOSIS (>17)";
label variable EMPHAGED "AGE OF DIAGNOSIS-EMPHYSEMA";
label variable CHBRON31 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R3/1";
label variable CHBRON53 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R5/3";
label variable CHOLDX "HIGH CHOLESTEROL DIAGNOSIS (>17)";
label variable CHOLAGED "AGE OF DIAGNOSIS-HIGH CHOLESTEROL";
label variable CANCERDX "CANCER DIAGNOSIS (>17)";
label variable CABLADDR "CANCER DIAGNOSED - BLADDER (>17)";
label variable CABREAST "CANCER DIAGNOSED - BREAST (>17)";
label variable CACERVIX "CANCER DIAGNOSED - CERVIX (>17)";
label variable CACOLON "CANCER DIAGNOSED - COLON (>17)";
label variable CALUNG "CANCER DIAGNOSED - LUNG (>17)";
label variable CALYMPH "CANCER DIAGNOSED - LYMPHOMA (>17)";
label variable CAMELANO "CANCER DIAGNOSED - MELANOMA (>17)";
label variable CAOTHER "CANCER DIAGNOSED - OTHER (>17)";
label variable CAPROSTA "CANCER DIAGNOSED - PROSTATE (>17)";
label variable CASKINNM "CANCER DIAGNOSED - SKIN-NONMELANO (>17)";
label variable CASKINDK "CANCER DIAGNOSED-SKIN-UNKNOWN TYPE (>17)";
label variable CAUTERUS "CANCER DIAGNOSED - UTERUS (>17)";
label variable DIABDX "DIABETES DIAGNOSIS (>17)";
label variable DIABAGED "AGE OF DIAGNOSIS-DIABETES";
label variable JTPAIN31 "JOINT PAIN LAST 12 MONTHS (>17) - RD 3/1";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable ARTHDX "ARTHRITIS DIAGNOSIS (>17)";
label variable ARTHTYPE "TYPE OF ARTHRITIS DIAGNOSED (>17)";
label variable ARTHAGED "AGE OF DIAGNOSIS-ARTHRITIS";
label variable ASTHDX "ASTHMA DIAGNOSIS";
label variable ASTHAGED "AGE OF DIAGNOSIS-ASTHMA";
label variable ASSTIL31 "DOES PERSON STILL HAVE ASTHMA-RD3/1";
label variable ASSTIL53 "DOES PERSON STILL HAVE ASTHMA - RD 5/3";
label variable ASATAK31 "ASTHMA ATTACK LAST 12 MOS - RD3/1";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASTHEP31 "WHEN WAS LAST EPISODE OF ASTHMA - RD 3/1";
label variable ASTHEP53 "WHEN WAS LAST EPISODE OF ASTHMA - RD 5/3";
label variable ASACUT53 "USED ACUTE PRES INHALER LAST 3 MOS-RD5/3";
label variable ASMRCN53 "USED>3ACUTE CN PRES INH LAST 3 MOS-RD5/3";
label variable ASPREV53 "EVER USED PREV DAILY ASTHMA MEDS -RD 5/3";
label variable ASDALY53 "NOW TAKE PREV DAILY ASTHMA MEDS - RD 5/3";
label variable ASPKFL53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable ASEVFL53 "EVER USED PEAK FLOW METER - RD 5/3";
label variable ASWNFL53 "WHEN LAST USED PEAK FLOW METER - RD 5/3";
label variable ADHDADDX "ADHDADD DIAGNOSIS (5-17)";
label variable ADHDAGED "AGE OF DIAGNOSIS-ADHD/ADD";
label variable PREGNT31 "PREGNANT DURING REF PERIOD - RD 3/1";
label variable PREGNT42 "PREGNANT DURING REF PERIOD - RD 4/2";
label variable PREGNT53 "PREGNANT DURING REF PERIOD - RD 5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable DFHEAR42 "SERIOUS DIFFICULTY HEARING-RD 4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable DFSEE42 "SERIOUS DIFFICULTY SEE W/GLASSES-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable DFCOG42 "SERIOUS COGNITIVE DIFFICULTIES-RD 4/2";
label variable DFWLKC42 "SERIOUS DIFCULTY WLK/CLIMB STAIRS-RD 4/2";
label variable DFDRSB42 "DIFFICULTY DRESSING/BATHING-RD 4/2";
label variable DFERND42 "DIFFICULTY DOING ERRANDS ALONE-RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable ANYLMT16 "ANY LIMITATION IN P20R3,4,5/P21R1,2,3";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNDCR42 "CAHPS:12MOS:NEED ANY CARE/TRT(0-17)-R4/2";
label variable CHENEC42 "CAHPS:12MOS:EASY GET NEC CARE (0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHEYRE42 "CAHPS:12MOS:ESY W/RFR TO SPEC(0-17)-R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (6-17)-R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU VACINATION (>17)-RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable BSTST53 "MST RCNT BLD STOOL TST HME KIT(>39)-R5/3";
label variable BSTSRE53 "RSN HAVE BLD STOOL TST (>39)-R5/3";
label variable CLNTST53 "MOST RECENT COLONOSCOPY (>39) - R5/3";
label variable CLNTRE53 "RSN HAVE COLONOSCOPY (>39)-R5/3";
label variable SGMTST53 "MOST RECENT SIGMOIDOSCOPY (>39) - R5/3";
label variable SGMTRE53 "RSN HAVE SIGMOIDOSCOPY (>39)-R5/3";
label variable PHYEXE53 "MOD/VIG PHYS EXEC 5X WK (>17) - RD 5/3";
label variable BMINDX53 "ADULT BODY MASS INDEX (>17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPRXY42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNDCR42 "SAQ 12MOS: NEED ANY CARE, TEST, TREATMNT";
label variable ADEGMC42 "SAQ 12MOS: EASY GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADINST42 "SAQ 12 MOS: DR GAVE SPCIFC INSTRCTNS";
label variable ADEZUN42 "SAQ 12 MOS: DR GIVEN INSTR. EZ UNDRSTD";
label variable ADTLHW42 "SAQ 12 MOS: DR ASKED R DESC HOW FOLLOW";
label variable ADFFRM42 "SAQ 12 MOS: HAD TO FILL OUT/SIGN FORMS";
label variable ADFHLP42 "SAQ 12 MOS: OFFRD HELP FILLING OUT FORMS";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADNSMK42 "SAQ 12MOS: DR ADVISED TO QUIT SMOKING";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADESSP42 "SAQ 12MOS: HOW ESY TO SEE SPECIALIST";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12V2";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12V2";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12V2";
label variable ADPALS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS SF-12V2";
label variable ADPWLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS SF-12V2";
label variable ADMALS42 "SAQ 4WKS:ACCMP LESS B/C MNT PRBS SF-12V2";
label variable ADMWLM42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS SF-12V2";
label variable ADPAIN42 "SAQ 4WKS:PAIN LIMITS NORMAL WORK SF-12V2";
label variable ADCAPE42 "SAQ 4WKS: FELT CALM/PEACEFUL SF-12V2";
label variable ADNRGY42 "SAQ 4WKS: HAD A LOT OF ENERGY SF-12V2";
label variable ADDOWN42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR SF-12V2";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV SF-12V2";
label variable PCS42 "SAQ:PHY COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable MCS42 "SAQ:MNT COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable SFFLAG42 "SAQ: PCS/MCS IMPUTATION FLAG SF-12V2";
label variable ADNERV42 "SAQ 30 DAYS: HOW OFTEN FELT NERVOUS";
label variable ADHOPE42 "SAQ 30 DAYS: HOW OFTEN FELT HOPELESS";
label variable ADREST42 "SAQ 30 DAYS: HOW OFTEN FELT RESTLESS";
label variable ADSAD42 "SAQ 30 DAYS: HOW OFTEN FELT SAD";
label variable ADEFRT42 "SAQ 30 DAYS: HOW OFTN EVRYTHNG AN EFFORT";
label variable ADWRTH42 "SAQ 30 DAYS: HOW OFTEN FELT WORTHLESS";
label variable K6SUM42 "SAQ 30 DAYS: OVERALL RATING OF FEELINGS";
label variable ADINTR42 "SAQ 2 WKS: LITTLE INTEREST IN THINGS";
label variable ADDPRS42 "SAQ 2 WKS: FELT DOWN/DEPRESSED/HOPELESS";
label variable PHQ242 "SAQ 2 WKS: OVERALL RATING OF FEELINGS";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C IN 2016";
label variable DSFT1753 "DCS: HAD FEET CHECKED DURING 2017";
label variable DSFT1653 "DCS: HAD FEET CHECKED DURING 2016";
label variable DSFT1553 "DCS: HAD FEET CHECKED DURING 2015";
label variable DSFB1553 "DCS: HAD FEET CHECKED BEFORE 2015";
label variable DSFTNV53 "DCS: NEVER HAD FEET CHECKED";
label variable DSEY1753 "DCS: DILATED EYE EXAM IN 2017";
label variable DSEY1653 "DCS: DILATED EYE EXAM IN 2016";
label variable DSEY1553 "DCS: DILATED EYE EXAM IN 2015";
label variable DSEB1553 "DCS: DILATED EYE EXAM BEFORE 2015";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSCH1753 "DCS: BLOOD CHOLESTEROL CHECKED IN 2017";
label variable DSCH1653 "DCS: BLOOD CHOLESTEROL CHECKED IN 2016";
label variable DSCH1553 "DCS: BLOOD CHOLESTEROL CHECKED IN 2015";
label variable DSCB1553 "DCS: BLOOD CHOLESTEROL CHECKED BEF 2015";
label variable DSCHNV53 "DCS: NEVER HAD BLOOD CHOLESTEROL CHECKED";
label variable DSFL1753 "DCS: GOT FLU VACCINATION IN 2017";
label variable DSFL1653 "DCS: GOT FLU VACCINATION IN 2016";
label variable DSFL1553 "DCS: GOT FLU VACCINATION IN 2015";
label variable DSVB1553 "DCS: GOT FLU VACCINATION BEFORE 2015";
label variable DSFLNV53 "DCS: NEVER GOT FLU VACCINATION";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSCPCP53 "DCS: LEARNED CARE FROM PRIMARY CARE PROV";
label variable DSCNPC53 "DCS: LEARNED CARE FROM OTHER PROVIDER";
label variable DSCPHN53 "DCS: LEARN CARE FROM PHONE CALL W/PROV";
label variable DSCINT53 "DCS: LEARNED CARE FROM READING INTERNET";
label variable DSCGRP53 "DCS: LEARNED CARE BY TAKING GROUP CLASS";
label variable DSCONF53 "DCS: CONFIDENT TAKING CARE OF DIABETES";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable CCNRDI31 "CSAQ: CANCER DIAGNOSIS BY HEALTH PROF";
label variable CDIAG31 "CSAQ: CANCER DIAGNOSIS BEFORE AGE 18";
label variable CTRTMT31 "CSAQ: CURRENTLY TREATED FOR CANCER";
label variable CLSTRT31 "CSAQ: LAST CANCER TREATMENT";
label variable CBCK31 "CSAQ: CANCER BACK TOLD BY HEALTH PROF";
label variable CBCKYR31 "CSAQ: YEAR TOLD CANCER BACK";
label variable CFTRT31 "CSAQ: FIRST TIME TREATED FOR CANCER";
label variable CWRKP31 "CSAQ: WORK FOR PAY SINCE DIAGNOSED";
label variable CTMOFF31 "CSAQ: TAKE TIME OFF SINCE DIAGNOSED";
label variable CWYCNG31 "CSAQ: WHY MAKE WORK CHANGES";
label variable CEXTM31 "CSAQ: TAKE PAID TIME OFF";
label variable CEXTDI31 "CSAQ: PAID TIME OFF AT DIAGNOSIS";
label variable CEXTRT31 "CSAQ: PAID TIME OFF DURING TREATMENT";
label variable CEXTLT31 "CSAQ: PAID TIME OFF <1 YEAR AFT TRTMNT";
label variable CEXTMT31 "CSAQ: PAID TIME OFF >=1 YEAR AFT TRTMNT";
label variable CNPTLD31 "CSAQ: CHNGE PART TIME OR LESS DEMAND JOB";
label variable CNGFLX31 "CSAQ: FLEXIBLE WORK SCHEDULE";
label variable CPROM31 "CSAQ: DID NOT PURSUE PROMOTION";
label variable CERET31 "CSAQ: EARLY RETIREMENT";
label variable CPTASK31 "CSAQ: INTERFERE WITH PHYSICAL TASKS";
label variable CMTASK31 "CSAQ: INTERFERE WITH MENTAL TASKS";
label variable CLPROD31 "CSAQ: FEEL LESS PRODUCTIVE";
label variable CFRET31 "CSAQ: MIGHT BE FORCED TO RETIRE";
label variable CLHINS31 "CSAQ: STAY AT JOB-WORRY LOSE HLTH INS";
label variable CCLHIN31 "CSAQ: CONCERNED LOSING HLTH INS TO CNCR";
label variable CSLHIN31 "CSAQ: FMEM STAY AT JOB-WORRY LOSE INS";
label variable CFMEM31 "CSAQ: FMEM PROVIDE CARE";
label variable CFMSPS31 "CSAQ: FMEM SPOUSE PROVIDED CARE";
label variable CFMCHD31 "CSAQ: FMEM CHILD PROVIDED CARE";
label variable CFMSIB31 "CSAQ: FMEM SIBLING PROVIDED CARE";
label variable CFMPAR31 "CSAQ: FMEM PARENT PROVIDED CARE";
label variable CFMREL31 "CSAQ: FMEM OTH RELATIVE PROVIDED CARE";
label variable CFMFND31 "CSAQ: FMEM FRIEND PROVIDED CARE";
label variable CFMOTR31 "CSAQ: FMEM OTHER PROVIDED CARE";
label variable CFMTOF31 "CSAQ: FMEM TAKE EXTENDED TIME OFF";
label variable CFM2MT31 "CSAQ: FMEM TAKE EXTND TIM OFF >= 2 MNTH";
label variable CINCOV31 "CSAQ: COVERED BY HEALTH INSURANCE";
label variable CINPRV31 "CSAQ: COVERED BY PRIVATE HLTH INS";
label variable CINMDC31 "CSAQ: COVERED BY MEDICARE HLTH INS";
label variable CINMDG31 "CSAQ: COVERED BY MEDI-GAP HLTH INS";
label variable CINMDA31 "CSAQ: COVERED BY MEDICAID HLTH INS";
label variable CINMLT31 "CSAQ: COVERED BY MILITARY HLTH INS";
label variable CINIHS31 "CSAQ: COVERED BY I.H.S. HLTH INS";
label variable CINSHP31 "CSAQ: COVERED BY STATE HLTH INS";
label variable CINOGP31 "CSAQ: COVERED BY OTH GOVT HLTH INS";
label variable CINSSP31 "CSAQ: COVERED BY SINGLE SERV HLTH INS";
label variable CINNCV31 "CSAQ: COVERED BY NO HLTH INS";
label variable CINNOC31 "CSAQ: HLTH INS REFUSED TO COVER CARE";
label variable CINADQ31 "CSAQ: HLTH INS COVERAGE NOT ADEQUATE";
label variable CINCMP31 "CSAQ: CURRENT HLTH INS COMPARE";
label variable CINDIF31 "CSAQ: DIFFICULTY FINDING HLTH INS";
label variable CINAFD31 "CSAQ: DIFFICULTY AFFORDING HLTH INS";
label variable CNCMED31 "CSAQ: UNCOVERED MEDICAL EXPENSES";
label variable CNCTRP31 "CSAQ: UNCOVERED TRANSPORTATION EXPENSES";
label variable CNCLOD31 "CSAQ: UNCOVERED LODGING EXPENSES";
label variable CNCCHD31 "CSAQ: UNCOVERED CHILD CARE EXPENSES";
label variable CNCHME31 "CSAQ: UNCOVERED HOME CARE EXPENSES";
label variable CNCNON31 "CSAQ: NO UNCOVERED EXPENSES";
label variable CNCNTS31 "CSAQ: NOT SURE IF UNCOVERED EXPENSES";
label variable CFNDBT31 "CSAQ: MONEY BORROWED OR IN DEBT";
label variable CFNAMT31 "CSAQ: AMOUNT OF BORROWED OR IN DEBT";
label variable CFNVAC31 "CSAQ: SACRIFICED LEISURE SPENDING";
label variable CFNPUR31 "CSAQ: SACRIFICED BIG PURCHASES";
label variable CFNSPD31 "CSAQ: SACRIFICED BASIC SPENDING";
label variable CFNSAV31 "CSAQ: SACRIFICED SAVINGS";
label variable CFNLIV31 "CSAQ: SACRIFICED LIVING SITUATION";
label variable CFNOTH31 "CSAQ: SACRIFICED OTHER COST";
label variable CFNUNB31 "CSAQ: UNABLE TO COVER MEDICAL BILLS";
label variable CFNBNK31 "CSAQ: SELF OR FMEM FILE BANKRUPTCY";
label variable CFNPMT31 "CSAQ: WORRY PAY MEDICAL BILLS";
label variable CFNSTB31 "CSAQ: WORRY FAMILY FINANCIAL STABILITY";
label variable CFNINC31 "CSAQ: WORRY INCOME STABILITY";
label variable CMCFUP31 "CSAQ: DISCUSS REGULAR FOLL-UP CARE";
label variable CMCEFF31 "CSAQ: DISCUSS SIDE EFFECTS";
label variable CMCPSY31 "CSAQ: DISCUSS EMO/SOC NEEDS";
label variable CMCSTY31 "CSAQ: DISCUSS LIFESTYLE OR HEALTH";
label variable CMCOST31 "CSAQ: DISCUSS COSTS FOR CANCER CARE";
label variable CMCTRT31 "CSAQ: DISCUSS CANCER TREATMENTS";
label variable CDLPRS31 "CSAQ: DLY OR FOREGO PRESCRIPTION";
label variable CDLVST31 "CSAQ: DLY OR FOREGO VISIT SPECIALIST";
label variable CDLTRT31 "CSAQ: DLY OR FOREGO TREATMENT";
label variable CDLFUP31 "CSAQ: DLY OR FOREGO FOLLOW UP CARE";
label variable CDLMNT31 "CSAQ: DLY OR FOREGO MENTAL HEALTH SRVCS";
label variable CDLOTH31 "CSAQ: DLY OR FOREGO OTHER";
label variable CMCNEC31 "CSAQ: RECEIVED NECESSARY MEDICAL CARE";
label variable CMNAFF31 "CSAQ: COULD NOT AFFORD CARE";
label variable CMNINS31 "CSAQ: INS COMPANY DIDN T APPROVE OR PAY";
label variable CMNACC31 "CSAQ: DOCTOR DID NOT ACCEPT INSURANCE";
label variable CMNOFF31 "CSAQ: PROBLEMS GETTING TO DOCTOR OFFICE";
label variable CMNTIM31 "CSAQ: NO TIME OFF FROM WORK";
label variable CMNPLC31 "CSAQ: DIDN T KNOW WHERE TO GO";
label variable CMNCRE31 "CSAQ: NO CHILD/ADULT CARE";
label variable CMNLNG31 "CSAQ: NO TIME FOR CARE/TREATMENT";
label variable CEFACT31 "CSAQ: ACTIVITIES LIMITED DUE TO CANCER";
label variable CEFLCT31 "CSAQ: HOW LONG ACTIVITIES LIMITED";
label variable CEFOG31 "CSAQ: IS LIMITATION ONGOING";
label variable CEFMTL31 "CSAQ: MENTAL TASKS AFFECTED BY CANCER";
label variable CEFUND31 "CSAQ: UNDSTNDING INSRNCE/MEDICAL BILL";
label variable CEFBCK31 "CSAQ: WORRY CANCER COME BACK/GET WORSE";
label variable CEFSTG31 "CSAQ: EXP-MADE A STRONGER PERSON";
label variable CEFCOP31 "CSAQ: EXP-COPE BETTER W/ CHALLENGES";
label variable CEFPOS31 "CSAQ: EXP-REASON FOR POSITIVE CHANGES";
label variable CEFHLT31 "CSAQ: EXP-MADE HEALTHIER HABITS";
label variable CEFPHL31 "CSAQ: RATE PHYSICAL HEALTH";
label variable CEFPAC31 "CSAQ: RATE PHYSICAL ACTIVITY EXTENT";
label variable CEFPIN31 "CSAQ: RATE AVERAGE PAIN IN 7 DAYS";
label variable CEFFTG31 "CSAQ: RATE AVERAGE FATIGUE IN 7 DAYS";
label variable CEFQLF31 "CSAQ: RATE QUALITY OF LIFE";
label variable CEFMHL31 "CSAQ: RATE MENTAL HEALTH";
label variable CEFRLT31 "CSAQ: RATE SOCIAL ACTIVITY/RELATIONSHIP";
label variable CEFMPR31 "CSAQ: RATE EMOTIONAL PROBLEM IN 7 DAYS";
label variable DDNWRK16 "# DAYS MISSED WORK DUE TO ILL/INJ 2016";
label variable DDNSCL16 "# DAYS MISSD SCHOOL DUE TO ILL/INJ 2016";
label variable OTHDYS16 "MISS ANY WORK DAY TO CARE FOR OTH 2016";
label variable OTHNDD16 "# DAY MISSED WORK TO CARE FOR OTH 2016";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable HAVEUS42 "AC05 DOES PERSON HAVE USC PROVIDER-R4/2";
label variable YNOUSC42 "AC07 MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable NOREAS42 "AC08 OTH REAS NO USC:NO OTH REASONS-R4/2";
label variable SELDSI42 "AC08 OTH REAS NO USC:SELDM/NEV SICK-R4/2";
label variable NEWARE42 "AC08 OTH REAS NO USC:RECENTLY MOVED-R4/2";
label variable DKWHRU42 "AC08 OTH REAS NO USC:DK WHERE TO GO-R4/2";
label variable USCNOT42 "AC08 OTH REAS NO USC: USC NOT AVAIL-R4/2";
label variable PERSLA42 "AC08 OTH REAS NO USC: LANGUAGE-R4/2";
label variable DIFFPL42 "AC08 OTH REAS NO USC:DIFFRNT PLACES-R4/2";
label variable INSRPL42 "AC08 OTH REAS NO USC:JUST CHNGD INS-R4/2";
label variable MYSELF42 "AC08 OTH REAS NO USC:NO DOC/TRT SLF-R4/2";
label variable CARECO42 "AC08 OTH REAS NO USC:COST OF MED CR-R4/2";
label variable NOHINS42 "AC08 OTH REAS NO USC:NO HLTH INSRNC-R4/2";
label variable OTHINS42 "AC08 OTH REAS NO USC: INS RELATED-R4/2";
label variable JOBRSN42 "AC08 OTH REAS NO USC: JOB RELATED-R4/2";
label variable NEWDOC42 "AC08 OTH REAS NO USC: LOOKNG FOR DR-R4/2";
label variable DOCELS42 "AC08 OTH REAS NO USC: DR ELSEWHERE-R4/2";
label variable NOLIKE42 "AC08 OTH REAS NO USC: DONT LIKE DRS-R4/2";
label variable HEALTH42 "AC08 OTH REAS NO USC: HLTH RELATED-R4/2";
label variable KNOWDR42 "AC08 OTH REAS NO USC: KNOWS/IS A DR-R4/2";
label variable ONJOB42 "AC08 OTH REAS NO USC: DR AT WORK-R4/2";
label variable NOGODR42 "AC08 OTH REAS NO USC: WONT GO TO DR-R4/2";
label variable TRANS42 "AC08 OTH REAS NO USC: TRANSPRT/TIME-R4/2";
label variable CLINIC42 "AC08 OTH REAS NO USC: HOSP/ER/CLNIC-R4/2";
label variable OTHREA42 "AC08 OTH REAS NO USC: OTHER REASON-R4/2";
label variable PROVTY42 "PROVIDER TYPE-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable TMTKUS42 "AC13 HOW LONG IT TAKES GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "AC18 IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "AC19 IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "AC19 IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "AC19 IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "AC19 IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "AC19 IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "AC19 IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "AC20 IS PROVIDER MALE OR FEMALE-R4/2";
label variable MINORP42 "AC22 GO TO USC FOR NEW HEALTH PROB-R4/2";
label variable PREVEN42 "AC22 GO TO USC FOR PRVNTVE HLT CARE-R4/2";
label variable REFFRL42 "AC22 GO TO USC FOR REFERRALS-R4/2";
label variable ONGONG42 "AC22 GO TO USC FOR ONGOING HLTH PRB-R4/2";
label variable PHNREG42 "AC23 HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "AC24 USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "AC25 HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "AC26 PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable RESPCT42 "AC27 PROV SHOWS RESPECT FOR TRTMNTS-R4/2";
label variable DECIDE42 "AC28 PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "AC30 PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable PRVSPK42 "AC31 PROV SPEAKS PERSON S LANGUAGE-R4/2";
label variable MDUNAB42 "UNABLE TO GET NECESSRY MEDICAL CARE-R4/2";
label variable MDUNRS42 "AC34 RSN UNABLE GET NECSRY MED CARE-R4/2";
label variable MDDLAY42 "DELAYED IN GETTING NECSRY MED CARE-R4/2";
label variable MDDLRS42 "AC38 RSN DLAYD GETTING NEC MED CARE-R4/2";
label variable DNUNAB42 "UNABLE TO GET NECESSARY DENTAL CARE-R4/2";
label variable DNUNRS42 "AC42 RSN UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNDLAY42 "DELAYED IN GETTING NEC DENTAL CARE-R4/2";
label variable DNDLRS42 "AC46 RSN DLAYD GETTNG NEC DENT CARE-R4/2";
label variable PMUNAB42 "UNABLE TO GET NECESSARY PRES MED-R4/2";
label variable PMUNRS42 "AC50 RSN UNABLE TO GET NEC PRES MED-R4/2";
label variable PMDLAY42 "DELAYED IN GETTING NECSRY PRES MED-R4/2";
label variable PMDLRS42 "AC54 RSN DLAYD GETTING NEC PRES MED-R4/2";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/16";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD31 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD42 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD53 AT CMJ";
label variable NHRWG31 "UPDATED HRLY WAGE RD 3/1 CMJ (EDITED)";
label variable NHRWG42 "UPDATED HRLY WAGE RD 4/2 CMJ (EDITED)";
label variable NHRWG53 "UPDATED HRLY WAGE RD 5/3 CMJ (EDITED)";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable EMPST31H "EMPLOYMENT STATUS RD 3/1 (IMP)";
label variable EMPST42H "EMPLOYMENT STATUS RD 4/2 (IMP)";
label variable EMPST53H "EMPLOYMENT STATUS RD 5/3 (IMP)";
label variable SLFCM31H "SELF-EMPLOYED AT RD 3/1 CMJ (IMP)";
label variable SLFCM42H "SELF-EMPLOYED AT RD 4/2 CMJ (IMP)";
label variable SLFCM53H "SELF-EMPLOYED AT RD 5/3 CMJ (IMP)";
label variable NMEMP31H "NUMBER OF EMPLOYEES AT RD 3/1 CMJ (IMP)";
label variable NMEMP42H "NUMBER OF EMPLOYEES AT RD 4/2 CMJ (IMP)";
label variable NMEMP53H "NUMBER OF EMPLOYEES AT RD 5/3 CMJ (IMP)";
label variable MORE31H "RD 3/1 CMJ FIRM MORE THAN 1 LOCAT (IMP)";
label variable MORE42H "RD 4/2 CMJ FIRM MORE THAN 1 LOCAT (IMP)";
label variable MORE53H "RD 5/3 CMJ FIRM MORE THAN 1 LOCAT (IMP)";
label variable INDCT31H "INDUSTRY GROUP RD 3/1 CMJ (IMP)";
label variable INDCT42H "INDUSTRY GROUP RD 4/2 CMJ (IMP)";
label variable INDCT53H "INDUSTRY GROUP RD 5/3 CMJ (IMP)";
label variable OCCCT31H "OCCUPATION GROUP RD 3/1 CMJ (IMP)";
label variable OCCCT42H "OCCUPATION GROUP RD 4/2 CMJ (IMP)";
label variable OCCCT53H "OCCUPATION GROUP RD 5/3 CMJ (IMP)";
label variable HOUR31H "HOURS PER WEEK AT RD 3/1 CMJ (IMP)";
label variable HOUR42H "HOURS PER WEEK AT RD 4/2 CMJ (IMP)";
label variable HOUR53H "HOURS PER WEEK AT RD 5/3 CMJ (IMP)";
label variable JBORG31H "PRV, ST-LC GOV, FED GOV RD 3/1 CMJ (IMP)";
label variable JBORG42H "PRV, ST-LC GOV, FED GOV RD 4/2 CMJ (IMP)";
label variable JBORG53H "PRV, ST-LC GOV, FED GOV RD 5/3 CMJ (IMP)";
label variable UNION31H "UNION STATUS AT RD 3/1 CMJ (IMP)";
label variable UNION42H "UNION STATUS AT RD 4/2 CMJ (IMP)";
label variable UNION53H "UNION STATUS AT RD 5/3 CMJ (IMP)";
label variable BSNTY31H "SOL PROP, PRTNR, CORP, RD 3/1 CMJ (IMP)";
label variable BSNTY42H "SOL PROP, PRTNR, CORP, RD 4/2 CMJ (IMP)";
label variable BSNTY53H "SOL PROP, PRTNR, CORP, RD 5/3 CMJ (IMP)";
label variable HRWG31H "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42H "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53H "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable CMJHLD31 "HLTH INSUR HELD FROM RD 3/1 CMJ (PRPL)";
label variable CMJHLD42 "HLTH INSUR HELD FROM RD 4/2 CMJ (PRPL)";
label variable CMJHLD53 "HLTH INSUR HELD FROM RD 5/3 CMJ (PRPL)";
label variable OFFER31H "HEALTH INSUR OFFERED BY RD 3/1 CMJ (IMP)";
label variable OFFER42H "HEALTH INSUR OFFERED BY RD 4/2 CMJ (IMP)";
label variable OFFER53H "HEALTH INSUR OFFERED BY RD 5/3 CMJ (IMP)";
label variable OFEMP31H "EMP OFFERS HEALTH INS RD 3/1 CMJ (IMP)";
label variable OFEMP42H "EMP OFFERS HEALTH INS RD 4/2 CMJ (IMP)";
label variable OFEMP53H "EMP OFFERS HEALTH INS RD 5/3 CMJ (IMP)";
label variable PYVAC31H "PAID VACATION AT RD 3/1 CMJ (IMP)";
label variable PYVAC42H "PAID VACATION AT RD 4/2 CMJ (IMP)";
label variable PYVAC53H "PAID VACATION AT RD 5/3 CMJ (IMP)";
label variable SCPAY31H "PAID SICK LEAVE AT RD 3/1 CMJ (IMP)";
label variable SCPAY42H "PAID SICK LEAVE AT RD 4/2 CMJ (IMP)";
label variable SCPAY53H "PAID SICK LEAVE AT RD 5/3 CMJ (IMP)";
label variable PAYDR31H "PAID LEAVE TO VISIT DR RD 3/1 CMJ (IMP)";
label variable PAYDR42H "PAID LEAVE TO VISIT DR RD 4/2 CMJ (IMP)";
label variable PAYDR53H "PAID LEAVE TO VISIT DR RD 5/3 CMJ (IMP)";
label variable RTPLN31H "PENSION PLAN AT RD 3/1 CMJ (IMP)";
label variable RTPLN42H "PENSION PLAN AT RD 4/2 CMJ (IMP)";
label variable RTPLN53H "PENSION PLAN AT RD 5/3 CMJ (IMP)";
label variable AFDC16 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR16 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL16 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT16 "PERSON S FILING STATUS";
label variable FILER16 "PRIMARY OR SECONDARY FILER";
label variable JTINRU16 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID16 "PID OF SECONDARY FILER";
label variable CLMDEP16 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT16 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU16 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD16 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM16 "TAX FORM PERSON WILL FILE";
label variable CLMHIP16 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable EICRDT16 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable FOODST16 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN16 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODVL16 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP16X "PERSON S TOTAL INCOME";
label variable FAMINC16 "FAMILY S TOTAL INCOME";
label variable POVCAT16 "FAMILY INC AS % OF POVERTY LINE - CATEGO";
label variable POVLEV16 "FAMILY INC AS % OF POVERTY LINE - CONTIN";
label variable WAGEP16X "PERSON S WAGE INCOME";
label variable WAGIMP16 "WAGE IMPUTATION FLAG";
label variable BUSNP16X "PERSON S BUSINESS INCOME";
label variable BUSIMP16 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP16X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP16 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP16X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP16 "WORKERS  COMP IMPUTATION FLAG";
label variable INTRP16X "PERSON S INTEREST INCOME";
label variable INTIMP16 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP16X "PERSON S DIVIDEND INCOME";
label variable DIVIMP16 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP16X "PERSON S SALES INCOME";
label variable SALIMP16 "SALES INCOME IMPUTATION FLAG";
label variable PENSP16X "PERSON S PENSION INCOME";
label variable PENIMP16 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP16X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP16 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP16X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP16 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP16X "PERSON S VETERAN S INCOME";
label variable VETIMP16 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP16X "PERSON S IRA INCOME";
label variable IRAIMP16 "IRA INCOME IMPUTATION FLAG";
label variable ALIMP16X "PERSON S ALIMONY INCOME";
label variable ALIIMP16 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP16X "PERSON S CHILD SUPPORT";
label variable CHLIMP16 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP16X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP16 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP16X "PERSON S SSI";
label variable SSIIMP16 "SSI IMPUTATION FLAG";
label variable PUBP16X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP16 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP16X "PERSON S OTHER INCOME";
label variable OTHIMP16 "OTHER INCOME IMPUTATION FLAG";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable TRIJA16X "COVERED BY TRICARE/CHAMPVA IN JAN16 (ED)";
label variable TRIFE16X "COVERED BY TRICARE/CHAMPVA IN FEB16 (ED)";
label variable TRIMA16X "COVERED BY TRICARE/CHAMPVA IN MAR16 (ED)";
label variable TRIAP16X "COVERED BY TRICARE/CHAMPVA IN APR16(ED)";
label variable TRIMY16X "COVERED BY TRICARE/CHAMPVA IN MAY16 (ED)";
label variable TRIJU16X "COVERED BY TRICARE/CHAMPVA IN JUN16 (ED)";
label variable TRIJL16X "COVERED BY TRICARE/CHAMPVA IN JUL16 (ED)";
label variable TRIAU16X "COVERED BY TRICARE/CHAMPVA IN AUG16 (ED)";
label variable TRISE16X "COVERED BY TRICARE/CHAMPVA IN SEP16 (ED)";
label variable TRIOC16X "COVERED BY TRICARE/CHAMPVA IN OCT16 (ED)";
label variable TRINO16X "COVERED BY TRICARE/CHAMPVA IN NOV16 (ED)";
label variable TRIDE16X "COVERED BY TRICARE/CHAMPVA IN DEC16 (ED)";
label variable MCRJA16 "COVERED BY MEDICARE IN JAN16";
label variable MCRFE16 "COVERED BY MEDICARE IN FEB16";
label variable MCRMA16 "COVERED BY MEDICARE IN MAR16";
label variable MCRAP16 "COVERED BY MEDICARE IN APR16";
label variable MCRMY16 "COVERED BY MEDICARE IN MAY16";
label variable MCRJU16 "COVERED BY MEDICARE IN JUN16";
label variable MCRJL16 "COVERED BY MEDICARE IN JUL16";
label variable MCRAU16 "COVERED BY MEDICARE IN AUG16";
label variable MCRSE16 "COVERED BY MEDICARE IN SEP16";
label variable MCROC16 "COVERED BY MEDICARE IN OCT16";
label variable MCRNO16 "COVERED BY MEDICARE IN NOV16";
label variable MCRDE16 "COVERED BY MEDICARE IN DEC16";
label variable MCRJA16X "COVERED BY MEDICARE IN JAN16 (ED)";
label variable MCRFE16X "COVERED BY MEDICARE IN FEB16 (ED)";
label variable MCRMA16X "COVERED BY MEDICARE IN MAR16 (ED)";
label variable MCRAP16X "COVERED BY MEDICARE IN APR16 (ED)";
label variable MCRMY16X "COVERED BY MEDICARE IN MAY16 (ED)";
label variable MCRJU16X "COVERED BY MEDICARE IN JUN16 (ED)";
label variable MCRJL16X "COVERED BY MEDICARE IN JUL16 (ED)";
label variable MCRAU16X "COVERED BY MEDICARE IN AUG16 (ED)";
label variable MCRSE16X "COVERED BY MEDICARE IN SEP16 (ED)";
label variable MCROC16X "COVERED BY MEDICARE IN OCT16 (ED)";
label variable MCRNO16X "COVERED BY MEDICARE IN NOV16 (ED)";
label variable MCRDE16X "COVERED BY MEDICARE IN DEC16 (ED)";
label variable MCDJA16 "COV BY MEDICAID OR SCHIP IN JAN16";
label variable MCDFE16 "COV BY MEDICAID OR SCHIP IN FEB16";
label variable MCDMA16 "COV BY MEDICAID OR SCHIP IN MAR16";
label variable MCDAP16 "COV BY MEDICAID OR SCHIP IN APR16";
label variable MCDMY16 "COV BY MEDICAID OR SCHIP IN MAY16";
label variable MCDJU16 "COV BY MEDICAID OR SCHIP IN JUN16";
label variable MCDJL16 "COV BY MEDICAID OR SCHIP IN JUL16";
label variable MCDAU16 "COV BY MEDICAID OR SCHIP IN AUG16";
label variable MCDSE16 "COV BY MEDICAID OR SCHIP IN SEP16";
label variable MCDOC16 "COV BY MEDICAID OR SCHIP IN OCT16";
label variable MCDNO16 "COV BY MEDICAID OR SCHIP IN NOV16";
label variable MCDDE16 "COV BY MEDICAID OR SCHIP IN DEC16";
label variable MCDJA16X "COV BY MEDICAID OR SCHIP IN JAN16 (ED)";
label variable MCDFE16X "COV BY MEDICAID OR SCHIP IN FEB16 (ED)";
label variable MCDMA16X "COV BY MEDICAID OR SCHIP IN MAR16 (ED)";
label variable MCDAP16X "COV BY MEDICAID OR SCHIP IN APR16 (ED)";
label variable MCDMY16X "COV BY MEDICAID OR SCHIP IN MAY16 (ED)";
label variable MCDJU16X "COV BY MEDICAID OR SCHIP IN JUN16 (ED)";
label variable MCDJL16X "COV BY MEDICAID OR SCHIP IN JUL16 (ED)";
label variable MCDAU16X "COV BY MEDICAID OR SCHIP IN AUG16 (ED)";
label variable MCDSE16X "COV BY MEDICAID OR SCHIP IN SEP16 (ED)";
label variable MCDOC16X "COV BY MEDICAID OR SCHIP IN OCT16 (ED)";
label variable MCDNO16X "COV BY MEDICAID OR SCHIP IN NOV16 (ED)";
label variable MCDDE16X "COV BY MEDICAID OR SCHIP IN DEC16 (ED)";
label variable OPAJA16 "COV BY OTHER PUBLIC A INS IN JAN16";
label variable OPAFE16 "COV BY OTHER PUBLIC A INS IN FEB16";
label variable OPAMA16 "COV BY OTHER PUBLIC A INS IN MAR16";
label variable OPAAP16 "COV BY OTHER PUBLIC A INS IN APR16";
label variable OPAMY16 "COV BY OTHER PUBLIC A INS IN MAY16";
label variable OPAJU16 "COV BY OTHER PUBLIC A INS IN JUN16";
label variable OPAJL16 "COV BY OTHER PUBLIC A INS IN JUL16";
label variable OPAAU16 "COV BY OTHER PUBLIC A INS IN AUG16";
label variable OPASE16 "COV BY OTHER PUBLIC A INS IN SEP16";
label variable OPAOC16 "COV BY OTHER PUBLIC A INS IN OCT16";
label variable OPANO16 "COV BY OTHER PUBLIC A INS IN NOV16";
label variable OPADE16 "COV BY OTHER PUBLIC A INS IN DEC16";
label variable OPBJA16 "COV BY OTHER PUBLIC B INS IN JAN16";
label variable OPBFE16 "COV BY OTHER PUBLIC B INS IN FEB16";
label variable OPBMA16 "COV BY OTHER PUBLIC B INS IN MAR16";
label variable OPBAP16 "COV BY OTHER PUBLIC B INS IN APR16";
label variable OPBMY16 "COV BY OTHER PUBLIC B INS IN MAY16";
label variable OPBJU16 "COV BY OTHER PUBLIC B INS IN JUN16";
label variable OPBJL16 "COV BY OTHER PUBLIC B INS IN JUL16";
label variable OPBAU16 "COV BY OTHER PUBLIC B INS IN AUG16";
label variable OPBSE16 "COV BY OTHER PUBLIC B INS IN SEP16";
label variable OPBOC16 "COV BY OTHER PUBLIC B INS IN OCT16";
label variable OPBNO16 "COV BY OTHER PUBLIC B INS IN NOV16";
label variable OPBDE16 "COV BY OTHER PUBLIC B INS IN DEC16";
label variable STAJA16 "COVERED BY OTHER STATE PROG IN JAN16";
label variable STAFE16 "COVERED BY OTHER STATE PROG IN FEB16";
label variable STAMA16 "COVERED BY OTHER STATE PROG IN MAR16";
label variable STAAP16 "COVERED BY OTHER STATE PROG IN APR16";
label variable STAMY16 "COVERED BY OTHER STATE PROG IN MAY16";
label variable STAJU16 "COVERED BY OTHER STATE PROG IN JUN16";
label variable STAJL16 "COVERED BY OTHER STATE PROG IN JUL16";
label variable STAAU16 "COVERED BY OTHER STATE PROG IN AUG16";
label variable STASE16 "COVERED BY OTHER STATE PROG IN SEP16";
label variable STAOC16 "COVERED BY OTHER STATE PROG IN OCT16";
label variable STANO16 "COVERED BY OTHER STATE PROG IN NOV16";
label variable STADE16 "COVERED BY OTHER STATE PROG IN DEC16";
label variable PUBJA16X "COVR BY ANY PUBLIC INS IN JAN16 (ED)";
label variable PUBFE16X "COVR BY ANY PUBLIC INS IN FEB16 (ED)";
label variable PUBMA16X "COVR BY ANY PUBLIC INS IN MAR16 (ED)";
label variable PUBAP16X "COVR BY ANY PUBLIC INS IN APR16 (ED)";
label variable PUBMY16X "COVR BY ANY PUBLIC INS IN MAY16 (ED)";
label variable PUBJU16X "COVR BY ANY PUBLIC INS IN JUN16 (ED)";
label variable PUBJL16X "COVR BY ANY PUBLIC INS IN JUL16 (ED)";
label variable PUBAU16X "COVR BY ANY PUBLIC INS IN AUG16 (ED)";
label variable PUBSE16X "COVR BY ANY PUBLIC INS IN SEP16 (ED)";
label variable PUBOC16X "COVR BY ANY PUBLIC INS IN OCT16 (ED)";
label variable PUBNO16X "COVR BY ANY PUBLIC INS IN NOV16 (ED)";
label variable PUBDE16X "COVR BY ANY PUBLIC INS IN DEC16 (ED)";
label variable PEGJA16 "COVERED BY EMPL UNION INS IN JAN16";
label variable PEGFE16 "COVERED BY EMPL UNION INS IN FEB16";
label variable PEGMA16 "COVERED BY EMPL UNION INS IN MAR16";
label variable PEGAP16 "COVERED BY EMPL UNION INS IN APR16";
label variable PEGMY16 "COVERED BY EMPL UNION INS IN MAY16";
label variable PEGJU16 "COVERED BY EMPL UNION INS IN JUN16";
label variable PEGJL16 "COVERED BY EMPL UNION INS IN JUL16";
label variable PEGAU16 "COVERED BY EMPL UNION INS IN AUG16";
label variable PEGSE16 "COVERED BY EMPL UNION INS IN SEP16";
label variable PEGOC16 "COVERED BY EMPL UNION INS IN OCT16";
label variable PEGNO16 "COVERED BY EMPL UNION INS IN NOV16";
label variable PEGDE16 "COVERED BY EMPL UNION INS IN DEC16";
label variable PDKJA16 "COVR BY PRIV INS (SOURCE UNKNWN) JAN16";
label variable PDKFE16 "COVR BY PRIV INS (SOURCE UNKNWN) FEB16";
label variable PDKMA16 "COVR BY PRIV INS (SOURCE UNKNWN) MAR16";
label variable PDKAP16 "COVR BY PRIV INS (SOURCE UNKNWN) APR16";
label variable PDKMY16 "COVR BY PRIV INS (SOURCE UNKNWN) MAY16";
label variable PDKJU16 "COVR BY PRIV INS (SOURCE UNKNWN) JUN16";
label variable PDKJL16 "COVR BY PRIV INS (SOURCE UNKNWN) JUL16";
label variable PDKAU16 "COVR BY PRIV INS (SOURCE UNKNWN) AUG16";
label variable PDKSE16 "COVR BY PRIV INS (SOURCE UNKNWN) SEP16";
label variable PDKOC16 "COVR BY PRIV INS (SOURCE UNKNWN) OCT16";
label variable PDKNO16 "COVR BY PRIV INS (SOURCE UNKNWN) NOV16";
label variable PDKDE16 "COVR BY PRIV INS (SOURCE UNKNWN) DEC16";
label variable PNGJA16 "COVERED BY NONGROUP INS IN JAN16";
label variable PNGFE16 "COVERED BY NONGROUP INS IN FEB16";
label variable PNGMA16 "COVERED BY NONGROUP INS IN MAR16";
label variable PNGAP16 "COVERED BY NONGROUP INS IN APR16";
label variable PNGMY16 "COVERED BY NONGROUP INS IN MAY16";
label variable PNGJU16 "COVERED BY NONGROUP INS IN JUN16";
label variable PNGJL16 "COVERED BY NONGROUP INS IN JUL16";
label variable PNGAU16 "COVERED BY NONGROUP INS IN AUG16";
label variable PNGSE16 "COVERED BY NONGROUP INS IN SEP16";
label variable PNGOC16 "COVERED BY NONGROUP INS IN OCT16";
label variable PNGNO16 "COVERED BY NONGROUP INS IN NOV16";
label variable PNGDE16 "COVERED BY NONGROUP INS IN DEC16";
label variable POGJA16 "COVERED BY OTHER GROUP INS IN JAN16";
label variable POGFE16 "COVERED BY OTHER GROUP INS IN FEB16";
label variable POGMA16 "COVERED BY OTHER GROUP INS IN MAR16";
label variable POGAP16 "COVERED BY OTHER GROUP INS IN APR16";
label variable POGMY16 "COVERED BY OTHER GROUP INS IN MAY16";
label variable POGJU16 "COVERED BY OTHER GROUP INS IN JUN16";
label variable POGJL16 "COVERED BY OTHER GROUP INS IN JUL16";
label variable POGAU16 "COVERED BY OTHER GROUP INS IN AUG16";
label variable POGSE16 "COVERED BY OTHER GROUP INS IN SEP16";
label variable POGOC16 "COVERED BY OTHER GROUP INS IN OCT16";
label variable POGNO16 "COVERED BY OTHER GROUP INS IN NOV16";
label variable POGDE16 "COVERED BY OTHER GROUP INS IN DEC16";
label variable PRSJA16 "COVERED BY SELF-EMP-1 INS IN JAN16";
label variable PRSFE16 "COVERED BY SELF-EMP-1 INS IN FEB16";
label variable PRSMA16 "COVERED BY SELF-EMP-1 INS IN MAR16";
label variable PRSAP16 "COVERED BY SELF-EMP-1 INS IN APR16";
label variable PRSMY16 "COVERED BY SELF-EMP-1 INS IN MAY16";
label variable PRSJU16 "COVERED BY SELF-EMP-1 INS IN JUN16";
label variable PRSJL16 "COVERED BY SELF-EMP-1 INS IN JUL16";
label variable PRSAU16 "COVERED BY SELF-EMP-1 INS IN AUG16";
label variable PRSSE16 "COVERED BY SELF-EMP-1 INS IN SEP16";
label variable PRSOC16 "COVERED BY SELF-EMP-1 INS IN OCT16";
label variable PRSNO16 "COVERED BY SELF-EMP-1 INS IN NOV16";
label variable PRSDE16 "COVERED BY SELF-EMP-1 INS IN DEC16";
label variable POUJA16 "COVERED BY HOLDER OUTSIDE OF RU IN JAN16";
label variable POUFE16 "COVERED BY HOLDER OUTSIDE OF RU IN FEB16";
label variable POUMA16 "COVERED BY HOLDER OUTSIDE OF RU IN MAR16";
label variable POUAP16 "COVERED BY HOLDER OUTSIDE OF RU IN APR16";
label variable POUMY16 "COVERED BY HOLDER OUTSIDE OF RU IN MAY16";
label variable POUJU16 "COVERED BY HOLDER OUTSIDE OF RU IN JUN16";
label variable POUJL16 "COVERED BY HOLDER OUTSIDE OF RU IN JUL16";
label variable POUAU16 "COVERED BY HOLDER OUTSIDE OF RU IN AUG16";
label variable POUSE16 "COVERED BY HOLDER OUTSIDE OF RU IN SEP16";
label variable POUOC16 "COVERED BY HOLDER OUTSIDE OF RU IN OCT16";
label variable POUNO16 "COVERED BY HOLDER OUTSIDE OF RU IN NOV16";
label variable POUDE16 "COVERED BY HOLDER OUTSIDE OF RU IN DEC16";
label variable PRXJA16 "COV BY PRIV INS THROUGH EXCHNG IN JAN16";
label variable PRXFE16 "COV BY PRIV INS THROUGH EXCHNG IN FEB16";
label variable PRXMA16 "COV BY PRIV INS THROUGH EXCHNG IN MAR16";
label variable PRXAP16 "COV BY PRIV INS THROUGH EXCHNG IN APR16";
label variable PRXMY16 "COV BY PRIV INS THROUGH EXCHNG IN MAY16";
label variable PRXJU16 "COV BY PRIV INS THROUGH EXCHNG IN JUN16";
label variable PRXJL16 "COV BY PRIV INS THROUGH EXCHNG IN JUL16";
label variable PRXAU16 "COV BY PRIV INS THROUGH EXCHNG IN AUG16";
label variable PRXSE16 "COV BY PRIV INS THROUGH EXCHNG IN SEP16";
label variable PRXOC16 "COV BY PRIV INS THROUGH EXCHNG IN OCT16";
label variable PRXNO16 "COV BY PRIV INS THROUGH EXCHNG IN NOV16";
label variable PRXDE16 "COV BY PRIV INS THROUGH EXCHNG IN DEC16";
label variable PRIJA16 "COVERED BY PRIVATE INS IN JAN16";
label variable PRIFE16 "COVERED BY PRIVATE INS IN FEB16";
label variable PRIMA16 "COVERED BY PRIVATE INS IN MAR16";
label variable PRIAP16 "COVERED BY PRIVATE INS IN APR16";
label variable PRIMY16 "COVERED BY PRIVATE INS IN MAY16";
label variable PRIJU16 "COVERED BY PRIVATE INS IN JUN16";
label variable PRIJL16 "COVERED BY PRIVATE INS IN JUL16";
label variable PRIAU16 "COVERED BY PRIVATE INS IN AUG16";
label variable PRISE16 "COVERED BY PRIVATE INS IN SEP16";
label variable PRIOC16 "COVERED BY PRIVATE INS IN OCT16";
label variable PRINO16 "COVERED BY PRIVATE INS IN NOV16";
label variable PRIDE16 "COVERED BY PRIVATE INS IN DEC16";
label variable HPEJA16 "HOLDER OF EMPL UNION INS IN JAN16";
label variable HPEFE16 "HOLDER OF EMPL UNION INS IN FEB16";
label variable HPEMA16 "HOLDER OF EMPL UNION INS IN MAR16";
label variable HPEAP16 "HOLDER OF EMPL UNION INS IN APR16";
label variable HPEMY16 "HOLDER OF EMPL UNION INS IN MAY16";
label variable HPEJU16 "HOLDER OF EMPL UNION INS IN JUN16";
label variable HPEJL16 "HOLDER OF EMPL UNION INS IN JUL16";
label variable HPEAU16 "HOLDER OF EMPL UNION INS IN AUG16";
label variable HPESE16 "HOLDER OF EMPL UNION INS IN SEP16";
label variable HPEOC16 "HOLDER OF EMPL UNION INS IN OCT16";
label variable HPENO16 "HOLDER OF EMPL UNION INS IN NOV16";
label variable HPEDE16 "HOLDER OF EMPL UNION INS IN DEC16";
label variable HPDJA16 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN16";
label variable HPDFE16 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB16";
label variable HPDMA16 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR16";
label variable HPDAP16 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR16";
label variable HPDMY16 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY16";
label variable HPDJU16 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN16";
label variable HPDJL16 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL16";
label variable HPDAU16 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG16";
label variable HPDSE16 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP16";
label variable HPDOC16 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT16";
label variable HPDNO16 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV16";
label variable HPDDE16 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC16";
label variable HPNJA16 "HOLDER OF NONGROUP INS IN JAN16";
label variable HPNFE16 "HOLDER OF NONGROUP INS IN FEB16";
label variable HPNMA16 "HOLDER OF NONGROUP INS IN MAR16";
label variable HPNAP16 "HOLDER OF NONGROUP INS IN APR16";
label variable HPNMY16 "HOLDER OF NONGROUP INS IN MAY16";
label variable HPNJU16 "HOLDER OF NONGROUP INS IN JUN16";
label variable HPNJL16 "HOLDER OF NONGROUP INS IN JUL16";
label variable HPNAU16 "HOLDER OF NONGROUP INS IN AUG16";
label variable HPNSE16 "HOLDER OF NONGROUP INS IN SEP16";
label variable HPNOC16 "HOLDER OF NONGROUP INS IN OCT16";
label variable HPNNO16 "HOLDER OF NONGROUP INS IN NOV16";
label variable HPNDE16 "HOLDER OF NONGROUP INS IN DEC16";
label variable HPOJA16 "HOLDER OF OTHER GROUP INS IN JAN16";
label variable HPOFE16 "HOLDER OF OTHER GROUP INS IN FEB16";
label variable HPOMA16 "HOLDER OF OTHER GROUP INS IN MAR16";
label variable HPOAP16 "HOLDER OF OTHER GROUP INS IN APR16";
label variable HPOMY16 "HOLDER OF OTHER GROUP INS IN MAY16";
label variable HPOJU16 "HOLDER OF OTHER GROUP INS IN JUN16";
label variable HPOJL16 "HOLDER OF OTHER GROUP INS IN JUL16";
label variable HPOAU16 "HOLDER OF OTHER GROUP INS IN AUG16";
label variable HPOSE16 "HOLDER OF OTHER GROUP INS IN SEP16";
label variable HPOOC16 "HOLDER OF OTHER GROUP INS IN OCT16";
label variable HPONO16 "HOLDER OF OTHER GROUP INS IN NOV16";
label variable HPODE16 "HOLDER OF OTHER GROUP INS IN DEC16";
label variable HPSJA16 "HOLDER OF SELF-EMP-1 INS IN JAN16";
label variable HPSFE16 "HOLDER OF SELF-EMP-1 INS IN FEB16";
label variable HPSMA16 "HOLDER OF SELF-EMP-1 INS IN MAR16";
label variable HPSAP16 "HOLDER OF SELF-EMP-1 INS IN APR16";
label variable HPSMY16 "HOLDER OF SELF-EMP-1 INS IN MAY16";
label variable HPSJU16 "HOLDER OF SELF-EMP-1 INS IN JUN16";
label variable HPSJL16 "HOLDER OF SELF-EMP-1 INS IN JUL16";
label variable HPSAU16 "HOLDER OF SELF-EMP-1 INS IN AUG16";
label variable HPSSE16 "HOLDER OF SELF-EMP-1 INS IN SEP16";
label variable HPSOC16 "HOLDER OF SELF-EMP-1 INS IN OCT16";
label variable HPSNO16 "HOLDER OF SELF-EMP-1 INS IN NOV16";
label variable HPSDE16 "HOLDER OF SELF-EMP-1 INS IN DEC16";
label variable HPXJA16 "HOLDER OF PRIV INS THROUGH EXCH IN JAN16";
label variable HPXFE16 "HOLDER OF PRIV INS THROUGH EXCH IN FEB16";
label variable HPXMA16 "HOLDER OF PRIV INS THROUGH EXCH IN MAR16";
label variable HPXAP16 "HOLDER OF PRIV INS THROUGH EXCH IN APR16";
label variable HPXMY16 "HOLDER OF PRIV INS THROUGH EXCH IN MAY16";
label variable HPXJU16 "HOLDER OF PRIV INS THROUGH EXCH IN JUN16";
label variable HPXJL16 "HOLDER OF PRIV INS THROUGH EXCH IN JUL16";
label variable HPXAU16 "HOLDER OF PRIV INS THROUGH EXCH IN AUG16";
label variable HPXSE16 "HOLDER OF PRIV INS THROUGH EXCH IN SEP16";
label variable HPXOC16 "HOLDER OF PRIV INS THROUGH EXCH IN OCT16";
label variable HPXNO16 "HOLDER OF PRIV INS THROUGH EXCH IN NOV16";
label variable HPXDE16 "HOLDER OF PRIV INS THROUGH EXCH IN DEC16";
label variable HPRJA16 "HOLDER OF PRIVATE INSURANCE IN JAN16";
label variable HPRFE16 "HOLDER OF PRIVATE INSURANCE IN FEB16";
label variable HPRMA16 "HOLDER OF PRIVATE INSURANCE IN MAR16";
label variable HPRAP16 "HOLDER OF PRIVATE INSURANCE IN APR16";
label variable HPRMY16 "HOLDER OF PRIVATE INSURANCE IN MAY16";
label variable HPRJU16 "HOLDER OF PRIVATE INSURANCE IN JUN16";
label variable HPRJL16 "HOLDER OF PRIVATE INSURANCE IN JUL16";
label variable HPRAU16 "HOLDER OF PRIVATE INSURANCE IN AUG16";
label variable HPRSE16 "HOLDER OF PRIVATE INSURANCE IN SEP16";
label variable HPROC16 "HOLDER OF PRIVATE INSURANCE IN OCT16";
label variable HPRNO16 "HOLDER OF PRIVATE INSURANCE IN NOV16";
label variable HPRDE16 "HOLDER OF PRIVATE INSURANCE IN DEC16";
label variable INSJA16X "COVR BY HOSP/MED INS IN JAN16 (ED)";
label variable INSFE16X "COVR BY HOSP/MED INS IN FEB16 (ED)";
label variable INSMA16X "COVR BY HOSP/MED INS IN MAR16 (ED)";
label variable INSAP16X "COVR BY HOSP/MED INS IN APR16 (ED)";
label variable INSMY16X "COVR BY HOSP/MED INS IN MAY16 (ED)";
label variable INSJU16X "COVR BY HOSP/MED INS IN JUN16 (ED)";
label variable INSJL16X "COVR BY HOSP/MED INS IN JUL16 (ED)";
label variable INSAU16X "COVR BY HOSP/MED INS IN AUG16 (ED)";
label variable INSSE16X "COVR BY HOSP/MED INS IN SEP16 (ED)";
label variable INSOC16X "COVR BY HOSP/MED INS IN OCT16 (ED)";
label variable INSNO16X "COVR BY HOSP/MED INS IN NOV16 (ED)";
label variable INSDE16X "COVR BY HOSP/MED INS IN DEC16 (ED)";
label variable PRVEV16 "EVER HAVE PRIVATE INSURANCE DURING 2016";
label variable TRIEV16 "EVER HAVE TRICARE/CHAMPVA DURING 2016";
label variable MCREV16 "EVER HAVE MEDICARE DURING 2016 (ED)";
label variable MCDEV16 "EVER HAVE MCAID/SCHIP DURING 2016 (ED)";
label variable OPAEV16 "EVER HAVE OTHER PUBLIC A INS DURING 2016";
label variable OPBEV16 "EVER HAVE OTHER PUBLIC B INS DURING 2016";
label variable UNINS16 "UNINSURED ALL OF 2016";
label variable INSCOV16 "HEALTH INSURANCE COVERAGE INDICATOR 2016";
label variable INSURC16 "FULL YEAR INSURANCE COVERAGE STATUS 2016";
label variable TRIST31X "COV BY TRICARE STANDARD-ANY TIME IN R3/1";
label variable TRIST42X "COV BY TRICARE STANDARD-ANY TIME IN R4/2";
label variable TRIST16X "CV BY TRICARE STANDARD-R5/3 TIL 12/31/16";
label variable TRIPR31X "COV BY TRICARE PRIME - ANY TIME IN R3/1";
label variable TRIPR42X "COV BY TRICARE PRIME - ANY TIME IN R4/2";
label variable TRIPR16X "COV BY TRICARE PRIME-R5/3 UNTIL 12/31/16";
label variable TRIEX31X "COV BY TRICARE EXTRA - ANY TIME IN R3/1";
label variable TRIEX42X "COV BY TRICARE EXTRA - ANY TIME IN R4/2";
label variable TRIEX16X "COV BY TRICARE EXTRA - R5/3 TIL 12/31/16";
label variable TRILI31X "COV BY TRICARE FOR LIFE-ANY TIME IN R3/1";
label variable TRILI42X "COV BY TRICARE FOR LIFE-ANY TIME IN R4/2";
label variable TRILI16X "CV BY TRICARE FOR LIFE-R5/3 TIL 12/31/16";
label variable TRICH31X "COVERED BY CHAMPVA - ANY TIME IN R3/1";
label variable TRICH42X "COVERED BY CHAMPVA - ANY TIME IN R4/2";
label variable TRICH16X "COVERED BY CHAMPVA - R5/3 UNTIL 12/31/16";
label variable MCRPD31 "COV BY MEDICARE PMED BENEFIT - R3/1";
label variable MCRPD42 "COV BY MEDICARE PMED BENEFIT - R4/2";
label variable MCRPD16 "COV BY MEDICARE PMED BENEFIT - 12/31/16";
label variable MCRPD31X "COV BY MEDICARE PMED BENEFIT - R3/1 (ED)";
label variable MCRPD42X "COV BY MEDICARE PMED BENEFIT - R4/2 (ED)";
label variable MCRPD16X "COV BY MCARE PMED BENEFIT-12/31/16 (ED)";
label variable MCRPB31 "COV BY MEDICARE PART B - R3/1";
label variable MCRPB42 "COV BY MEDICARE PART B - R4/2";
label variable MCRPB16 "COV BY MEDICARE PART B - 12/31/16";
label variable MCRPHO31 "COV BY MEDICARE MANAGED CARE - R3/1";
label variable MCRPHO42 "COV BY MEDICARE MANAGED CARE - R4/2";
label variable MCRPHO16 "COV BY MEDICARE MANAGED CARE - 12/31/16";
label variable MCDHMO31 "COV BY MCAID/SCHIP HMO -ANY TIME IN R3/1";
label variable MCDHMO42 "COV BY MCAID/SCHIP HMO -ANY TIME IN R4/2";
label variable MCDHMO16 "COV BY MCAID/SCHIP HMO-R5/3 TIL 12/31/16";
label variable MCDMC31 "CV MCAID/CHIP GTKPR PLN-ANY TIME IN R3/1";
label variable MCDMC42 "CV MCAID/CHIP GTKPR PLN-ANY TIME IN R4/2";
label variable MCDMC16 "CV MCD/CHIP GTKPR PLN-R5/3 TIL 12/31/16";
label variable PRVHMO31 "COVERED BY PRIVATE HMO-ANY TIME IN R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO-ANY TIME IN R4/2";
label variable PRVHMO16 "COVERED BY PRIVATE HMO-R5/3 TIL 12/31/16";
label variable FSAGT31 "ANYONE IN RU HAVE FSA - R3/1";
label variable HASFSA31 "PERSON IS FSA HOLDER - R3/1";
label variable FSAAMT31 "FSA TOTAL AMOUNT FOR RU - R3/1";
label variable PROBPY42 "FAMILY HAVING PROB PAYING MEDICAL BILLS";
label variable CRFMPY42 "FAMILY MED BILLS BEING PAID OVER TIME";
label variable PYUNBL42 "UNABLE TO PAY FAMILY MEDICAL BILLS";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PNL 21 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PNL 21 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 21 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PN 21 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 21 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID/SCHIP-PNL 21 ONLY";
label variable WASCHAMP "WAS PREV INS TRICARE/CHAMPVA-PNL 21 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PNL 21 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PN 21 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PNL 21 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PNL 21 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PNL 21 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PNL 21 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PNL 21 ONLY";
label variable WASSTAT3 "WAS PREV INS BY STAT PROG 3-PNL 21 ONLY";
label variable WASSTAT4 "WAS PREV INS BY STAT PROG 4-PNL 21 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 21 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 21 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-P21 ONLY";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 21 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PN 21 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 21 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 21 ONLY";
label variable TRICR31X "COV BY TRICR/CHAMV - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICR/CHAMV - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICR/CHAMV 12-31/R3 INT DT (ED)";
label variable TRICR16X "COV BY TRICR/CHAMV - 12/31/16 (ED)";
label variable TRIAT31X "COV TRICARE/CHAMPVA - ANY TIME IN R3/1";
label variable TRIAT42X "COV TRICARE/CHAMPVA - ANY TIME IN R4/2";
label variable TRIAT53X "COV TRICARE/CHAMPVA - ANY TIME IN R5/3";
label variable TRIAT16X "COV TRICARE/CHAMPVA-R5/3 UNTIL 12/31/16";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID16 "COV BY MEDICAID OR SCHIP - 12/31/16";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID16X "COV BY MEDICAID OR SCHIP - 12/31/16 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE16 "COV BY MEDICARE - 12/31/16";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE16X "COV BY MEDICARE - 12/31/16 (ED)";
label variable MCDAT31X "COV MEDICAID OR SCHIP - ANY TIME IN R3/1";
label variable MCDAT42X "COV MEDICAID OR SCHIP - ANY TIME IN R4/2";
label variable MCDAT53X "COV MEDICAID OR SCHIP - ANY TIME IN R5/3";
label variable MCDAT16X "CV MCD/CHIP-ANY TME IN R5/3 TIL 12/31/16";
label variable OTPAAT31 "COV OT GOV MCD/CHIP HMO-ANY TIME IN R3/1";
label variable OTPAAT42 "COV OT GOV MCD/CHIP HMO-ANY TIME IN R4/2";
label variable OTPAAT53 "COV OT GOV MCD/CHIP HMO-ANY TIME IN R5/3";
label variable OTPAAT16 "CV OT GOV MCD/CHIP HMO-R5/3 TIL 12/31/16";
label variable OTPBAT31 "CV OTGV NT MCD/CHIP HMO-ANY TIME IN R3/1";
label variable OTPBAT42 "CV OTGV NT MCD/CHIP HMO-ANY TIME IN R4/2";
label variable OTPBAT53 "CV OTGV NT MCD/CHIP HMO-ANY TIME IN R5/3";
label variable OTPBAT16 "CV OTGV NT MCD/CHP HMO-R5/3 TIL 12/31/16";
label variable OTPUBA31 "COV/PAY OTH GOV MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBA42 "COV/PAY OTH GOV MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBA53 "COV/PAY OTH GOV MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBA16 "COV/PAY OTH GOV MCAID/SCHIP HMO-12/31/16";
label variable OTPUBB31 "COV OTH GOV NOT MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBB42 "COV OTH GOV NOT MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBB53 "COV OTH GOV NOT MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBB16 "COV OTH GOV NOT MCAID/SCHIP HMO-12/31/16";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK16 "COV BY PRIV INS (DK PLAN) - 12/31/16";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU16 "COV BY EMPL/UNION GRP INS - 12/31/16";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING16 "COV BY NON-GROUP INS - 12/31/16";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG16 "COV BY OTHER GROUP INS - 12/31/16";
label variable PRIS31 "COV BY SELF-EMP-1 INS - R3/1 INT DT";
label variable PRIS42 "COV BY SELF-EMP-1 INS - R4/2 INT DT";
label variable PRIS53 "COV BY SELF-EMP-1 INS 12-31/R3 INT DT";
label variable PRIS16 "COV BY SELF-EMP-1 INS - 12/31/16";
label variable PROUT31 "COV BY SOMEONE OUT OF RU - R3/1 INT";
label variable PROUT42 "COV BY SOMEONE OUT OF RU - R4/2 INT";
label variable PROUT53 "COV BY SOMEONE OUT OF RU 12-31/R3 INT DT";
label variable PROUT16 "COV BY SOMEONE OUT OF RU - 12/31/16";
label variable PRSTX31 "COV BY PRIV EXCHANGE INS -R3/1 INT DT";
label variable PRSTX42 "COV BY PRIV EXCHANGE INS -R4/2 INT DT";
label variable PRSTX53 "PRIV EXCHANGE INS ON 12-31 R5/R3 INT DT";
label variable PRSTX16 "PRIV EXCHANGE INSURANCE ON 12/31/16";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV16 "COV BY PRIV HLTH INS - 12/31/16";
label variable PRIVAT31 "COV BY PRIVATE INS - ANY TIME IN R3/1";
label variable PRIVAT42 "COV BY PRIVATE INS - ANY TIME IN R4/2";
label variable PRIVAT53 "COV BY PRIVATE INS - ANY TIME IN R5/3";
label variable PRIVAT16 "COV BY PRIVATE INS - R5/3 UNTIL 12/31/16";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB16X "COV BY PUBLIC INS - 12/31/16 (ED)";
label variable PUBAT31X "COV BY PUBLIC - ANY TIME IN R3/1";
label variable PUBAT42X "COV BY PUBLIC - ANY TIME IN R4/2";
label variable PUBAT53X "COV BY PUBLIC - ANY TIME IN R5/3";
label variable PUBAT16X "COV BY PUBLIC - R5/3 UNTIL 12/31/16";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS16X "INSURED - 12/31/16 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT16X "INSURED ANY TIME IN R5/R3 UNTIL 12/31/16";
label variable STAPR31 "COV BY STATE-SPEC PROG - R3/1 INT DT";
label variable STAPR42 "COV BY STATE-SPEC PROG - R4/2 INT DT";
label variable STAPR53 "COV BY STATE-SPEC PROG 12-31/R3 INT DT";
label variable STAPR16 "COV BY STATE-SPEC PROG - 12/31/16";
label variable STPRAT31 "COVERAGE BY STATE INS - ANY TIME IN R3/1";
label variable STPRAT42 "COVERAGE BY STATE INS - ANY TIME IN R4/2";
label variable STPRAT53 "COVERAGE BY STATE INS - ANY TIME IN R5/3";
label variable STPRAT16 "COV BY STATE INS - R5/3 UNTIL 12/31/16";
label variable DENTIN31 "DENTAL INSURANCE - ANY TIME IN RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - ANY TIME IN RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - ANY TIME IN RD 5/3";
label variable DNTINS31 "DENTAL INS - ANY TIME IN RD 3/1 IN 2016";
label variable DNTINS16 "DENTL INS-ANY TIME IN R5/R3 TIL 12/31/16";
label variable PMEDIN31 "PMED INS - ANY TIME IN RD 3/1";
label variable PMEDIN42 "PMEDINS - ANY TIME IN RD 4/2";
label variable PMEDIN53 "PMEDINS - ANY TIME IN RD 5/3";
label variable PMDINS31 "PMED INS - RD 3/1 IN 2016";
label variable PMDINS16 "PMED INS - R5/R3 UNTIL 12/31/16";
label variable PMEDUP31 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R3/1";
label variable PMEDUP42 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R4/2";
label variable PMEDUP53 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R5/3";
label variable PMEDPY31 "USUAL 3RD PARTY PAYER FOR PMEDS - R3/1";
label variable PMEDPY42 "USUAL 3RD PARTY PAYER FOR PMEDS - R4/2";
label variable PMEDPY53 "USUAL 3RD PARTY PAYER FOR PMEDS - R5/3";
label variable TOTTCH16 "TOTAL HEALTH CARE CHARGES 16, EXCL RX";
label variable TOTEXP16 "TOTAL HEALTH CARE EXP 16";
label variable TOTSLF16 "TOTAL AMT PAID BY SELF/FAMILY 16";
label variable TOTMCR16 "TOTAL AMT PAID BY MEDICARE 16";
label variable TOTMCD16 "TOTAL AMT PAID BY MEDICAID 16";
label variable TOTPRV16 "TOTAL AMT PAID BY PRIVATE INS 16";
label variable TOTVA16 "TOTAL AMT PAID BY VA/CHAMPVA 16";
label variable TOTTRI16 "TOTAL AMT PAID BY TRICARE 16";
label variable TOTOFD16 "TOTAL AMT PAID BY OTHER FEDERAL 16";
label variable TOTSTL16 "TOTAL AMT PAID BY OTH ST/LOCAL 16";
label variable TOTWCP16 "TOTAL AMT PAID BY WORKERS COMP 16";
label variable TOTOPR16 "TOTAL AMT PAID BY OTHER PRIVATE 16";
label variable TOTOPU16 "TOTAL AMT PAID BY OTHER PUBLIC 16";
label variable TOTOSR16 "TOTAL AMT PAID BY OTHER SOURCES 16";
label variable TOTPTR16 "TOTAL AMT PAID BY PRV & TRI 16";
label variable TOTOTH16 "TOTAL AMT PAID BY OTH COMBINED 16";
label variable OBTOTV16 "# OFFICE-BASED PROVIDER VISITS 16";
label variable OBVTCH16 "OFFICE-BASED PROVIDER VISIT CHARGES 16";
label variable OBVEXP16 "TOTAL OFFICE-BASED EXP 16";
label variable OBVSLF16 "ALL OFFICE VISITS - SELF/FAMILY AMT 16";
label variable OBVMCR16 "ALL OFFICE VISITS - MEDICARE AMT 16";
label variable OBVMCD16 "ALL OFFICE VISITS - MEDICAID AMT 16";
label variable OBVPRV16 "ALL OFFICE VISITS - PRIVATE INS AMT 16";
label variable OBVVA16 "ALL OFFICE VISITS-VA/CHAMPVA AMT 16";
label variable OBVTRI16 "ALL OFFICE VISITS-TRICARE AMT 16";
label variable OBVOFD16 "ALL OFFICE VISITS-OTHER FEDERAL AMT 16";
label variable OBVSTL16 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 16";
label variable OBVWCP16 "ALL OFFICE VISITS - WORKERS COMP AMT 16";
label variable OBVOPR16 "ALL OFFICE VISITS - OTH PRIVATE AMT 16";
label variable OBVOPU16 "ALL OFFICE VISITS - OTH PUBLIC AMT 16";
label variable OBVOSR16 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 16";
label variable OBVPTR16 "ALL OFFICE VISITS - PRV & TRI AMT 16";
label variable OBVOTH16 "ALL OFFICE VISITS - OTH COMBINED AMT 16";
label variable OBDRV16 "# OFFICE-BASED PHYSICIAN VISITS 16";
label variable OBDTCH16 "OFFICE-BASED PHYSICIAN VISIT CHARGES 16";
label variable OBDEXP16 "TOTAL OFF-BASED DR EXP 16";
label variable OBDSLF16 "DR OFFICE VISITS - SELF/FAMILY AMT 16";
label variable OBDMCR16 "DR OFFICE VISITS - MEDICARE AMT 16";
label variable OBDMCD16 "DR OFFICE VISITS - MEDICAID AMT 16";
label variable OBDPRV16 "DR OFFICE VISITS - PRIVATE INS AMT 16";
label variable OBDVA16 "DR OFFICE VISITS - VA/CHAMPVA AMT 16";
label variable OBDTRI16 "DR OFFICE VISITS - TRICARE AMT 16";
label variable OBDOFD16 "DR OFFICE VISITS - OTHER FEDERAL AMT 16";
label variable OBDSTL16 "DR OFFICE VISITS - OTH ST/LOCAL AMT 16";
label variable OBDWCP16 "DR OFFICE VISITS - WORKERS COMP AMT 16";
label variable OBDOPR16 "DR OFFICE VISITS - OTH PRIVATE AMT 16";
label variable OBDOPU16 "DR OFFICE VISITS - OTH PUBLIC AMT 16";
label variable OBDOSR16 "DR OFF VSTS - OTH UNCLASS SRCE AMT 16";
label variable OBDPTR16 "DR OFFICE VISITS - PRV & TRI AMT 16";
label variable OBDOTH16 "DR OFFICE VISITS - OTH COMBINED AMT 16";
label variable OBOTHV16 "# OFFICE-BASED NON-PHYSICAN VISITS 16";
label variable OBOTCH16 "OFFICE-BASED NON-DR VISIT CHARGES 16";
label variable OBOEXP16 "TOTAL OFF-BASED NON-DR EXP 16";
label variable OBOSLF16 "NON-DR OFF VISTS - SELF/FAMILY AMT 16";
label variable OBOMCR16 "NON-DR OFF VISTS - MEDICARE AMT 16";
label variable OBOMCD16 "NON-DR OFF VISTS - MEDICAID AMT 16";
label variable OBOPRV16 "NON-DR OFF VISTS - PRIVATE INS AMT 16";
label variable OBOVA16 "NON-DR OFF VISTS - VA/CHAMPVA AMT 16";
label variable OBOTRI16 "NON-DR OFF VISTS - TRICARE AMT 16";
label variable OBOOFD16 "NON-DR OFF VISTS - OTHER FEDERAL AMT 16";
label variable OBOSTL16 "NON-DR OFF VISTS - OTH ST/LOCAL AMT 16";
label variable OBOWCP16 "NON-DR OFF VISTS - WORKERS COMP AMT 16";
label variable OBOOPR16 "NON-DR OFF VISTS - OTH PRIVATE AMT 16";
label variable OBOOPU16 "NON-DR OFF VISTS - OTH PUBLIC AMT 16";
label variable OBOOSR16 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 16";
label variable OBOPTR16 "NON-DR OFF VISTS - PRV & TRI AMT 16";
label variable OBOOTH16 "NON-DR OFF VISTS - OTH COMBINED AMT 16";
label variable OBCHIR16 "# OFFICE-BASED CHIROPRACTOR VISITS 16";
label variable OBCTCH16 "OFFICE-BASED CHIRO VISIT CHARGES 16";
label variable OBCEXP16 "TOTAL OFF-BASED CHIRO EXP 16";
label variable OBCSLF16 "CHIRO OFF VISITS - SELF/FAMILY AMT 16";
label variable OBCMCR16 "CHIRO OFF VISITS - MEDICARE AMT 16";
label variable OBCMCD16 "CHIRO OFF VISITS - MEDICAID AMT 16";
label variable OBCPRV16 "CHIRO OFF VISITS - PRIVATE INS AMT 16";
label variable OBCVA16 "CHIRO OFF VISITS - VA/CHAMPVA AMT 16";
label variable OBCTRI16 "CHIRO OFF VISITS - TRICARE AMT 16";
label variable OBCOFD16 "CHIRO OFF VISITS - OTHER FEDERAL AMT 16";
label variable OBCSTL16 "CHIRO OFF VISITS - OTH ST/LOCAL AMT 16";
label variable OBCWCP16 "CHIRO OFF VISITS - WORKERS COMP AMT 16";
label variable OBCOPR16 "CHIRO OFF VISTS - OTHR PRIVATE AMT 16";
label variable OBCOPU16 "CHIRO OFF VISTS - OTHR PUBLIC AMT 16";
label variable OBCOSR16 "CHIRO OFF VSTS-OTHR UNCLASS SRCE AMT 16";
label variable OBCPTR16 "CHIRO OFF VISITS - PRV & TRI AMT 16";
label variable OBCOTH16 "CHIRO OFF VISITS -OTH COMBINED AMT 16";
label variable OBNURS16 "# OFF-BASED NURSE/PRACTITIONER VISITS 16";
label variable OBNTCH16 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 16";
label variable OBNEXP16 "TOTAL OFF-BASED NURSE/PRAC 16";
label variable OBNSLF16 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 16";
label variable OBNMCR16 "NURSE/PRAC OFF VISITS - MEDICARE AMT 16";
label variable OBNMCD16 "NURSE/PRAC OFF VSTS - MEDICAID AMT 16";
label variable OBNPRV16 "NURSE/PRAC OFF VSTS-PRIVATE INS AMT 16";
label variable OBNVA16 "NURSE/PRAC OFF VSTS - VA/CHAMPVA AMT 16";
label variable OBNTRI16 "NURSE/PRAC OFF VSTS - TRICARE AMT 16";
label variable OBNOFD16 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 16";
label variable OBNSTL16 "NURSE/PRAC OFF VSTS-OTH ST/LOCAL AMT 16";
label variable OBNWCP16 "NURSE/PRAC OFF VSTS-WORKERS COMP AMT 16";
label variable OBNOPR16 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 16";
label variable OBNOPU16 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 16";
label variable OBNOSR16 "NRS/PR OFF VSTS-OTH UNCLASS SRCE AMT 16";
label variable OBNPTR16 "NURSE/PRAC OFF VSTS - PRV & TRI AMT 16";
label variable OBNOTH16 "NURSE/PRAC OFF VSTS-OTH COMBINED AMT 16";
label variable OBOPTO16 "# OFF-BASED OPTOMETRIST VISITS 16";
label variable OBETCH16 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 16";
label variable OBEEXP16 "TOTAL OFF-BASED OPTOMETRIST EXP 16";
label variable OBESLF16 "OPTOMETRIST OFF VSTS-SELF/FAMILY AMT 16";
label variable OBEMCR16 "OPTOMETRIST OFF VSTS - MEDICARE AMT 16";
label variable OBEMCD16 "OPTOMETRIST OFF VSTS - MEDICAID AMT 16";
label variable OBEPRV16 "OPTOMETRIST OFF VSTS-PRIVATE INS AMT 16";
label variable OBEVA16 "OPTOMETRIST OFF VSTS - VA/CHAMPVA AMT 16";
label variable OBETRI16 "OPTOMETRIST OFF VSTS - TRICARE AMT 16";
label variable OBEOFD16 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 16";
label variable OBESTL16 "OPTOMETRIST OFF VSTS-OTH ST/LOCL AMT 16";
label variable OBEWCP16 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 16";
label variable OBEOPR16 "OPTOMETRIST OFF VSTS-OTH PRIVATE AMT 16";
label variable OBEOPU16 "OPTOMETRIST OFF VSTS - OTH PUBLIC AMT 16";
label variable OBEOSR16 "OPTOM OFF VSTS-OTH UNCLASS SRCE AMT 16";
label variable OBEPTR16 "OPTOMETRIST OFF VSTS - PRV & TRI AMT 16";
label variable OBEOTH16 "OPTOMETRIST OFF VSTS-OTH COMBINED AMT 16";
label variable OBASST16 "# OFF-BASED PHYSICIAN ASSIST VISITS 16";
label variable OBATCH16 "OFFICE-BASED PHYS ASST VISIT CHARGES 16";
label variable OBAEXP16 "TOTAL OFF-BASED PHYS ASS T EXP 16";
label variable OBASLF16 "PHYS ASS T OFF VSTS - SELF/FAMILY AMT 16";
label variable OBAMCR16 "PHYS ASS T OFF VSTS - MEDICARE AMT 16";
label variable OBAMCD16 "PHYS ASS T OFF VSTS - MEDICAID AMT 16";
label variable OBAPRV16 "PHYS ASS T OFF VSTS - PRIVATE INS AMT 16";
label variable OBAVA16 "PHYS ASS T OFF VSTS - VA/CHAMPVA AMT 16";
label variable OBATRI16 "PHYS ASS T OFF VSTS - TRICARE AMT 16";
label variable OBAOFD16 "PHYS ASS T OFF VSTS - OTHER FED AMT 16";
label variable OBASTL16 "PHYS ASS T OFF VSTS - OTH ST/LOCL AMT 16";
label variable OBAWCP16 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 16";
label variable OBAOPR16 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 16";
label variable OBAOPU16 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 16";
label variable OBAOSR16 "P A OFF VSTS - OTH UNCLASS SRCE AMT 16";
label variable OBAPTR16 "PHYS ASST OFF VSTS - PRV & TRI AMT 16";
label variable OBAOTH16 "PHYS ASST OFF VSTS - OTH COMBINED AMT 16";
label variable OBTHER16 "# OFF-BASED PT/OT VISITS 16";
label variable OBTTCH16 "OFFICE-BASED PT/OC VISIT CHARGES 16";
label variable OBTEXP16 "TOT OFF-BASED PT EXP 16";
label variable OBTSLF16 "PT/OT OFF VISITS - SELF/FAMILY AMT 16";
label variable OBTMCR16 "PT/OT OFF VISITS - MEDICARE AMT 16";
label variable OBTMCD16 "PT/OT OFF VISITS - MEDICAID AMT 16";
label variable OBTPRV16 "PT/OT OFF VISITS - PRIVATE INS AMT 16";
label variable OBTVA16 "PT/OT OFF VISITS - VA/CHAMPVA AMT 16";
label variable OBTTRI16 "PT/OT OFF VISITS - TRICARE AMT 16";
label variable OBTOFD16 "PT/OT OFF VISITS - OTHER FED AMT 16";
label variable OBTSTL16 "PT/OT OFF VISITS - OTH ST/LOCL AMT 16";
label variable OBTWCP16 "PT/OT OFF VISITS - WORKERS COMP AMT 16";
label variable OBTOPR16 "PT/OT OFF VISITS - OTH PRIVATE AMT 16";
label variable OBTOPU16 "PT/OT OFF VISITS - OTH PUBLIC AMT 16";
label variable OBTOSR16 "PT/OT OFF VSTS-OTH UNCLASS SRCE AMT 16";
label variable OBTPTR16 "PT/OT OFF VISITS - PRV & TRI AMT 16";
label variable OBTOTH16 "PT/OT OFF VISITS - OTH COMBINED AMT 16";
label variable OPTOTV16 "# OUTPATIENT DEPT PROVIDER VISITS 16";
label variable OPTTCH16 "OPD FACILITY + DR VISIT CHARGES - 16";
label variable OPTEXP16 "TOTAL OUTPATIENT FAC + DR EXP 16";
label variable OPTSLF16 "ALL OPD VSTS-SELF/FAMILY AMT-(FAC+DR) 16";
label variable OPTMCR16 "ALL OPD VSTS-MEDICARE AMT-(FAC+DR) 16";
label variable OPTMCD16 "ALL OPD VSTS-MEDICAID AMT-(FAC+DR) 16";
label variable OPTPRV16 "ALL OPD VSTS-PRIV INS AMT-(FAC+DR) 16";
label variable OPTVA16 "ALL OPD VSTS-VA/CHAMPVA AMT-(FAC+DR) 16";
label variable OPTTRI16 "ALL OPD VSTS-TRICARE AMT-(FAC+DR) 16";
label variable OPTOFD16 "ALL OPD VSTS-OTHER FED AMT-(FAC+DR) 16";
label variable OPTSTL16 "ALL OPD VST-OTH ST/LOCAL AMT(FAC+DR) 16";
label variable OPTWCP16 "ALL OPD VST-WORKRS COMP AMT-(FAC+DR) 16";
label variable OPTOPR16 "ALL OPD VSTS-OTH PRIVATE AMT-(FAC+DR) 16";
label variable OPTOPU16 "ALL OPD VSTS-OTH PUBLIC AMT-(FAC+DR) 16";
label variable OPTOSR16 "ALL OPD VST-OTH UNCLS SRC AMT(FAC+DR) 16";
label variable OPTPTR16 "ALL OPD VISITS-PRV & TRI AMT (FAC+DR) 16";
label variable OPTOTH16 "ALL OPD VSTS-OTH COMBINED AMT(FAC+DR) 16";
label variable OPFTCH16 "OPD PROVIDER VISIT CHARGES - FAC 16";
label variable OPFEXP16 "TOTAL OUTPATIENT FACILITY EXP 16";
label variable OPFSLF16 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 16";
label variable OPFMCR16 "ALL OPD VISITS-MEDICARE AMT-FAC 16";
label variable OPFMCD16 "ALL OPD VISITS-MEDICAID AMT-FAC 16";
label variable OPFPRV16 "ALL OPD VISITS-PRIV INS AMT-FAC 16";
label variable OPFVA16 "ALL OPD VISITS-VA/CHAMPVA AMT-FAC 16";
label variable OPFTRI16 "ALL OPD VISITS-TRICARE AMT-FAC 16";
label variable OPFOFD16 "ALL OPD VISITS-OTHER FED AMT-FAC 16";
label variable OPFSTL16 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 16";
label variable OPFWCP16 "ALL OPD VISITS-WORKERS COMP AMT-FAC 16";
label variable OPFOPR16 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 16";
label variable OPFOPU16 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 16";
label variable OPFOSR16 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 16";
label variable OPFPTR16 "ALL OPD VISITS - PRV & TRI AMT-FAC 16";
label variable OPFOTH16 "ALL OPD VISITS - OTH COMBINED AMT-FAC 16";
label variable OPDEXP16 "TOTAL OUTPATIENT PROVIDER EXP 16";
label variable OPDTCH16 "OPD PROVIDER VISIT CHARGES - DR 16";
label variable OPDSLF16 "ALL OPD VISITS-SELF/FAMILY AMT-DR 16";
label variable OPDMCR16 "ALL OPD VISITS-MEDICARE AMT-DR 16";
label variable OPDMCD16 "ALL OPD VISITS-MEDICAID AMT-DR 16";
label variable OPDPRV16 "ALL OPD VISITS-PRIV INS AMT-DR 16";
label variable OPDVA16 "ALL OPD VISITS-VA/CHAMPVA AMT-DR 16";
label variable OPDTRI16 "ALL OPD VISITS-TRICARE AMT-DR 16";
label variable OPDOFD16 "ALL OPD VISITS-OTHER FED AMT-DR 16";
label variable OPDSTL16 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 16";
label variable OPDWCP16 "ALL OPD VISITS-WORKERS COMP AMT-DR 16";
label variable OPDOPR16 "ALL OPD VISITS - OTH PRIVATE AMT-DR 16";
label variable OPDOPU16 "ALL OPD VISITS-OTH PUBLIC AMT-DR 16";
label variable OPDOSR16 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 16";
label variable OPDPTR16 "ALL OPD VISITS-PRV & TRI AMT -DR 16";
label variable OPDOTH16 "ALL OPD VISITS-OTH COMBINED AMT-DR 16";
label variable OPDRV16 "# OUTPATIENT DEPT PHYSICIAN VISITS 16";
label variable OPVTCH16 "OPD PHYSICIAN VISIT CHARGES - FAC 16";
label variable OPVEXP16 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 16";
label variable OPVSLF16 "OPD DR VISITS-SELF/FAMILY AMT-FAC 16";
label variable OPVMCR16 "OPD DR VISITS-MEDICARE AMT-FAC 16";
label variable OPVMCD16 "OPD DR VISITS-MEDICAID AMT-FAC 16";
label variable OPVPRV16 "OPD DR VISITS-PRIV INS AMT-FAC 16";
label variable OPVVA16 "OPD DR VISITS-VA/CHAMPVA AMT-FAC 16";
label variable OPVTRI16 "OPD DR VISITS-TRICARE AMT-FAC 16";
label variable OPVOFD16 "OPD DR VISITS-OTHER FED AMT-FAC 16";
label variable OPVSTL16 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 16";
label variable OPVWCP16 "OPD DR VISITS-WORKERS COMP AMT-FAC 16";
label variable OPVOPR16 "OPD DR VISITS - OTH PRIVATE AMT-FAC 16";
label variable OPVOPU16 "OPD DR VISITS-OTH PUBLIC AMT-FAC 16";
label variable OPVOSR16 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 16";
label variable OPVPTR16 "OPD DR VISITS - PRV & TRI AMT-FAC 16";
label variable OPVOTH16 "OPD DR VISITS - OTH COMBINED AMT-FAC 16";
label variable OPSEXP16 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 16";
label variable OPSTCH16 "OPD PHYSICIAN VISIT CHARGES - DR 16";
label variable OPSSLF16 "OPD DR VISITS-SELF/FAMILY AMT-DR 16";
label variable OPSMCR16 "OPD DR VISITS-MEDICARE AMT-DR 16";
label variable OPSMCD16 "OPD DR VISITS-MEDICAID AMT-DR 16";
label variable OPSPRV16 "OPD DR VISITS-PRIV INS AMT-DR 16";
label variable OPSVA16 "OPD DR VISITS-VA/CHAMPVA AMT-DR 16";
label variable OPSTRI16 "OPD DR VISITS-TRICARE AMT-DR 16";
label variable OPSOFD16 "OPD DR VISITS-OTHER FED AMT-DR 16";
label variable OPSSTL16 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 16";
label variable OPSWCP16 "OPD DR VISITS-WORKERS COMP AMT-DR 16";
label variable OPSOPR16 "OPD DR VISITS - OTH PRIVATE AMT-DR 16";
label variable OPSOPU16 "OPD DR VISITS-OTH PUBLIC AMT-DR 16";
label variable OPSOSR16 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 16";
label variable OPSPTR16 "OPD DR VISITS - PRV & TRI AMT-DR 16";
label variable OPSOTH16 "OPD DR VISITS -OTH COMBINED AMT-DR 16";
label variable OPOTHV16 "# OUTPATIENT DEPT NON-DR VISITS 16";
label variable OPOTCH16 "OPD NON-PHYS VISIT CHARGES - FAC 16";
label variable OPOEXP16 "TOTAL OUTPATIENT NON-DR - FAC EXP 16";
label variable OPOSLF16 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 16";
label variable OPOMCR16 "OPD NON-DR VISITS-MEDICARE AMT-FAC 16";
label variable OPOMCD16 "OPD NON-DR VISITS-MEDICAID AMT-FAC 16";
label variable OPOPRV16 "OPD NON-DR VISITS-PRIV INS AMT-FAC 16";
label variable OPOVA16 "OPD NON-DR VISITS-VA/CHAMPVA AMT-FAC 16";
label variable OPOTRI16 "OPD NON-DR VISITS-TRICARE AMT-FAC 16";
label variable OPOOFD16 "OPD NON-DR VISITS-OTHER FED AMT-FAC 16";
label variable OPOSTL16 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 16";
label variable OPOWCP16 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 16";
label variable OPOOPR16 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 16";
label variable OPOOPU16 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 16";
label variable OPOOSR16 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 16";
label variable OPOPTR16 "OPD NON-DR VISITS - PRV & TRI AMT-FAC 16";
label variable OPOOTH16 "OPD NON-DR VISITS-OTH COMBINED AM-FAC 16";
label variable OPPEXP16 "TOTAL OUTPATIENT NON-DR - DR EXP 16";
label variable OPPTCH16 "OPD NON-PHYS VISIT CHARGES - DR 16";
label variable OPPSLF16 "OPD NON-DR VISITS-SELF/FAM AMT-DR 16";
label variable OPPMCR16 "OPD NON-DR VISITS-MEDICARE AMT-DR 16";
label variable OPPMCD16 "OPD NON-DR VISITS-MEDICAID AMT-DR 16";
label variable OPPPRV16 "OPD NON-DR VISITS-PRIV INS AMT-DR 16";
label variable OPPVA16 "OPD NON-DR VISITS-VA/CHAMPVA AMT-DR 16";
label variable OPPTRI16 "OPD NON-DR VISITS-TRICARE AMT-DR 16";
label variable OPPOFD16 "OPD NON-DR VISITS-OTHER FED AMT-DR 16";
label variable OPPSTL16 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 16";
label variable OPPWCP16 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 16";
label variable OPPOPR16 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 16";
label variable OPPOPU16 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 16";
label variable OPPOSR16 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 16";
label variable OPPPTR16 "OPD NON-DR VISITS - PRV & TRI AMT-DR 16";
label variable OPPOTH16 "OPD NON-DR VISITS-OTH COMBINED AMT-DR 16";
label variable AMCHIR16 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2016";
label variable AMCTCH16 "CHIRO AMBULATORY VISIT CHARGES 16";
label variable AMCEXP16 "TOTL AMBULTRY (OB+OP) CHIRO EXP 16";
label variable AMCSLF16 "CHIRO AMB VISITS - SELF/FAMILY AMT 16";
label variable AMCMCR16 "CHIRO AMB VISITS - MEDICARE AMT 16";
label variable AMCMCD16 "CHIRO AMB VISITS - MEDICAID AMT 16";
label variable AMCPRV16 "CHIRO AMB VISITS - PRIVATE INS AMT 16";
label variable AMCVA16 "CHIRO AMB VISITS - VA/CHAMPVA AMT 16";
label variable AMCTRI16 "CHIRO AMB VISITS-TRICARE AMT 16";
label variable AMCOFD16 "CHIRO AMB VISITS - OTHER FEDERAL AMT 16";
label variable AMCSTL16 "CHIRO AMB VISITS - OTH ST/LOCAL AMT 16";
label variable AMCWCP16 "CHIRO AMB VISITS-WORKERS COMP AMT 16";
label variable AMCOPR16 "CHIRO AMB VISITS - OTH PRIVATE AMT 16";
label variable AMCOPU16 "CHIRO AMB VISITS - OTH PUBLIC AMT 16";
label variable AMCOSR16 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 16";
label variable AMCPTR16 "CHIRO AMB VISITS -PRV & TRI AMT 16";
label variable AMCOTH16 "CHIRO AMB VISITS - OTH COMBINED AMT 16";
label variable AMNURS16 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 16";
label variable AMNTCH16 "NRS/PRAC AMBULATORY VISIT CHARGES 16";
label variable AMNEXP16 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 16";
label variable AMNSLF16 "NRS/PRAC AMB VSTS - SELF/FAMILY AMT 16";
label variable AMNMCR16 "NRS/PRAC AMB VSTS - MEDICARE AMT 16";
label variable AMNMCD16 "NRS/PRAC AMB VSTS - MEDICAID AMT 16";
label variable AMNPRV16 "NRS/PRAC AMB VSTS - PRIV INS AMT 16";
label variable AMNVA16 "NRS/PRAC AMB VSTS-VA/CHAMPVA AMT 16";
label variable AMNTRI16 "NRS/PRAC AMB VSTS-TRICARE AMT 16";
label variable AMNOFD16 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 16";
label variable AMNSTL16 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 16";
label variable AMNWCP16 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 16";
label variable AMNOPR16 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 16";
label variable AMNOPU16 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 16";
label variable AMNOSR16 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 16";
label variable AMNPTR16 "NRS/PRAC AMB VSTS - PRV & TRI AMT 16";
label variable AMNOTH16 "NRS/PRAC AMB VSTS - OTH COMBINED AMT 16";
label variable AMOPTO16 "# AMB OPTOMETRIST VSTS (OB+OP) 16";
label variable AMETCH16 "OPTOMETRIST AMBULATORY VISIT CHARGES 16";
label variable AMEEXP16 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 16";
label variable AMESLF16 "OPTMTRIST AMB VSTS - SELF/FAMILY AMT 16";
label variable AMEMCR16 "OPTMTRIST AMB VSTS - MEDICARE AMT 16";
label variable AMEMCD16 "OPTMTRIST AMB VSTS - MEDICAID AMT 16";
label variable AMEPRV16 "OPTMTRIST AMB VSTS - PRIVATE INS AMT 16";
label variable AMEVA16 "OPTMTRIST AMB VSTS-VA/CHAMPVA AMT 16";
label variable AMETRI16 "OPTMTRIST AMB VSTS-TRICARE AMT 16";
label variable AMEOFD16 "OPTMTRIST AMB VSTS-OTHER FED AMT 16";
label variable AMESTL16 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 16";
label variable AMEWCP16 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 16";
label variable AMEOPR16 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 16";
label variable AMEOPU16 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 16";
label variable AMEOSR16 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 16";
label variable AMEPTR16 "OPTMTRIST AMB VSTS - PRV & TRI AMT 16";
label variable AMEOTH16 "OPTMTRIST AMB VSTS - OTH COMBINED AMT 16";
label variable AMASST16 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2016";
label variable AMATCH16 "PHYS ASS T AMBULATORY VISIT CHARGES 16";
label variable AMAEXP16 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 16";
label variable AMASLF16 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 16";
label variable AMAMCR16 "PHYS ASS T AMB VSTS-MEDICARE AMT 16";
label variable AMAMCD16 "PHYS ASS T AMB VSTS-MEDICAID AMT 16";
label variable AMAPRV16 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 16";
label variable AMAVA16 "PHYS ASS T AMB VSTS-VA/CHAMPVA AMT 16";
label variable AMATRI16 "PHYS ASS T AMB VSTS-TRICARE AMT 16";
label variable AMAOFD16 "PHYS ASS T AMB VSTS - OTHER FED AMT 16";
label variable AMASTL16 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 16";
label variable AMAWCP16 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 16";
label variable AMAOPR16 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 16";
label variable AMAOPU16 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 16";
label variable AMAOSR16 "P A AMB VSTS - OTH UNCLASS SRCE AMT 16";
label variable AMAPTR16 "PHYS ASS T AMB VSTS - PRV & TRI AMT 16";
label variable AMAOTH16 "PHYS ASS T AMB VSTS-OTH COMBINED AMT 16";
label variable AMTHER16 "# AMB PT/OT THRPY VISITS (OB+OP) 16";
label variable AMTTCH16 "PT/OC AMBULATORY VISIT CHARGES 16";
label variable AMTEXP16 "TOTL AMBULTRY (OB+OP) PT/OT EXP 16";
label variable AMTSLF16 "PT/OT AMB VISITS-SELF/FAMILY AMT 16";
label variable AMTMCR16 "PT/OT AMB VISITS-MEDICARE AMT 16";
label variable AMTMCD16 "PT/OT AMB VISITS-MEDICAID AMT 16";
label variable AMTPRV16 "PT/OT AMB VISITS-PRIVATE INS AMT 16";
label variable AMTVA16 "PT/OT AMB VISITS-VA/CHAMPVA AMT 16";
label variable AMTTRI16 "PT/OT AMB VISITS-TRICARE AMT 16";
label variable AMTOFD16 "PT/OT AMB VISITS - OTHER FED AMT 16";
label variable AMTSTL16 "PT/OT AMB VISITS-OTH ST/LOCL AMT 16";
label variable AMTWCP16 "PT/OT AMB VISITS-WORKERS COMP AMT 16";
label variable AMTOPR16 "PT/OT AMB VISITS - OTH PRIVATE AMT 16";
label variable AMTOPU16 "PT/OT AMB VISITS-OTH PUBLIC AMT 16";
label variable AMTOSR16 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 16";
label variable AMTPTR16 "PT/OT AMB VISITS -PRV & TRI AMT 16";
label variable AMTOTH16 "PT/OT AMB VISITS - OTH COMBINED AMT 16";
label variable AMTOTC16 "# CALLS W/OFFICE & OUPAT DEPTS, 2016";
label variable AMDRC16 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2016";
label variable ERTOT16 "# EMERGENCY ROOM VISITS 16";
label variable ERTTCH16 "ER FACILITY + DR VISIT CHARGES 16";
label variable ERTEXP16 "TOTAL ER FACILITY + DR EXP 16";
label variable ERTSLF16 "ER-SELF/FAMILY AMT-(FAC+DR) 16";
label variable ERTMCR16 "ER-MEDICARE AMT-(FAC+DR) 16";
label variable ERTMCD16 "ER-MEDICAID AMT-(FAC+DR) 16";
label variable ERTPRV16 "ER-PRIV INS AMT-(FAC+DR) 16";
label variable ERTVA16 "ER-VA/CHAMPVA AMT-(FAC+DR) 16";
label variable ERTTRI16 "ER-TRICARE AMT-(FAC+DR) 16";
label variable ERTOFD16 "ER-OTHER FED AMT-(FAC+DR) 16";
label variable ERTSTL16 "ER-OTH ST/LOCAL AMT-(FAC+DR) 16";
label variable ERTWCP16 "ER-WORKERS COMP AMT-(FAC+DR) 16";
label variable ERTOPR16 "ER-OTH PRIVATE AMT-(FAC+DR) 16";
label variable ERTOPU16 "ER-OTH PUBLIC AMT-(FAC+DR) 16";
label variable ERTOSR16 "ER-OTH UNCLASS SRCE AMT-(FAC+DR) 16";
label variable ERTPTR16 "ER-PRV & TRI AMT (FAC+DR) 16";
label variable ERTOTH16 "ER -OTH COMBINED AMT (FAC+DR) 16";
label variable ERFTCH16 "ER FACILITY VISIT CHARGES 16";
label variable ERFEXP16 "TOTAL ER FACILITY EXP 16";
label variable ERFSLF16 "ER-SELF/FAMILY AMT - FAC 16";
label variable ERFMCR16 "ER-MEDICARE AMT - FAC 16";
label variable ERFMCD16 "ER-MEDICAID AMT - FAC 16";
label variable ERFPRV16 "ER-PRIVATE INS AMT - FAC 16";
label variable ERFVA16 "ER-VA/CHAMPVA AMT - FAC 16";
label variable ERFTRI16 "ER-TRICARE AMT - FAC 16";
label variable ERFOFD16 "ER-OTHER FEDERAL AMT - FAC 16";
label variable ERFSTL16 "ER-OTH ST/LOCAL AMT - FAC 16";
label variable ERFWCP16 "ER-WORKERS COMP AMT - FAC 16";
label variable ERFOPR16 "ER-OTHER PRIVATE AMT - FAC 16";
label variable ERFOPU16 "ER-OTHER PUBLIC AMT - FAC 16";
label variable ERFOSR16 "ER-OTH UNCLASS SRCE AMT - FAC 16";
label variable ERFPTR16 "ER-PRV & TRI AMT - FAC 16";
label variable ERFOTH16 "ER-OTH COMBINED AMT - FAC 16";
label variable ERDEXP16 "TOTAL EMERGENCY ROOM DR EXP 16";
label variable ERDTCH16 "ER DOCTOR VISIT CHARGES 16";
label variable ERDSLF16 "ER-SELF/FAMILY AMT - DR 16";
label variable ERDMCR16 "ER-MEDICARE AMT - DR 16";
label variable ERDMCD16 "ER-MEDICAID AMT - DR 16";
label variable ERDPRV16 "ER-PRIVATE INS AMT - DR 16";
label variable ERDVA16 "ER-VA/CHAMPVA AMT - DR 16";
label variable ERDTRI16 "ER-TRICARE AMT - DR 16";
label variable ERDOFD16 "ER-OTHER FED AMT - DR 16";
label variable ERDSTL16 "ER-OTH ST/LOCAL AMT - DR 16";
label variable ERDWCP16 "ER-WORKERS COMP AMT - DR 16";
label variable ERDOPR16 "ER - OTHER PRIVATE AMT - DR 16";
label variable ERDOPU16 "ER - OTHER PUBLIC AMT - DR 16";
label variable ERDOSR16 "ER-OTH UNCLASS SRCE AMT - DR 16";
label variable ERDPTR16 "ER-PRV & TRI AMT - DR 16";
label variable ERDOTH16 "ER-OTH COMBINED AMT - DR 16";
label variable IPZERO16 "# ZERO-NIGHT HOSPITAL STAYS 16";
label variable ZIFTCH16 "ZERO-NITE IP STAY CHARGES - FAC 16";
label variable ZIFEXP16 "TOTAL ZERO-NITE STAYS FAC EXP 16";
label variable ZIFSLF16 "ZERO-NITE IP STAZ-SELF/FAM AMT-FAC 16";
label variable ZIFMCR16 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 16";
label variable ZIFMCD16 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 16";
label variable ZIFPRV16 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 16";
label variable ZIFVA16 "ZERO-NITE IP STAZ-VA/CHAMPVA AMT-FAC 16";
label variable ZIFTRI16 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 16";
label variable ZIFOFD16 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 16";
label variable ZIFSTL16 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 16";
label variable ZIFWCP16 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 16";
label variable ZIFOPR16 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 16";
label variable ZIFOPU16 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 16";
label variable ZIFOSR16 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 16";
label variable ZIFPTR16 "ZERO-NITE IP STAZ-PRV & TRI AMT-FAC 16";
label variable ZIFOTH16 "ZERO-NITE IP STAZ-OTH COMBINE AMT-FAC 16";
label variable ZIDEXP16 "TOTAL ZERO-NITE STAZ DR 16";
label variable ZIDTCH16 "ZERO-NITE IP STAY CHARGES - DR 16";
label variable ZIDSLF16 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 16";
label variable ZIDMCR16 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 16";
label variable ZIDMCD16 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 16";
label variable ZIDPRV16 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 16";
label variable ZIDVA16 "ZERO-NITE IP STAZ-VA/CHAMPVA AMT-DR 16";
label variable ZIDTRI16 "ZERO-NITE IP STAZ-TRICARE AMT-DR 16";
label variable ZIDOFD16 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 16";
label variable ZIDSTL16 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 16";
label variable ZIDWCP16 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 16";
label variable ZIDOPR16 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 16";
label variable ZIDOPU16 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 16";
label variable ZIDOSR16 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 16";
label variable ZIDPTR16 "ZERO-NITE IP STAZ-PRV & TRI AMT-DR 16";
label variable ZIDOTH16 "ZERO-NITE IP STAZ-OTH COMBINED AMT-DR 16";
label variable IPDIS16 "# HOSPITAL DISCHARGES, 2016";
label variable IPTEXP16 "TOT HOSP IP FACILITY + DR EXP 16";
label variable IPTTCH16 "IP HOSP STAY CHARGES (FAC+DR) 16";
label variable IPTSLF16 "IP HOSP STAZ-SELF/FAMILY AMT-(FAC+DR) 16";
label variable IPTMCR16 "IP HOSP STAZ-MEDICARE AMT-(FAC+DR) 16";
label variable IPTMCD16 "IP HOSP STAZ-MEDICAID AMT-(FAC+DR) 16";
label variable IPTPRV16 "IP HOSP STAZ-PRIV INS AMT-(FAC+DR) 16";
label variable IPTVA16 "IP HOSP STAZ-VA/CHAMPVA AMT-(FAC+DR) 16";
label variable IPTTRI16 "IP HOSP STAZ-TRICARE AMT-(FAC+DR) 16";
label variable IPTOFD16 "IP HOSP STAZ-OTHER FED AMT-(FAC+DR) 16";
label variable IPTSTL16 "IP HSP STAZ-OTH ST/LOCAL AMT-(FAC+DR) 16";
label variable IPTWCP16 "IP HOSP STAZ-WRKRS COMP AMT-(FAC+DR) 16";
label variable IPTOPR16 "IP HOSP STAZ-OTH PRIVATE AMT-(FAC+DR) 16";
label variable IPTOPU16 "IP HOSP STAZ-OTH PUBLIC AMT-(FAC+DR) 16";
label variable IPTOSR16 "IP HSP STAZ-OTH UNCLS SRC AMT(FAC+DR) 16";
label variable IPTPTR16 "IP HOSP STAZ-PRV & TRI AMT-(FAC+DR) 16";
label variable IPTOTH16 "IP HOSP STAZ-OTH COMBINED AMT(FAC+DR) 16";
label variable IPFEXP16 "TOT HOSP IP FACILITY EXP-INC 0 NITES 16";
label variable IPFTCH16 "IP HOSP STAY CHARGES - FAC 16";
label variable IPFSLF16 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 16";
label variable IPFMCR16 "IP HOSP STAZ-MEDICARE AMT-FAC 16";
label variable IPFMCD16 "IP HOSP STAZ-MEDICAID AMT-FAC 16";
label variable IPFPRV16 "IP HOSP STAZ-PRIV INS AMT-FAC 16";
label variable IPFVA16 "IP HOSP STAZ-VA/CHAMPVA AMT-FAC 16";
label variable IPFTRI16 "IP HOSP STAZ-TRICARE AMT-FAC 16";
label variable IPFOFD16 "IP HOSP STAZ-OTHER FED AMT-FAC 16";
label variable IPFSTL16 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 16";
label variable IPFWCP16 "IP HOSP STAZ-WORKERS COMP AMT-FAC 16";
label variable IPFOPR16 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 16";
label variable IPFOPU16 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 16";
label variable IPFOSR16 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 16";
label variable IPFPTR16 "IP HOSP STAZ-PRV & TRI AMT-FAC 16";
label variable IPFOTH16 "IP HOSP STAZ-OTH COMBINED AMT-FAC 16";
label variable IPDEXP16 "TOTL HOSP STAZ DR EXP 16";
label variable IPDTCH16 "IP HOSP STAY CHARGES - DR 16";
label variable IPDSLF16 "IP HOSP STAZ-SELF/FAMILY AMT-DR 16";
label variable IPDMCR16 "IP HOSP STAZ-MEDICARE AMT- DR 16";
label variable IPDMCD16 "IP HOSP STAZ-MEDICAID AMT-DR 16";
label variable IPDPRV16 "IP HOSP STAZ-PRIV INS AMT-DR 16";
label variable IPDVA16 "IP HOSP STAZ-VA/CHAMPVA AMT-DR 16";
label variable IPDTRI16 "IP HOSP STAZ-TRICARE AMT-DR 16";
label variable IPDOFD16 "IP HOSP STAZ-OTHER FED AMT-DR 16";
label variable IPDSTL16 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 16";
label variable IPDWCP16 "IP HOSP STAZ-WORKERS COMP AMT-DR 16";
label variable IPDOPR16 "IP HOSP STAZ - OTH PRIVATE AMT-DR 16";
label variable IPDOPU16 "IP HOSP STAZ - OTH PUBLIC AMT-DR 16";
label variable IPDOSR16 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 16";
label variable IPDPTR16 "IP HOSP STAZ-PRV & TRI AMT-DR 16";
label variable IPDOTH16 "IP HOSP STAZ-OTH COMBINED AMT-DR 16";
label variable IPNGTD16 "# NIGHTS IN HOSP FOR DISCHARGES, 2016";
label variable DVTOT16 "# DENTAL CARE VISITS 16";
label variable DVTTCH16 "TOTAL DENTAL CARE VISIT CHARGES 16";
label variable DVTEXP16 "TOTAL DENTAL CARE EXP 16";
label variable DVTSLF16 "ALL DENTAL CARE - SELF/FAMILY AMT 16";
label variable DVTMCR16 "ALL DENTAL CARE - MEDICARE AMT 16";
label variable DVTMCD16 "ALL DENTAL CARE - MEDICAID AMT 16";
label variable DVTPRV16 "ALL DENTAL CARE - PRIVATE INS AMT 16";
label variable DVTVA16 "ALL DENTAL CARE - VA/CHAMPVA AMT 16";
label variable DVTTRI16 "ALL DENTAL CARE - TRICARE AMT 16";
label variable DVTOFD16 "ALL DENTAL CARE - OTHER FEDRL AMT 16";
label variable DVTSTL16 "ALL DENTAL CARE - OTH ST/LOCAL AMT 16";
label variable DVTWCP16 "ALL DENTAL CARE - WORKERS COMP AMT 16";
label variable DVTOPR16 "ALL DENTAL CARE - OTH PRIVATE AMT 16";
label variable DVTOPU16 "ALL DENTAL CARE - OTH PUBLIC AMT 16";
label variable DVTOSR16 "ALL DENT CARE-OT UNCLASS SRCE AMT 16";
label variable DVTPTR16 "ALL DENTAL CARE - PRV & TRI AMT 16";
label variable DVTOTH16 "ALL DENTAL CARE - OTH COMBINED AMT 16";
label variable DVGEN16 "# GENERAL DENTIST VISITS 16";
label variable DVGTCH16 "GENERAL DENTAL CARE VISIT CHARGES 16";
label variable DVGEXP16 "TOTAL GENERAL DENTIST EXP 16";
label variable DVGSLF16 "GNRL DENTAL VISITS - SELF/FAM AMT 16";
label variable DVGMCR16 "GNRL DENTAL VISITS - MEDICARE AMT 16";
label variable DVGMCD16 "GNRL DENTAL VISITS - MEDICAID AMT 16";
label variable DVGPRV16 "GNRL DENTAL VISITS - PRIVATE INS AMT 16";
label variable DVGVA16 "GNRL DENTAL VISITS - VA/CHAMPVA AMT 16";
label variable DVGTRI16 "GNRL DENTAL VISITS-TRICARE AMT 16";
label variable DVGOFD16 "GNRL DENTAL VISITS - OTHER FED AMT 16";
label variable DVGSTL16 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 16";
label variable DVGWCP16 "GNRL DENTAL VISITS - WORKERS COMP AMT 16";
label variable DVGOPR16 "GNRL DENTAL VISITS - OTH PRIVATE AMT 16";
label variable DVGOPU16 "GNRL DENTAL VISITS - OTH PUBLIC AMT 16";
label variable DVGOSR16 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 16";
label variable DVGPTR16 "GNRL DENTAL VISITS - PRV & TRI AMT 16";
label variable DVGOTH16 "GNRL DENTAL VISITS - OTH COMBINED AMT 16";
label variable DVORTH16 "# ORTHODONTIST VISITS 16";
label variable DVOTCH16 "ORTHODONTIST VISIT CHARGES 16";
label variable DVOEXP16 "TOTAL ORTHODONTIST EXP 16";
label variable DVOSLF16 "ORTHODONTIST VISITS - SELF/FAMILY AMT 16";
label variable DVOMCR16 "ORTHODONTIST VISITS - MEDICARE AMT 16";
label variable DVOMCD16 "ORTHODONTIST VISITS - MEDICAID AMT 16";
label variable DVOPRV16 "ORTHODONTIST VISITS - PRIVATE INS AMT 16";
label variable DVOVA16 "ORTHODONTIST VISITS-VA/CHAMPVA AMT 16";
label variable DVOTRI16 "ORTHODONTIST VISITS-TRICARE AMT 16";
label variable DVOOFD16 "ORTHODONTIST VISITS-OTHR FED AMT 16";
label variable DVOSTL16 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 16";
label variable DVOWCP16 "ORTHODONTIST VISITS-WORKERS COMP AMT 16";
label variable DVOOPR16 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 16";
label variable DVOOPU16 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 16";
label variable DVOOSR16 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 16";
label variable DVOPTR16 "ORTHODONTIST VISITS - PRV & TRI AMT 16";
label variable DVOOTH16 "ORTHODONTIST VISITS-OTH COMBINED AMT 16";
label variable HHTOTD16 "# HOME HEALTH PROVIDER DAYS, 2016";
label variable HHAGD16 "# AGENCY HOME HEALTH PROVIDER DAYS 16";
label variable HHATCH16 "HOME HEALTH AGENCY VISIT CHARGES 16";
label variable HHAEXP16 "TOTAL HOME HEALTH AGENCY EXP 16";
label variable HHASLF16 "HOME HLTH AGENCY - SELF/FAMILY AMT 16";
label variable HHAMCR16 "HOME HLTH AGENCY - MEDICARE AMT 16";
label variable HHAMCD16 "HOME HLTH AGENCY - MEDICAID AMT 16";
label variable HHAPRV16 "HOME HLTH AGENCY - PRIVATE INS AMT 16";
label variable HHAVA16 "HOME HLTH AGENCY-VA/CHAMPVA AMT 16";
label variable HHATRI16 "HOME HLTH AGENCY-TRICARE AMT 16";
label variable HHAOFD16 "HOME HLTH AGENCY - OTHER FED AMT 16";
label variable HHASTL16 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 16";
label variable HHAWCP16 "HOME HLTH AGENCY - WORKERS COMP AMT 16";
label variable HHAOPR16 "HOME HLTH AGENCY - OTH PRIVATE AMT 16";
label variable HHAOPU16 "HOME HLTH AGENCY - OTH PUBLIC AMT 16";
label variable HHAOSR16 "H HLTH AGENCY - OT UNCLASS SRCE AMT 16";
label variable HHAPTR16 "HOME HLTH AGENCY - PRV & TRI AMT 16";
label variable HHAOTH16 "HOME HLTH AGENCY - OTH COMBINED AMT 16";
label variable HHINDD16 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 16";
label variable HHNTCH16 "HOME HEALTH NON-AGENCY VISIT CHARGES 16";
label variable HHNEXP16 "TOTAL HOME HEALTH NON-AGNCY EXP 16";
label variable HHNSLF16 "HOME HLTH NON-AGNCY - SELF/FAM AMT 16";
label variable HHNMCD16 "HOME HLTH NON-AGNCY - MEDICAID AMT 16";
label variable HHNMCR16 "HOME HLTH NON-AGNCY - MEDICARE AMT 16";
label variable HHNPRV16 "HOME HLTH NON-AGNCY - PRIV INS AMT 16";
label variable HHNVA16 "HOME HLTH NON-AGNCY-VA/CHAMPVA AMT 16";
label variable HHNTRI16 "HOME HLTH NON-AGNCY-TRICARE AMT 16";
label variable HHNOFD16 "HOME HLTH NON-AGNCY-OTHR FED AMT 16";
label variable HHNSTL16 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 16";
label variable HHNWCP16 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 16";
label variable HHNOPR16 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 16";
label variable HHNOPU16 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 16";
label variable HHNOSR16 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 16";
label variable HHNPTR16 "HOME HLTH NON-AGNCY - PRV & TRI AMT 16";
label variable HHNOTH16 "HOME HLTH NON-AGNCY-OTH COMBINED AMT 16";
label variable HHINFD16 "# INFORMAL HOME HEALTH PROVIDER DAYS 16";
label variable VISEXP16 "TOTAL GLASSES/CONTACT LENS EXP 16";
label variable VISTCH16 "GLASSES/CONTACT LENSES CHARGES 16";
label variable VISSLF16 "GLASSES/CNTCT LENSES -SELF/FAM AMT 16";
label variable VISMCR16 "GLASSES/CNTCT LENSES-MEDICARE AMT 16";
label variable VISMCD16 "GLASSES/CNTCT LENSES-MEDICAID AMT 16";
label variable VISPRV16 "GLASSES/CNTCT LENSES-PRIV INS AMT 16";
label variable VISVA16 "GLASSES/CNTCT LENSES-VA/CHAMPVA AMT 16";
label variable VISTRI16 "GLASSES/LENSES-TRICARE AMT 16";
label variable VISOFD16 "GLASSES/CNTCT LENSES-OTHR FED AMT 16";
label variable VISSTL16 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 16";
label variable VISWCP16 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 16";
label variable VISOPR16 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 16";
label variable VISOPU16 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 16";
label variable VISOSR16 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 16";
label variable VISPTR16 "GLASSES/CNTCT LENSES-PRV & TRI AMT 16";
label variable VISOTH16 "GLASSES/CNTCT LENSES-OTH COMBINED AMT 16";
label variable OTHTCH16 "OTHER EQUP/SUPPLIES CHARGES 16";
label variable OTHEXP16 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 16";
label variable OTHSLF16 "OTHER EQUP/SUPPLIES-SELF/FAM AMT 16";
label variable OTHMCR16 "OTHER EQUP/SUPPLIES-MEDICARE AMT 16";
label variable OTHMCD16 "OTHER EQUP/SUPPLIES-MEDICAID AMT 16";
label variable OTHPRV16 "OTHER EQUP/SUPPLIES-PRIV INS AMT 16";
label variable OTHVA16 "OTHER EQUP/SUPPLY-VA/CHAMPVA AMT 16";
label variable OTHTRI16 "OTHER EQUP/SUPPLY-TRICARE AMT 16";
label variable OTHOFD16 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 16";
label variable OTHSTL16 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 16";
label variable OTHWCP16 "OTHER EQUP/SUPPLY - WORKERS COMP AMT 16";
label variable OTHOPR16 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 16";
label variable OTHOPU16 "OTHER EQUP/SUPPLY - OTH PUBLIC AMT 16";
label variable OTHOSR16 "OTH EQUP/SUPLY - OT UNCLASS SRCE AMT 16";
label variable OTHPTR16 "OTHER EQUP/SUPPLY - PRV & TRI AMT 16";
label variable OTHOTH16 "OTHER EQUP/SUPPLY - OTH COMBINED AMT 16";
label variable RXTOT16 "# PRESC MEDS INCL REFILLS 16";
label variable RXEXP16 "TOTAL RX-EXP 16";
label variable RXSLF16 "TOTAL RX-SELF/FAMILY AMT 16";
label variable RXMCR16 "TOTAL RX-MEDICARE AMT 16";
label variable RXMCD16 "TOTAL RX-MEDICAID AMT 16";
label variable RXPRV16 "TOTAL RX-PRIVATE INS AMT 16";
label variable RXVA16 "TOTAL RX-VA/CHAMPVA AMT 16";
label variable RXTRI16 "TOTAL RX-TRICARE AMT 16";
label variable RXOFD16 "TOTAL RX-OTHER FED AMT 16";
label variable RXSTL16 "TOTAL RX-OTHER ST/LOCAL AMT 16";
label variable RXWCP16 "TOTAL RX-WORKERS COMP AMT 16";
label variable RXOPR16 "TOTAL RX-OTH PRIVATE AMT 16";
label variable RXOPU16 "TOTAL RX-OTH PUBLIC AMT 16";
label variable RXOSR16 "TOT RX-OTH UNCLASS SRCE AMT 16";
label variable RXPTR16 "TOTAL RX-PRV & TRI AMT 16";
label variable RXOTH16 "TOTAL RX-OTH COMBINED AMT 16";
label variable PERWT16F "FINAL PERSON WEIGHT, 2016";
label variable FAMWT16F "FINAL FAMILY WEIGHT, 2016";
label variable FAMWT16C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/16";
label variable SAQWT16F "FINAL SAQ PERSON WEIGHT, 2016";
label variable DIABW16F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable CSAQW16F "FINAL CANCER SAQ PERSON WEIGHT - 2016";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2016";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2016";


*DEFINE VALUE LABELS FOR REPORTS;
label define H1920001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1920002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1920003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1920004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1920005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1920008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1920009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1920010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1920013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1920014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1920015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1920017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1920024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1920027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1920028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1920031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1920032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1920034X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H1920035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1920039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1920040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1920042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1920043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAD NO VISITS IN THE LAST 12 MONTHS" ;

label define H1920044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1920045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H1920046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1920047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF ADMINISTERED"
         10 "10 NIECE/NEPHEW"
         100 "100 INTERVIEWER ADMINISTERED"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD (BLGICAL/ADPT/INLW/STEP/FSTER)"
         49 "49 NOT PERSON ON SAQ LABEL,RELATIONSHIP UNK"
         5 "5 GRANDCHILD"
         6 "6 PARENT (BLGICAL/ADPT/INLW/STEP/FSTER)"
         7 "7 SIBLING (BLGICAL/ADPT/INLW/STEP/FSTER)"
         8 "8 GRANDPARENT"
         9 "9 AUNT/UNCLE"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1920049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1920050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1920052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1920053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1920056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1920058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1920061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1920062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H1920063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1920064X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920066X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1920067X
         0 "0.00"
         1060 "$1 - $1,060" ;

label define H1920068X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920069X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920070X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920071X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920072X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920073X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 RHEUMATOID ARTHRITIS"
         2 "2 OSTEOARTHRITIS"
         3 "3 NOT SPECIFIED" ;

label define H1920074X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920075X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920076X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920077X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920078X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920079X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920080X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920081X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920082X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920084X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920085X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920086X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920087X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920088X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1920089X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9  NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1920090X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN LAST 7 DAYS"
         2 "2 MORE THAN 7, BUT WITHIN LAST 30 DAYS"
         3 "3 MORE THAN 30 DAYS AGO" ;

label define H1920091X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1920092X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1920093X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1920094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2015 "2015 YEAR"
         2016 "2016 YEAR" ;

label define H1920095X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2016 "2016 YEAR" ;

label define H1920096X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2016 "2016 YEAR"
         2017 "2017 YEAR" ;

label define H1920097X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1920098X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1920099X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920101X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920102X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920103X
         -1 "-1 INAPPLICABLE, THOSE WHO ARE DEC/INSTD"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920104X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1920105X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920106X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1920107X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1920108X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1920109X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1920110X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1920111X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1920112X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1920113X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1920114X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1920115X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1920116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920117X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920118X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920119X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920120X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920121X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920122X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920123X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920125X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920126X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920127X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920129X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920130X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920131X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920132X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920133X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920134X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920135X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920136X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920137X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920138X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920139X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920140X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920141X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920142X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 RARELY"
         3 "3 SOMETIMES"
         4 "4 OFTEN"
         5 "5 ALL THE TIME" ;

label define H1920143X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920144X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NONE"
         2 "2 MILD"
         3 "3 MODERATE"
         4 "4 SEVERE"
         5 "5 VERY SEVERE" ;

label define H1920145X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920146X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 6 MONTHS"
         2 "2 6 MONTHS TO LESS THAN 1 YEAR"
         3 "3 1 YEAR TO LESS THAN 3 YEARS"
         4 "4 3 YEARS TO LESS THAN 5 YEARS"
         5 "5 5 YEARS TO LESS THAN 10 YEARS"
         6 "6 MORE THAN 10 YEARS" ;

label define H1920147X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1920148X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 RARELY"
         3 "3 SOMETIMES"
         4 "4 OFTEN"
         5 "5 ALWAYS" ;

label define H1920149X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920150X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920151X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COMPLETELY"
         2 "2 MOSTLY"
         3 "3 MODERATELY"
         4 "4 A LITTLE"
         5 "5 NOT AT ALL" ;

label define H1920152X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1920153X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         0 "0 0 - NO PAIN"
         1 "1 1"
         10 "10 10 - WORST IMAGINABLE PAIN"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5"
         6 "6 6"
         7 "7 7"
         8 "8 8"
         9 "9 9" ;

label define H1920154X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920155X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1920156X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1920157X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920158X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920159X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920160X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920161X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920162X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920163X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920164X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920165X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DON'T KNOW" ;

label define H1920166X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920167X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920168X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920169X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920170X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920171X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920172X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920173X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920174X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NO CAREGIVERS EMPLOYED WHILE PROV CARE"
         4 "4 DON'T KNOW" ;

label define H1920175X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN $10,000"
         2 "2 $10,000 TO $24,999"
         3 "3 $25,000 TO $49,999"
         4 "4 $50,000 TO $74,999"
         5 "5 $75,000 TO $99,999"
         6 "6 $100,000 OR MORE" ;

label define H1920176X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920177X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920178X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920179X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920180X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920181X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920182X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920183X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920184X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920185X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920186X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920187X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920188X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920189X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1920191X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920195X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920196X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920197X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1920198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920202X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1920203X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1920204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1920205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920210X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1920211X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920213X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920214X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920215X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1920218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920222X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920223X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920230X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920233X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DOES NOT APPLY" ;

label define H1920234X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT AT ALL DIFFICULT"
         4 "4 DON'T KNOW"
         5 "5 DOES NOT APPLY" ;

label define H1920235X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BETTER"
         2 "2 ABOUT THE SAME"
         3 "3 WORSE"
         4 "4 DON'T KNOW"
         5 "5 DOES NOT APPLY" ;

label define H1920236X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DON'T KNOW" ;

label define H1920237X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT AT ALL DIFFICULT"
         4 "4 DON'T KNOW"
         5 "5 DOES NOT APPLY" ;

label define H1920238X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920239X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920240X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920241X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920242X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920243X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920244X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DOES NOT APPLY" ;

label define H1920245X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920246X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920247X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920248X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920249X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920250X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920252X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1920253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1920254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1920255X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920256X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 1 YEAR AGO"
         2 "2 1 YEAR AGO TO LESS THAN 3 YEARS AGO"
         3 "3 3 YEARS AGO TO LESS THAN 5 YEARS AGO"
         4 "4 5 YEARS AGO TO LESS THAN 10 YEARS AGO"
         5 "5 10 YEARS AGO TO 20 YEARS AGO"
         6 "6 MORE THAN 20 YEARS AGO"
         7 "7 NO, HAVE NOT BEEN TREATED FOR CANCER" ;

label define H1920257X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H1920258X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H1920259X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920260X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H1920261X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H1920262X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H1920263X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H1920264X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920265X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920266X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920267X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1920268X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1920269X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1920270X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1920271X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1920272X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1920273X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1920274X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H1920275X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920276X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920277X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920278X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920279X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920280X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920281X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920282X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920283X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920284X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920285X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1920286X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1920287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920289X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920290X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT REQUIRED TO PERFORM PHYS TASK" ;

label define H1920291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920292X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H1920293X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1920294X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DOES NOT APPLY" ;

label define H1920295X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920296X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920297X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920298X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DUE TO CANCER, TREATMENT, EFFECTS"
         2 "2 SOME OTHER REASON" ;

label define H1920299X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1920300X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920301X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920302X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920303X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1920304X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920305X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H1920306X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920307X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920308X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920309X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1920310X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920311X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920312X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920313X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920314X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920315X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920316X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920317X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920318X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920319X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1920320X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1920321X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1920322X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1920323X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1920324X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1920325X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1920326X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920327X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920328X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1920329X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920330X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920331X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920332X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1920333X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1920334X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920335X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920336X
         -1 "-1 INAPPLICABLE"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H1920337X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H1920338X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE"
         96 "96 DID NOT HAVE A1C BLOOD TEST" ;

label define H1920339X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920344X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920346X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920347X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT CONFIDENT AT ALL"
         2 "2 SOMEWHAT CONFIDENT"
         3 "3 CONFIDENT"
         4 "4 VERY CONFIDENT" ;

label define H1920348X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920349X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920357X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920358X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920359X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920360X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8  DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920361X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920362X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920363X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920364X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920365X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920366X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920367X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920368X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920369X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920370X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920371X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920372X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920373X
         0 "0.00"
         930 "$1 - $930" ;

label define H1920374X
         0 "0.00"
         85 "$1 - $85" ;

label define H1920375X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920376X
         0 "0.00"
         261 "$1 - $261" ;

label define H1920377X
         0 "0.00"
         96 "$1 - $96" ;

label define H1920378X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920379X
         0 "0.00"
         930 "$1 - $930" ;

label define H1920380X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920381X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H1920382X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1920383X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1920384X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1920385X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1920386X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1920387X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920388X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920389X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H1920390X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         34 "34 NOT EMPL AT INT DATE/NOT EMPL DUR RD 3/1" ;

label define H1920391X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H1920392X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         34 "34 NOT EMPL AT INT DATE/NOT EMPL DUR RD 4/2" ;

label define H1920393X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H1920394X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         34 "34 NOT EMPL AT INT DATE/NOT EMPL DUR RD 5/3" ;

label define H1920395X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1920396X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1920397X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1920398X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1920399X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2015 "2015 YEAR"
         2016 "2016 YEAR" ;

label define H1920400X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2015 "2015 YEAR"
         2016 "2016 YEAR" ;

label define H1920401X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2016 "2016 YEAR" ;

label define H1920402X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2016 "2016 YEAR"
         2017 "2017 YEAR" ;

label define H1920403X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920404X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920405X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920406X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920407X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920408X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1920409X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1920410X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1920411X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1920412X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1920413X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920414X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H1920415X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H1920416X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1920417X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H1920418X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1920419X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1920420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920421X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H1920423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920424X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920425X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1920426X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1920427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1920428X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1920429X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1920430X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920431X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920432X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1920433X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920434X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920435X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920436X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920437X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920438X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920439X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920440X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920441X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920442X
         0 "0.00"
         1125 "$1 - $1,125" ;

label define H1920443X
         0 "0.00"
         60 "$1 - $60" ;

label define H1920444X
         0 "0.00"
         2000 "$1 - $2,000" ;

label define H1920445X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920446X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920447X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920448X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H1920449X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H1920450X
         -1 "-1 INAPPLICABLE"
         1 "1 MEXICAN/MEX AMER/CHICANO-NO OTHER HISP"
         2 "2 PUERTO RICAN -NO OTHER HISP REPORTED"
         3 "3 CUBAN/CUBAN AMERICAN -NO OTHER HISP RPTD"
         4 "4 DOMINICAN -NO OTHER HISP REPORTED"
         5 "5 CENTRAL OR SOUTH AMERICAN -NO OTHER HISP"
         6 "6 OTH LAT AM/HISP/LATINO/SPNSH ORGN-NO OTH"
         8 "8 MULTIPLE HISPANIC GROUPS REPORTED"
         9 "9 NON-HISPANIC" ;

label define H1920451X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1920452X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1920453X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1920454X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1920455X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920456X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920457X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920458X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920459X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920460X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920461X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920462X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920463X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920464X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920465X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920466X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920467X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920468X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920469X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920470X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920471X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920472X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920473X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920474X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920475X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920476X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920477X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920478X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920479X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920480X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920481X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920482X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920483X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920484X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920485X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920486X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920487X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920488X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920489X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920490X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920491X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920492X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920493X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920494X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920495X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920496X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920497X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920498X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920499X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920500X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920501X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920502X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920503X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920504X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920505X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920506X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920507X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920508X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920509X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920510X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920511X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920512X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920514X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920515X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920516X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920517X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920518X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920522X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920523X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920540X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920542X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1920543X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1920544X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1920545X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE" ;

label define H1920546X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $85.10"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920547X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE" ;

label define H1920548X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $85.10"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920549X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE" ;

label define H1920550X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $85.10"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920551X
         0 "0 NO"
         1 "1 YES" ;

label define H1920552X
         0 "0 NO"
         1 "1 YES" ;

label define H1920553X
         0 "0 NO"
         1 "1 YES" ;

label define H1920554X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920555X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920556X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920557X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY WELL"
         2 "2 WELL"
         3 "3 NOT WELL"
         4 "4 NOT AT ALL"
         5 "5 UNDER 5 AND OTHLANG=1, INAPPLICABLE" ;

label define H1920558X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920559X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920560X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920561X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1920562X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1920563X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1920564X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1920565X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1920566X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1920567X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920568X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920569X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920570X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920571X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920572X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920573X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920574X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920575X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920576X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920577X
         1 "1 IN-SCOPE ON 12/31/2016"
         2 "2 NOT IN-SCOPE ON 12/31/2016" ;

label define H1920578X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/16"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1920579X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/16"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1920580X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/16"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1920581X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/16"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1920582X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2016"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2016" ;

label define H1920583X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H1920584X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920585X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920586X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920587X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920588X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920589X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920590X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920591X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920592X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920593X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920594X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920595X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920596X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920597X
         -1 "-1 INAPPLICABLE"
         1 "1 <65 ANY PRIVATE"
         2 "2 <65 PUBLIC ONLY"
         3 "3 <65 UNINSURED"
         4 "4 65+ EDITED MEDICARE ONLY"
         5 "5 65+ EDITED MEDICARE AND PRIVATE"
         6 "6 65+ EDITED MEDICARE AND OTH PUB ONLY"
         7 "7 65+ UNINSURED"
         8 "8 65+ NO MEDICARE AND ANY PUBLIC/PRIVATE" ;

label define H1920598X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1920599X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H1920600X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920601X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920602X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1920603X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1920604X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1920605X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1920606X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920607X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1920608X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1920609X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1920610X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920611X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920612X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920613X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920614X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920615X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H1920616X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1920617X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920618X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPANISH"
         2 "2 ANOTHER LANGUAGE" ;

label define H1920619X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920620X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT" ;

label define H1920621X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT" ;

label define H1920622X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H1920623X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920624X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1920625X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H1920626X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1920627X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1920628X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1920629X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920630X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920631X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920632X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920633X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920634X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920635X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920636X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920637X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920638X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920639X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920640X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920641X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920642X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920643X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920644X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920645X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920646X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920647X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920648X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920649X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920650X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920651X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920652X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920653X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920654X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920655X
         1 "1 YES"
         2 "2 NO" ;

label define H1920656X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920657X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920658X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1920659X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1920660X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1920661X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920662X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920663X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920664X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920665X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920666X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920667X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920668X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920669X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1920670X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1920671X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1920672X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920673X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920674X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920675X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920676X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920677X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920678X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920679X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920680X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920681X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920682X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920683X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920684X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920685X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920686X
         1 "1 YES"
         2 "2 NO" ;

label define H1920687X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920688X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920689X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920690X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920691X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920692X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920693X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920694X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920695X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920696X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920697X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920698X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920699X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920700X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920701X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920702X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920703X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1920704X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1920705X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1920706X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1920707X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1920708X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1920709X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1920710X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1920711X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1920712X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1920713X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1920714X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1920715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920716X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920717X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920718X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1920719X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920720X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1920721X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1920722X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920723X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1920724X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920725X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920726X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920727X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1920728X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1920729X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920730X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1920731X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1920732X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1920733X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1920734X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920736X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920738X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920740X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920741X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1920742X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1920743X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1920744X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920745X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920746X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1920747X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920748X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920749X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$85.10"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920750X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$85.10"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920751X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$85.10"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920752X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920753X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920754X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920755X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920756X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920757X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920758X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H1920759X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920760X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920761X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920762X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920763X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920764X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920765X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1920766X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1920767X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1920768X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920769X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920770X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920771X
         0 "0.00"
         960 "$1 - $960" ;

label define H1920772X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920773X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920774X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920775X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920776X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920777X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1920778X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1920779X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1920780X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1920781X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1920782X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1920783X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920784X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920785X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920786X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920787X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920788X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920789X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920790X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920791X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920792X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920793X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920794X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920795X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920796X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920797X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920798X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920799X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920800X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920801X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920802X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920803X
         1 "1 YES"
         2 "2 NO" ;

label define H1920804X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920805X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920806X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920807X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920808X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920809X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920810X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920811X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920812X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920813X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920814X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920815X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920816X
         1 "1 YES"
         2 "2 NO" ;

label define H1920817X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920818X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920819X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920820X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920821X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920822X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920823X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920824X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920825X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920826X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920827X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920828X
         0 "0.00"
         36 "$1 - $36" ;

label define H1920829X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920830X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920831X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1920832X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920833X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920834X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1920835X
         0 "0.00"
         250 "$1 - $250" ;

label define H1920836X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920837X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920838X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920839X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920840X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920841X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920842X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920843X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920844X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920845X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920846X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920847X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920848X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920849X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920850X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920851X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920852X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920853X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920854X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920855X
         20 "20 PANEL 20"
         21 "21 PANEL 21" ;

label define H1920856X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1920857X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920858X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920859X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920860X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920861X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920862X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920863X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920864X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920865X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920866X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920867X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920868X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920869X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920870X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920871X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920872X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920873X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920874X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920875X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920876X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920877X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920878X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920879X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920880X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920881X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920882X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920883X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920884X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920885X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920886X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920887X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920888X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920889X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920890X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1920891X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920892X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1920893X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1920894X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920895X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920896X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H1920897X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920898X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920899X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920900X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1920901X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920902X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920903X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920904X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1920905X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1920906X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1920907X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920908X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920909X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920910X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920911X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1920912X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920913X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920914X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920915X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920916X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920917X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920918X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920919X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920920X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920921X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920922X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920923X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920924X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920925X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920926X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920927X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920928X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920929X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920930X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920931X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920932X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920933X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920934X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920935X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920936X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920937X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920938X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920939X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920940X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920941X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920942X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920943X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920944X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920945X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920946X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920947X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920948X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H1920949X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920950X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920951X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920952X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920953X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920954X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920955X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920956X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920957X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920958X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920959X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920960X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920961X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920962X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920963X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920964X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920965X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920966X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920967X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920968X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920969X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920970X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920971X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920972X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920973X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920974X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920975X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920976X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920977X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920978X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920979X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920980X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920981X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920982X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920983X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920984X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920985X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920986X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920987X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920988X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920989X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920990X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920991X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920992X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920993X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920994X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1920995X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920996X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920997X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920998X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1920999X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H1921000X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1921001X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1921002X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1921003X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1921004X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921005X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921006X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921007X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921008X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921009X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921010X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921011X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921012X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921013X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921014X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921015X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921016X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921017X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921018X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921019X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921020X
         1 "1 YES"
         2 "2 NO" ;

label define H1921021X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1921022X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1921023X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1921024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921025X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921026X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921027X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921028X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921029X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921030X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921031X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921032X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921033X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921034X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921035X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921036X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1921038X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1921039X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1921040X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1921041X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921042X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921043X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921044X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921045X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921046X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921047X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921048X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921049X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921050X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921051X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921052X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921053X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1921054X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921055X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921056X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921057X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921058X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921059X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921060X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921061X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921063X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921064X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921065X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921066X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1921067X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1921068X
         -1 "-1 INAPPLICABLE"
         1 "1 HISPANIC"
         2 "2 NON-HISPANIC WHITE ONLY"
         3 "3 NON-HISPANIC BLACK ONLY"
         4 "4 NON-HISPANIC ASIAN ONLY"
         5 "5 NON-HISPANIC OTHER RACE OR MULTIPLE RACE" ;

label define H1921069X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE-NO OTHER RACE"
         4 "4 ASIAN/NATV HAWAIIAN/PACFC ISL-NO OTH"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H1921070X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         10 "10 OTH ASIAN/NATV HAWAIIAN/PACFC ISL-NO OTH"
         12 "12 MULTIPLE RACES REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE-NO OTHER RACE"
         4 "4 ASIAN INDIAN - NO OTHER RACE REPORTED"
         5 "5 CHINESE - NO OTHER RACE REPORTED"
         6 "6 FILIPINO - NO OTHER RACE REPORTED" ;

label define H1921071X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1921072X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1921073X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1921074X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921075X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1921076X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1921077X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1921078X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1921079X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1921080X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1921081X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1921082X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1921083X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1921084X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1921085X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1921086X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1921087X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1921088X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921089X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921090X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921091X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H1921092X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1921093X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1921094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1921095X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921096X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921097X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921098X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1921099X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1921100X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1921101X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1921102X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1921103X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1921104X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1921105X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1921106X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921107X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1921108X
         0 "0 NOT ELIGIBLE FOR SAQ"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H1921109X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1921110X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921111X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921112X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1921113X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921114X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921115X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H1921117X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921118X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921119X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921120X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921121X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1921122X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H1921123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1921124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1921125X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1921126X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921127X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921128X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921129X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921130X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921131X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921132X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921133X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921134X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1921135X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1921136X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1921137X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YEARS OLD" ;

label define H1921138X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1921139X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1921140X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1921141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1921142X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1921143X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1921144X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1921145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1921146X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1921147X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1921148X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921149X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921150X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921151X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921152X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921153X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921154X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921155X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921156X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921157X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921158X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921159X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921160X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921161X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921162X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921163X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1921165X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1921166X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1921167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1921168X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1921169X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1921170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1921171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1921172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1921174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1921175X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921176X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921177X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921178X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1921180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG FORM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H1921182X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1921183X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1921184X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1921185X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921186X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H1921187X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921188X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1921189X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921190X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921191X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921192X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921193X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921194X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921195X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921196X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1921197X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1921198X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1921199X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921200X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921201X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921202X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921203X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921204X
         1 "1 YES"
         2 "2 NO" ;

label define H1921205X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1921206X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1921207X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1921208X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921209X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921210X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921211X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921212X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1921213X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1921214X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1921215X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921216X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921217X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921218X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921219X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1921220X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1921221X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1921222X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921223X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1921224X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1921225X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1921226X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1921227X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         15 "15 MD - ENDOCRINOLOGIST"
         16 "16 MD - GASTROENTEROLOGIST"
         17 "17 MD - GERIATRICIAN"
         18 "18 MD - NEPHROLOGIST"
         19 "19 MD - ONCOLOGIST"
         2 "2 MD - INTERNAL MEDICINE"
         20 "20 MD - PULMONOLOGIST"
         21 "21 MD - RHEUMATOLOGIST"
         22 "22 PSYCHIATRIST/PSYCHOLOGIST"
         23 "23 MD - NEUROLOGIST"
         24 "24 ALTERNATIVE CARE PROVIDER"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H1921228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921230X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1921231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1921232X
         1 "1 YES"
         2 "2 NO" ;

label define H1921233X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921234X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921235X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921236X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921237X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921238X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1921239X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921240X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1921241X
         0 "0.00"
         598 "$1 - $598" ;

label define H1921242X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1921243X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921244X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921247X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921248X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921249X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921252X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921256X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921257X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1921258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921259X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1921260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1921261X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1921262X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1921263X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1921264X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1921265X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1921266X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1921267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1921268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1921269X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1921270X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921271X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1921272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1921273X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921275X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1921278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1921279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1921280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 NO HEALTH INSURANCE"
         11 "11 JOB-RELATED REASONS"
         12 "12 LOOKING FOR A NEW DOCTOR/NO DOCTOR YET"
         13 "13 USC DOCTOR IS SOMEWHERE ELSE"
         14 "14 DON'T LIKE/DON'T TRUST DOCTORS"
         15 "15 HEALTH-RELATED REASONS"
         16 "16 NEWBORN - NO DOCTOR YET"
         17 "17 SELF, RELATIVE, OR FRIEND IS A DOCTOR"
         19 "19 CARE AVAILABLE ON JOB"
         2 "2 RECENTLY MOVED TO AREA"
         20 "20 WILL NOT GO TO THE DOCTOR"
         21 "21 PROBLEMS WITH TIME AND TRANSPORTATION"
         22 "22 GOES TO HOSPITAL/EMERGENCY ROOM/CLINIC"
         23 "23 USES ALTERNATIVE CARE"
         24 "24 INSURANCE-RELATED REASONS"
         3 "3 DON'T KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CAN'T FIND PROVIDER WHO SPEAKS LANGUAGE"
         6 "6 GOES DIFFERENT PLACES FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSURANCE PLANS"
         8 "8 DON'T USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H1921281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 1 YEAR"
         2 "2 1 YR., LESS THAN 5 YRS."
         3 "3 5 YRS., LESS THAN 10 YRS."
         4 "4 10 YRS., LESS THAN 15 YRS."
         5 "5 15 YEARS OR MORE" ;

label define H1921282X
         0 "0.00"
         129 "$1 - $129" ;

label define H1921283X
         0 "0.00"
         364 "$1 - $364" ;

label define H1921284X
         0 "0.00"
         32 "$1 - $32" ;

label define H1921285X
         0 "0.00"
         132 "$1 - $132" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H1920001X;
label value ACTDTY31 H1920002X;
label value ACTDTY42 H1920003X;
label value ACTDTY53 H1920004X;
label value ACTLIM31 H1920005X;
label value ACTLIM53 H1920006X;
label value ADAPPT42 H1920007X;
label value ADCAPE42 H1920008X;
label value ADCLIM42 H1920009X;
label value ADCMPM42 H1920010X;
label value ADCMPY42 H1920011X;
label value ADDAYA42 H1920012X;
label value ADDOWN42 H1920013X;
label value ADDPRS42 H1920014X;
label value ADDRBP42 H1920015X;
label value ADEFRT42 H1920016X;
label value ADEGMC42 H1920017X;
label value ADESSP42 H1920018X;
label value ADEXPL42 H1920019X;
label value ADEZUN42 H1920020X;
label value ADFFRM42 H1920021X;
label value ADFHLP42 H1920022X;
label value ADGENH42 H1920023X;
label value ADHDADDX H1920024X;
label value ADHDAGED H1920025X;
label value ADHECR42 H1920026X;
label value ADHOPE42 H1920027X;
label value ADILCR42 H1920028X;
label value ADILWW42 H1920029X;
label value ADINSA42 H1920030X;
label value ADINSB42 H1920031X;
label value ADINST42 H1920032X;
label value ADINTR42 H1920033X;
label value ADLANG42 H1920034X;
label value ADLHLP31 H1920035X;
label value ADLHLP53 H1920036X;
label value ADLIST42 H1920037X;
label value ADMALS42 H1920038X;
label value ADMWLM42 H1920039X;
label value ADNDCR42 H1920040X;
label value ADNERV42 H1920041X;
label value ADNRGY42 H1920042X;
label value ADNSMK42 H1920043X;
label value ADOVER42 H1920044X;
label value ADPAIN42 H1920045X;
label value ADPALS42 H1920046X;
label value ADPRTM42 H1920047X;
label value ADPRXY42 H1920048X;
label value ADPWLM42 H1920049X;
label value ADRESP42 H1920050X;
label value ADREST42 H1920051X;
label value ADRISK42 H1920052X;
label value ADRTCR42 H1920053X;
label value ADRTWW42 H1920054X;
label value ADSAD42 H1920055X;
label value ADSMOK42 H1920056X;
label value ADSOCA42 H1920057X;
label value ADSPEC42 H1920058X;
label value ADTLHW42 H1920059X;
label value ADUPRO42 H1920060X;
label value ADWRTH42 H1920061X;
label value AFDC16 H1920062X;
label value AFTHOU42 H1920063X;
label value AIDHLP31 H1920064X;
label value AIDHLP53 H1920065X;
label value ALIIMP16 H1920066X;
label value AMEWCP16 H1920067X;
label value ANGIAGED H1920068X;
label value ANGIDX H1920069X;
label value ANYLMT16 H1920070X;
label value ARTHAGED H1920071X;
label value ARTHDX H1920072X;
label value ARTHTYPE H1920073X;
label value ASACUT53 H1920074X;
label value ASATAK31 H1920075X;
label value ASATAK53 H1920076X;
label value ASDALY53 H1920077X;
label value ASEVFL53 H1920078X;
label value ASIANP42 H1920079X;
label value ASMRCN53 H1920080X;
label value ASPKFL53 H1920081X;
label value ASPREV53 H1920082X;
label value ASPRIN53 H1920083X;
label value ASSTIL31 H1920084X;
label value ASSTIL53 H1920085X;
label value ASTHAGED H1920086X;
label value ASTHDX H1920087X;
label value ASTHEP31 H1920088X;
label value ASTHEP53 H1920089X;
label value ASWNFL53 H1920090X;
label value BEGRFM31 H1920091X;
label value BEGRFM42 H1920092X;
label value BEGRFM53 H1920093X;
label value BEGRFY31 H1920094X;
label value BEGRFY42 H1920095X;
label value BEGRFY53 H1920096X;
label value BENDIF31 H1920097X;
label value BENDIF53 H1920098X;
label value BLCKPR42 H1920099X;
label value BLIND42 H1920100X;
label value BMINDX53 H1920101X;
label value BOOST42 H1920102X;
label value BORNUSA H1920103X;
label value BPCHEK53 H1920104X;
label value BPMLDX H1920105X;
label value BRSTEX53 H1920106X;
label value BSNTY31 H1920107X;
label value BSNTY31H H1920108X;
label value BSNTY42 H1920109X;
label value BSNTY42H H1920110X;
label value BSNTY53 H1920111X;
label value BSNTY53H H1920112X;
label value BSTSRE53 H1920113X;
label value BSTST53 H1920114X;
label value BUSIMP16 H1920115X;
label value CABLADDR H1920116X;
label value CABREAST H1920117X;
label value CACERVIX H1920118X;
label value CACOLON H1920119X;
label value CALUNG H1920120X;
label value CALYMPH H1920121X;
label value CAMELANO H1920122X;
label value CANCERDX H1920123X;
label value CAOTHER H1920124X;
label value CAPROSTA H1920125X;
label value CARECO42 H1920126X;
label value CASKINDK H1920127X;
label value CASKINNM H1920128X;
label value CAUTERUS H1920129X;
label value CBCK31 H1920130X;
label value CBCKYR31 H1920131X;
label value CCLHIN31 H1920132X;
label value CCNRDI31 H1920133X;
label value CDIAG31 H1920134X;
label value CDLFUP31 H1920135X;
label value CDLMNT31 H1920136X;
label value CDLOTH31 H1920137X;
label value CDLPRS31 H1920138X;
label value CDLTRT31 H1920139X;
label value CDLVST31 H1920140X;
label value CEFACT31 H1920141X;
label value CEFBCK31 H1920142X;
label value CEFCOP31 H1920143X;
label value CEFFTG31 H1920144X;
label value CEFHLT31 H1920145X;
label value CEFLCT31 H1920146X;
label value CEFMHL31 H1920147X;
label value CEFMPR31 H1920148X;
label value CEFMTL31 H1920149X;
label value CEFOG31 H1920150X;
label value CEFPAC31 H1920151X;
label value CEFPHL31 H1920152X;
label value CEFPIN31 H1920153X;
label value CEFPOS31 H1920154X;
label value CEFQLF31 H1920155X;
label value CEFRLT31 H1920156X;
label value CEFSTG31 H1920157X;
label value CEFUND31 H1920158X;
label value CERET31 H1920159X;
label value CEXTDI31 H1920160X;
label value CEXTLT31 H1920161X;
label value CEXTM31 H1920162X;
label value CEXTMT31 H1920163X;
label value CEXTRT31 H1920164X;
label value CFM2MT31 H1920165X;
label value CFMCHD31 H1920166X;
label value CFMEM31 H1920167X;
label value CFMFND31 H1920168X;
label value CFMOTR31 H1920169X;
label value CFMPAR31 H1920170X;
label value CFMREL31 H1920171X;
label value CFMSIB31 H1920172X;
label value CFMSPS31 H1920173X;
label value CFMTOF31 H1920174X;
label value CFNAMT31 H1920175X;
label value CFNBNK31 H1920176X;
label value CFNDBT31 H1920177X;
label value CFNINC31 H1920178X;
label value CFNLIV31 H1920179X;
label value CFNOTH31 H1920180X;
label value CFNPMT31 H1920181X;
label value CFNPUR31 H1920182X;
label value CFNSAV31 H1920183X;
label value CFNSPD31 H1920184X;
label value CFNSTB31 H1920185X;
label value CFNUNB31 H1920186X;
label value CFNVAC31 H1920187X;
label value CFRET31 H1920188X;
label value CFTRT31 H1920189X;
label value CHAPPT42 H1920190X;
label value CHBMIX42 H1920191X;
label value CHBRON31 H1920192X;
label value CHBRON53 H1920193X;
label value CHCOUN42 H1920194X;
label value CHDAGED H1920195X;
label value CHDDX H1920196X;
label value CHECK53 H1920197X;
label value CHEMPB42 H1920198X;
label value CHENEC42 H1920199X;
label value CHEXPL42 H1920200X;
label value CHEYRE42 H1920201X;
label value CHGJ3142 H1920202X;
label value CHGJ4253 H1920203X;
label value CHHECR42 H1920204X;
label value CHILCR42 H1920205X;
label value CHILWW42 H1920206X;
label value CHLICO42 H1920207X;
label value CHLIHB42 H1920208X;
label value CHLIMI42 H1920209X;
label value CHLIMP16 H1920210X;
label value CHLIST42 H1920211X;
label value CHNDCR42 H1920212X;
label value CHOIC31 H1920213X;
label value CHOIC42 H1920214X;
label value CHOIC53 H1920215X;
label value CHOLAGED H1920216X;
label value CHOLCK53 H1920217X;
label value CHOLDX H1920218X;
label value CHPMCN42 H1920219X;
label value CHPMED42 H1920220X;
label value CHPMHB42 H1920221X;
label value CHPRTM42 H1920222X;
label value CHRESP42 H1920223X;
label value CHRTCR42 H1920224X;
label value CHRTWW42 H1920225X;
label value CHSERV42 H1920226X;
label value CHSPEC42 H1920227X;
label value CHSRCN42 H1920228X;
label value CHSRHB42 H1920229X;
label value CHTHCO42 H1920230X;
label value CHTHER42 H1920231X;
label value CHTHHB42 H1920232X;
label value CINADQ31 H1920233X;
label value CINAFD31 H1920234X;
label value CINCMP31 H1920235X;
label value CINCOV31 H1920236X;
label value CINDIF31 H1920237X;
label value CINIHS31 H1920238X;
label value CINMDA31 H1920239X;
label value CINMDC31 H1920240X;
label value CINMDG31 H1920241X;
label value CINMLT31 H1920242X;
label value CINNCV31 H1920243X;
label value CINNOC31 H1920244X;
label value CINOGP31 H1920245X;
label value CINPRV31 H1920246X;
label value CINSHP31 H1920247X;
label value CINSSP31 H1920248X;
label value CLHINS31 H1920249X;
label value CLINIC42 H1920250X;
label value CLMDEP16 H1920251X;
label value CLMHIP16 H1920252X;
label value CLNTRE53 H1920253X;
label value CLNTST53 H1920254X;
label value CLPROD31 H1920255X;
label value CLSTRT31 H1920256X;
label value CMCEFF31 H1920257X;
label value CMCFUP31 H1920258X;
label value CMCNEC31 H1920259X;
label value CMCOST31 H1920260X;
label value CMCPSY31 H1920261X;
label value CMCSTY31 H1920262X;
label value CMCTRT31 H1920263X;
label value CMJHLD31 H1920264X;
label value CMJHLD42 H1920265X;
label value CMJHLD53 H1920266X;
label value CMNACC31 H1920267X;
label value CMNAFF31 H1920268X;
label value CMNCRE31 H1920269X;
label value CMNINS31 H1920270X;
label value CMNLNG31 H1920271X;
label value CMNOFF31 H1920272X;
label value CMNPLC31 H1920273X;
label value CMNTIM31 H1920274X;
label value CMTASK31 H1920275X;
label value CNCCHD31 H1920276X;
label value CNCHME31 H1920277X;
label value CNCLOD31 H1920278X;
label value CNCMED31 H1920279X;
label value CNCNON31 H1920280X;
label value CNCNTS31 H1920281X;
label value CNCTRP31 H1920282X;
label value CNGFLX31 H1920283X;
label value CNPTLD31 H1920284X;
label value COGLIM31 H1920285X;
label value COGLIM53 H1920286X;
label value COVRMM H1920287X;
label value COVRYY H1920288X;
label value CPROM31 H1920289X;
label value CPTASK31 H1920290X;
label value CRFMPY42 H1920291X;
label value CSHCN42 H1920292X;
label value CSHIMP16 H1920293X;
label value CSLHIN31 H1920294X;
label value CTMOFF31 H1920295X;
label value CTRTMT31 H1920296X;
label value CWRKP31 H1920297X;
label value CWYCNG31 H1920298X;
label value DADPRO42 H1920299X;
label value DDNSCL16 H1920300X;
label value DDNWRK16 H1920301X;
label value DEAF42 H1920302X;
label value DECIDE42 H1920303X;
label value DENTAL42 H1920304X;
label value DENTCK53 H1920305X;
label value DENTIN31 H1920306X;
label value DENTIN42 H1920307X;
label value DENTIN53 H1920308X;
label value DEPDNT16 H1920309X;
label value DFCOG42 H1920310X;
label value DFDRSB42 H1920311X;
label value DFERND42 H1920312X;
label value DFHEAR42 H1920313X;
label value DFSEE42 H1920314X;
label value DFWLKC42 H1920315X;
label value DIABAGED H1920316X;
label value DIABDX H1920317X;
label value DIFFPL42 H1920318X;
label value DIFFWG31 H1920319X;
label value DIFFWG42 H1920320X;
label value DIFFWG53 H1920321X;
label value DISVW31X H1920322X;
label value DISVW42X H1920323X;
label value DISVW53X H1920324X;
label value DIVIMP16 H1920325X;
label value DKWHRU42 H1920326X;
label value DNDLAY42 H1920327X;
label value DNDLRS42 H1920328X;
label value DNTINS16 H1920329X;
label value DNTINS31 H1920330X;
label value DNUNAB42 H1920331X;
label value DNUNRS42 H1920332X;
label value DOBMM H1920333X;
label value DOBYY H1920334X;
label value DOCELS42 H1920335X;
label value DPINRU16 H1920336X;
label value DPOTSD16 H1920337X;
label value DSA1C53 H1920338X;
label value DSCB1553 H1920339X;
label value DSCGRP53 H1920340X;
label value DSCH1553 H1920341X;
label value DSCH1653 H1920342X;
label value DSCH1753 H1920343X;
label value DSCHNV53 H1920344X;
label value DSCINT53 H1920345X;
label value DSCNPC53 H1920346X;
label value DSCONF53 H1920347X;
label value DSCPCP53 H1920348X;
label value DSCPHN53 H1920349X;
label value DSDIA53 H1920350X;
label value DSDIET53 H1920351X;
label value DSEB1553 H1920352X;
label value DSEY1553 H1920353X;
label value DSEY1653 H1920354X;
label value DSEY1753 H1920355X;
label value DSEYNV53 H1920356X;
label value DSEYPR53 H1920357X;
label value DSFB1553 H1920358X;
label value DSFL1553 H1920359X;
label value DSFL1653 H1920360X;
label value DSFL1753 H1920361X;
label value DSFLNV53 H1920362X;
label value DSFT1553 H1920363X;
label value DSFT1653 H1920364X;
label value DSFT1753 H1920365X;
label value DSFTNV53 H1920366X;
label value DSINSU53 H1920367X;
label value DSKIDN53 H1920368X;
label value DSMED53 H1920369X;
label value DSPRX53 H1920370X;
label value DSVB1553 H1920371X;
label value DVGEN16 H1920372X;
label value DVGWCP16 H1920373X;
label value DVOOPU16 H1920374X;
label value DVORTH16 H1920375X;
label value DVOSTL16 H1920376X;
label value DVOVA16 H1920377X;
label value DVTOT16 H1920378X;
label value DVTWCP16 H1920379X;
label value EATHLT42 H1920380X;
label value EDUCYR H1920381X;
label value EICRDT16 H1920382X;
label value ELGRND16 H1920383X;
label value ELGRND31 H1920384X;
label value ELGRND42 H1920385X;
label value ELGRND53 H1920386X;
label value EMPHAGED H1920387X;
label value EMPHDX H1920388X;
label value EMPST31 H1920389X;
label value EMPST31H H1920390X;
label value EMPST42 H1920391X;
label value EMPST42H H1920392X;
label value EMPST53 H1920393X;
label value EMPST53H H1920394X;
label value ENDRFM16 H1920395X;
label value ENDRFM31 H1920396X;
label value ENDRFM42 H1920397X;
label value ENDRFM53 H1920398X;
label value ENDRFY16 H1920399X;
label value ENDRFY31 H1920400X;
label value ENDRFY42 H1920401X;
label value ENDRFY53 H1920402X;
label value ERTOT16 H1920403X;
label value EVRETIRE H1920404X;
label value EVRWRK H1920405X;
label value EXPLOP42 H1920406X;
label value EXRCIS53 H1920407X;
label value FAMRFPYR H1920408X;
label value FAMSZE31 H1920409X;
label value FAMSZE42 H1920410X;
label value FAMSZE53 H1920411X;
label value FCRP1231 H1920412X;
label value FILEDR16 H1920413X;
label value FILER16 H1920414X;
label value FLSTAT16 H1920415X;
label value FLUSHT53 H1920416X;
label value FMRS1231 H1920417X;
label value FNGRDF31 H1920418X;
label value FNGRDF53 H1920419X;
label value FOODMN16 H1920420X;
label value FOODST16 H1920421X;
label value FOODVL16 H1920422X;
label value FSAAMT31 H1920423X;
label value FSAGT31 H1920424X;
label value FTSTU16X H1920425X;
label value FTSTU31X H1920426X;
label value FTSTU42X H1920427X;
label value FTSTU53X H1920428X;
label value GENDRP42 H1920429X;
label value HASFSA31 H1920430X;
label value HAVEUS42 H1920431X;
label value HAVFUN42 H1920432X;
label value HEALTH42 H1920433X;
label value HEARAD42 H1920434X;
label value HELD31X H1920435X;
label value HELD42X H1920436X;
label value HELD53X H1920437X;
label value HELMET42 H1920438X;
label value HHAGD16 H1920439X;
label value HHINDD16 H1920440X;
label value HHINFD16 H1920441X;
label value HHNOSR16 H1920442X;
label value HHNTRI16 H1920443X;
label value HHNVA16 H1920444X;
label value HHTOTD16 H1920445X;
label value HIBPAGED H1920446X;
label value HIBPDX H1920447X;
label value HIDEG H1920448X;
label value HISPANX H1920449X;
label value HISPNCAT H1920450X;
label value HOMEBH42 H1920451X;
label value HONRDC31 H1920452X;
label value HONRDC42 H1920453X;
label value HONRDC53 H1920454X;
label value HOUR31 H1920455X;
label value HOUR42 H1920456X;
label value HOUR53 H1920457X;
label value HPDAP16 H1920458X;
label value HPDAU16 H1920459X;
label value HPDDE16 H1920460X;
label value HPDFE16 H1920461X;
label value HPDJA16 H1920462X;
label value HPDJL16 H1920463X;
label value HPDJU16 H1920464X;
label value HPDMA16 H1920465X;
label value HPDMY16 H1920466X;
label value HPDNO16 H1920467X;
label value HPDOC16 H1920468X;
label value HPDSE16 H1920469X;
label value HPEAP16 H1920470X;
label value HPEAU16 H1920471X;
label value HPEDE16 H1920472X;
label value HPEFE16 H1920473X;
label value HPEJA16 H1920474X;
label value HPEJL16 H1920475X;
label value HPEJU16 H1920476X;
label value HPEMA16 H1920477X;
label value HPEMY16 H1920478X;
label value HPENO16 H1920479X;
label value HPEOC16 H1920480X;
label value HPESE16 H1920481X;
label value HPNAP16 H1920482X;
label value HPNAU16 H1920483X;
label value HPNDE16 H1920484X;
label value HPNFE16 H1920485X;
label value HPNJA16 H1920486X;
label value HPNJL16 H1920487X;
label value HPNJU16 H1920488X;
label value HPNMA16 H1920489X;
label value HPNMY16 H1920490X;
label value HPNNO16 H1920491X;
label value HPNOC16 H1920492X;
label value HPNSE16 H1920493X;
label value HPOAP16 H1920494X;
label value HPOAU16 H1920495X;
label value HPODE16 H1920496X;
label value HPOFE16 H1920497X;
label value HPOJA16 H1920498X;
label value HPOJL16 H1920499X;
label value HPOJU16 H1920500X;
label value HPOMA16 H1920501X;
label value HPOMY16 H1920502X;
label value HPONO16 H1920503X;
label value HPOOC16 H1920504X;
label value HPOSE16 H1920505X;
label value HPRAP16 H1920506X;
label value HPRAU16 H1920507X;
label value HPRDE16 H1920508X;
label value HPRFE16 H1920509X;
label value HPRJA16 H1920510X;
label value HPRJL16 H1920511X;
label value HPRJU16 H1920512X;
label value HPRMA16 H1920513X;
label value HPRMY16 H1920514X;
label value HPRNO16 H1920515X;
label value HPROC16 H1920516X;
label value HPRSE16 H1920517X;
label value HPSAP16 H1920518X;
label value HPSAU16 H1920519X;
label value HPSDE16 H1920520X;
label value HPSFE16 H1920521X;
label value HPSJA16 H1920522X;
label value HPSJL16 H1920523X;
label value HPSJU16 H1920524X;
label value HPSMA16 H1920525X;
label value HPSMY16 H1920526X;
label value HPSNO16 H1920527X;
label value HPSOC16 H1920528X;
label value HPSSE16 H1920529X;
label value HPXAP16 H1920530X;
label value HPXAU16 H1920531X;
label value HPXDE16 H1920532X;
label value HPXFE16 H1920533X;
label value HPXJA16 H1920534X;
label value HPXJL16 H1920535X;
label value HPXJU16 H1920536X;
label value HPXMA16 H1920537X;
label value HPXMY16 H1920538X;
label value HPXNO16 H1920539X;
label value HPXOC16 H1920540X;
label value HPXSE16 H1920541X;
label value HRHOW31 H1920542X;
label value HRHOW42 H1920543X;
label value HRHOW53 H1920544X;
label value HRWG31H H1920545X;
label value HRWG31X H1920546X;
label value HRWG42H H1920547X;
label value HRWG42X H1920548X;
label value HRWG53H H1920549X;
label value HRWG53X H1920550X;
label value HRWGIM31 H1920551X;
label value HRWGIM42 H1920552X;
label value HRWGIM53 H1920553X;
label value HSELIM31 H1920554X;
label value HSELIM53 H1920555X;
label value HSPLAP42 H1920556X;
label value HWELLSPE H1920557X;
label value HYSTER53 H1920558X;
label value IADLHP31 H1920559X;
label value IADLHP53 H1920560X;
label value INDCAT31 H1920561X;
label value INDCAT42 H1920562X;
label value INDCAT53 H1920563X;
label value INDCT31H H1920564X;
label value INDCT42H H1920565X;
label value INDCT53H H1920566X;
label value INS16X H1920567X;
label value INS31X H1920568X;
label value INS42X H1920569X;
label value INS53X H1920570X;
label value INSAP16X H1920571X;
label value INSAT16X H1920572X;
label value INSAT31X H1920573X;
label value INSAT42X H1920574X;
label value INSAT53X H1920575X;
label value INSAU16X H1920576X;
label value INSC1231 H1920577X;
label value INSCOP16 H1920578X;
label value INSCOP31 H1920579X;
label value INSCOP42 H1920580X;
label value INSCOP53 H1920581X;
label value INSCOPE H1920582X;
label value INSCOV16 H1920583X;
label value INSDE16X H1920584X;
label value INSENDMM H1920585X;
label value INSENDYY H1920586X;
label value INSFE16X H1920587X;
label value INSJA16X H1920588X;
label value INSJL16X H1920589X;
label value INSJU16X H1920590X;
label value INSMA16X H1920591X;
label value INSMY16X H1920592X;
label value INSNO16X H1920593X;
label value INSOC16X H1920594X;
label value INSRPL42 H1920595X;
label value INSSE16X H1920596X;
label value INSURC16 H1920597X;
label value INTIMP16 H1920598X;
label value INTVLANG H1920599X;
label value IPDIS16 H1920600X;
label value IPZERO16 H1920601X;
label value IRAIMP16 H1920602X;
label value JBORG31H H1920603X;
label value JBORG42H H1920604X;
label value JBORG53H H1920605X;
label value JNTPID16 H1920606X;
label value JOBORG31 H1920607X;
label value JOBORG42 H1920608X;
label value JOBORG53 H1920609X;
label value JOBRSN42 H1920610X;
label value JTINRU16 H1920611X;
label value JTPAIN31 H1920612X;
label value JTPAIN53 H1920613X;
label value K6SUM42 H1920614X;
label value KEYNESS H1920615X;
label value KIDPRO42 H1920616X;
label value KNOWDR42 H1920617X;
label value LANGSPK H1920618X;
label value LAPBLT42 H1920619X;
label value LFTDIF31 H1920620X;
label value LFTDIF53 H1920621X;
label value LOCATN42 H1920622X;
label value LSTETH53 H1920623X;
label value MAMOGR53 H1920624X;
label value MARRY16X H1920625X;
label value MARRY31X H1920626X;
label value MARRY42X H1920627X;
label value MARRY53X H1920628X;
label value MCAID16 H1920629X;
label value MCAID16X H1920630X;
label value MCAID31 H1920631X;
label value MCAID31X H1920632X;
label value MCAID42 H1920633X;
label value MCAID42X H1920634X;
label value MCAID53 H1920635X;
label value MCAID53X H1920636X;
label value MCARE16 H1920637X;
label value MCARE16X H1920638X;
label value MCARE31 H1920639X;
label value MCARE31X H1920640X;
label value MCARE42 H1920641X;
label value MCARE42X H1920642X;
label value MCARE53 H1920643X;
label value MCARE53X H1920644X;
label value MCDAP16 H1920645X;
label value MCDAP16X H1920646X;
label value MCDAT16X H1920647X;
label value MCDAT31X H1920648X;
label value MCDAT42X H1920649X;
label value MCDAT53X H1920650X;
label value MCDAU16 H1920651X;
label value MCDAU16X H1920652X;
label value MCDDE16 H1920653X;
label value MCDDE16X H1920654X;
label value MCDEV16 H1920655X;
label value MCDFE16 H1920656X;
label value MCDFE16X H1920657X;
label value MCDHMO16 H1920658X;
label value MCDHMO31 H1920659X;
label value MCDHMO42 H1920660X;
label value MCDJA16 H1920661X;
label value MCDJA16X H1920662X;
label value MCDJL16 H1920663X;
label value MCDJL16X H1920664X;
label value MCDJU16 H1920665X;
label value MCDJU16X H1920666X;
label value MCDMA16 H1920667X;
label value MCDMA16X H1920668X;
label value MCDMC16 H1920669X;
label value MCDMC31 H1920670X;
label value MCDMC42 H1920671X;
label value MCDMY16 H1920672X;
label value MCDMY16X H1920673X;
label value MCDNO16 H1920674X;
label value MCDNO16X H1920675X;
label value MCDOC16 H1920676X;
label value MCDOC16X H1920677X;
label value MCDSE16 H1920678X;
label value MCDSE16X H1920679X;
label value MCRAP16 H1920680X;
label value MCRAP16X H1920681X;
label value MCRAU16 H1920682X;
label value MCRAU16X H1920683X;
label value MCRDE16 H1920684X;
label value MCRDE16X H1920685X;
label value MCREV16 H1920686X;
label value MCRFE16 H1920687X;
label value MCRFE16X H1920688X;
label value MCRJA16 H1920689X;
label value MCRJA16X H1920690X;
label value MCRJL16 H1920691X;
label value MCRJL16X H1920692X;
label value MCRJU16 H1920693X;
label value MCRJU16X H1920694X;
label value MCRMA16 H1920695X;
label value MCRMA16X H1920696X;
label value MCRMY16 H1920697X;
label value MCRMY16X H1920698X;
label value MCRNO16 H1920699X;
label value MCRNO16X H1920700X;
label value MCROC16 H1920701X;
label value MCROC16X H1920702X;
label value MCRPB16 H1920703X;
label value MCRPB31 H1920704X;
label value MCRPB42 H1920705X;
label value MCRPD16 H1920706X;
label value MCRPD16X H1920707X;
label value MCRPD31 H1920708X;
label value MCRPD31X H1920709X;
label value MCRPD42 H1920710X;
label value MCRPD42X H1920711X;
label value MCRPHO16 H1920712X;
label value MCRPHO31 H1920713X;
label value MCRPHO42 H1920714X;
label value MCRSE16 H1920715X;
label value MCRSE16X H1920716X;
label value MDDLAY42 H1920717X;
label value MDDLRS42 H1920718X;
label value MDUNAB42 H1920719X;
label value MDUNRS42 H1920720X;
label value MESBPR42 H1920721X;
label value MESHGT42 H1920722X;
label value MESVIS42 H1920723X;
label value MESWGT42 H1920724X;
label value MIAGED H1920725X;
label value MIDX H1920726X;
label value MILDIF31 H1920727X;
label value MILDIF53 H1920728X;
label value MINORP42 H1920729X;
label value MNHLTH31 H1920730X;
label value MNHLTH42 H1920731X;
label value MNHLTH53 H1920732X;
label value MOMPRO42 H1920733X;
label value MORE31 H1920734X;
label value MORE31H H1920735X;
label value MORE42 H1920736X;
label value MORE42H H1920737X;
label value MORE53 H1920738X;
label value MORE53H H1920739X;
label value MORECOVR H1920740X;
label value MORJOB31 H1920741X;
label value MORJOB42 H1920742X;
label value MORJOB53 H1920743X;
label value MYSELF42 H1920744X;
label value NATAMP42 H1920745X;
label value NERVAF42 H1920746X;
label value NEWARE42 H1920747X;
label value NEWDOC42 H1920748X;
label value NHRWG31 H1920749X;
label value NHRWG42 H1920750X;
label value NHRWG53 H1920751X;
label value NOASPR53 H1920752X;
label value NOFAT53 H1920753X;
label value NOGODR42 H1920754X;
label value NOHINS42 H1920755X;
label value NOINSBEF H1920756X;
label value NOINSTM H1920757X;
label value NOINUNIT H1920758X;
label value NOLIKE42 H1920759X;
label value NOREAS42 H1920760X;
label value NOSMOK42 H1920761X;
label value NUMEMP31 H1920762X;
label value NUMEMP42 H1920763X;
label value NUMEMP53 H1920764X;
label value NWK31 H1920765X;
label value NWK42 H1920766X;
label value NWK53 H1920767X;
label value OBASST16 H1920768X;
label value OBCHIR16 H1920769X;
label value OBDRV16 H1920770X;
label value OBEWCP16 H1920771X;
label value OBNURS16 H1920772X;
label value OBOPTO16 H1920773X;
label value OBOTHV16 H1920774X;
label value OBTHER16 H1920775X;
label value OBTOTV16 H1920776X;
label value OCCCAT31 H1920777X;
label value OCCCAT42 H1920778X;
label value OCCCAT53 H1920779X;
label value OCCCT31H H1920780X;
label value OCCCT42H H1920781X;
label value OCCCT53H H1920782X;
label value OFEMP31H H1920783X;
label value OFEMP42H H1920784X;
label value OFEMP53H H1920785X;
label value OFFER31H H1920786X;
label value OFFER31X H1920787X;
label value OFFER42H H1920788X;
label value OFFER42X H1920789X;
label value OFFER53H H1920790X;
label value OFFER53X H1920791X;
label value OFFHOU42 H1920792X;
label value OFREMP31 H1920793X;
label value OFREMP42 H1920794X;
label value OFREMP53 H1920795X;
label value OHRTAGED H1920796X;
label value OHRTDX H1920797X;
label value ONGONG42 H1920798X;
label value ONJOB42 H1920799X;
label value OPAAP16 H1920800X;
label value OPAAU16 H1920801X;
label value OPADE16 H1920802X;
label value OPAEV16 H1920803X;
label value OPAFE16 H1920804X;
label value OPAJA16 H1920805X;
label value OPAJL16 H1920806X;
label value OPAJU16 H1920807X;
label value OPAMA16 H1920808X;
label value OPAMY16 H1920809X;
label value OPANO16 H1920810X;
label value OPAOC16 H1920811X;
label value OPASE16 H1920812X;
label value OPBAP16 H1920813X;
label value OPBAU16 H1920814X;
label value OPBDE16 H1920815X;
label value OPBEV16 H1920816X;
label value OPBFE16 H1920817X;
label value OPBJA16 H1920818X;
label value OPBJL16 H1920819X;
label value OPBJU16 H1920820X;
label value OPBMA16 H1920821X;
label value OPBMY16 H1920822X;
label value OPBNO16 H1920823X;
label value OPBOC16 H1920824X;
label value OPBSE16 H1920825X;
label value OPDRV16 H1920826X;
label value OPOTHV16 H1920827X;
label value OPPSTL16 H1920828X;
label value OPTOTV16 H1920829X;
label value OTHDYS16 H1920830X;
label value OTHIMP16 H1920831X;
label value OTHINS42 H1920832X;
label value OTHLANG H1920833X;
label value OTHNDD16 H1920834X;
label value OTHOFD16 H1920835X;
label value OTHRCP42 H1920836X;
label value OTHREA42 H1920837X;
label value OTPAAT16 H1920838X;
label value OTPAAT31 H1920839X;
label value OTPAAT42 H1920840X;
label value OTPAAT53 H1920841X;
label value OTPBAT16 H1920842X;
label value OTPBAT31 H1920843X;
label value OTPBAT42 H1920844X;
label value OTPBAT53 H1920845X;
label value OTPUBA16 H1920846X;
label value OTPUBA31 H1920847X;
label value OTPUBA42 H1920848X;
label value OTPUBA53 H1920849X;
label value OTPUBB16 H1920850X;
label value OTPUBB31 H1920851X;
label value OTPUBB42 H1920852X;
label value OTPUBB53 H1920853X;
label value PACISP42 H1920854X;
label value PANEL H1920855X;
label value PAPSMR53 H1920856X;
label value PAYDR31 H1920857X;
label value PAYDR31H H1920858X;
label value PAYDR42 H1920859X;
label value PAYDR42H H1920860X;
label value PAYDR53 H1920861X;
label value PAYDR53H H1920862X;
label value PAYVAC31 H1920863X;
label value PAYVAC42 H1920864X;
label value PAYVAC53 H1920865X;
label value PDKAP16 H1920866X;
label value PDKAU16 H1920867X;
label value PDKDE16 H1920868X;
label value PDKFE16 H1920869X;
label value PDKJA16 H1920870X;
label value PDKJL16 H1920871X;
label value PDKJU16 H1920872X;
label value PDKMA16 H1920873X;
label value PDKMY16 H1920874X;
label value PDKNO16 H1920875X;
label value PDKOC16 H1920876X;
label value PDKSE16 H1920877X;
label value PEGAP16 H1920878X;
label value PEGAU16 H1920879X;
label value PEGDE16 H1920880X;
label value PEGFE16 H1920881X;
label value PEGJA16 H1920882X;
label value PEGJL16 H1920883X;
label value PEGJU16 H1920884X;
label value PEGMA16 H1920885X;
label value PEGMY16 H1920886X;
label value PEGNO16 H1920887X;
label value PEGOC16 H1920888X;
label value PEGSE16 H1920889X;
label value PENIMP16 H1920890X;
label value PERSLA42 H1920891X;
label value PHNREG42 H1920892X;
label value PHQ242 H1920893X;
label value PHYEXE53 H1920894X;
label value PHYSCL42 H1920895X;
label value PLCTYP42 H1920896X;
label value PMDINS16 H1920897X;
label value PMDINS31 H1920898X;
label value PMDLAY42 H1920899X;
label value PMDLRS42 H1920900X;
label value PMEDIN31 H1920901X;
label value PMEDIN42 H1920902X;
label value PMEDIN53 H1920903X;
label value PMEDPY31 H1920904X;
label value PMEDPY42 H1920905X;
label value PMEDPY53 H1920906X;
label value PMEDUP31 H1920907X;
label value PMEDUP42 H1920908X;
label value PMEDUP53 H1920909X;
label value PMUNAB42 H1920910X;
label value PMUNRS42 H1920911X;
label value PNGAP16 H1920912X;
label value PNGAU16 H1920913X;
label value PNGDE16 H1920914X;
label value PNGFE16 H1920915X;
label value PNGJA16 H1920916X;
label value PNGJL16 H1920917X;
label value PNGJU16 H1920918X;
label value PNGMA16 H1920919X;
label value PNGMY16 H1920920X;
label value PNGNO16 H1920921X;
label value PNGOC16 H1920922X;
label value PNGSE16 H1920923X;
label value POGAP16 H1920924X;
label value POGAU16 H1920925X;
label value POGDE16 H1920926X;
label value POGFE16 H1920927X;
label value POGJA16 H1920928X;
label value POGJL16 H1920929X;
label value POGJU16 H1920930X;
label value POGMA16 H1920931X;
label value POGMY16 H1920932X;
label value POGNO16 H1920933X;
label value POGOC16 H1920934X;
label value POGSE16 H1920935X;
label value POUAP16 H1920936X;
label value POUAU16 H1920937X;
label value POUDE16 H1920938X;
label value POUFE16 H1920939X;
label value POUJA16 H1920940X;
label value POUJL16 H1920941X;
label value POUJU16 H1920942X;
label value POUMA16 H1920943X;
label value POUMY16 H1920944X;
label value POUNO16 H1920945X;
label value POUOC16 H1920946X;
label value POUSE16 H1920947X;
label value POVCAT16 H1920948X;
label value PREGNT31 H1920949X;
label value PREGNT42 H1920950X;
label value PREGNT53 H1920951X;
label value PREVCOVR H1920952X;
label value PREVEN42 H1920953X;
label value PRIAP16 H1920954X;
label value PRIAU16 H1920955X;
label value PRIDE16 H1920956X;
label value PRIDK16 H1920957X;
label value PRIDK31 H1920958X;
label value PRIDK42 H1920959X;
label value PRIDK53 H1920960X;
label value PRIEU16 H1920961X;
label value PRIEU31 H1920962X;
label value PRIEU42 H1920963X;
label value PRIEU53 H1920964X;
label value PRIFE16 H1920965X;
label value PRIJA16 H1920966X;
label value PRIJL16 H1920967X;
label value PRIJU16 H1920968X;
label value PRIMA16 H1920969X;
label value PRIMY16 H1920970X;
label value PRING16 H1920971X;
label value PRING31 H1920972X;
label value PRING42 H1920973X;
label value PRING53 H1920974X;
label value PRINO16 H1920975X;
label value PRIOC16 H1920976X;
label value PRIOG16 H1920977X;
label value PRIOG31 H1920978X;
label value PRIOG42 H1920979X;
label value PRIOG53 H1920980X;
label value PRIS16 H1920981X;
label value PRIS31 H1920982X;
label value PRIS42 H1920983X;
label value PRIS53 H1920984X;
label value PRISE16 H1920985X;
label value PRIV16 H1920986X;
label value PRIV31 H1920987X;
label value PRIV42 H1920988X;
label value PRIV53 H1920989X;
label value PRIVAT16 H1920990X;
label value PRIVAT31 H1920991X;
label value PRIVAT42 H1920992X;
label value PRIVAT53 H1920993X;
label value PROBPY42 H1920994X;
label value PROUT16 H1920995X;
label value PROUT31 H1920996X;
label value PROUT42 H1920997X;
label value PROUT53 H1920998X;
label value PROVTY42 H1920999X;
label value PROXY16 H1921000X;
label value PROXY31 H1921001X;
label value PROXY42 H1921002X;
label value PROXY53 H1921003X;
label value PRSAP16 H1921004X;
label value PRSAU16 H1921005X;
label value PRSDE16 H1921006X;
label value PRSFE16 H1921007X;
label value PRSJA16 H1921008X;
label value PRSJL16 H1921009X;
label value PRSJU16 H1921010X;
label value PRSMA16 H1921011X;
label value PRSMY16 H1921012X;
label value PRSNO16 H1921013X;
label value PRSOC16 H1921014X;
label value PRSSE16 H1921015X;
label value PRSTX16 H1921016X;
label value PRSTX31 H1921017X;
label value PRSTX42 H1921018X;
label value PRSTX53 H1921019X;
label value PRVEV16 H1921020X;
label value PRVHMO16 H1921021X;
label value PRVHMO31 H1921022X;
label value PRVHMO42 H1921023X;
label value PRVSPK42 H1921024X;
label value PRXAP16 H1921025X;
label value PRXAU16 H1921026X;
label value PRXDE16 H1921027X;
label value PRXFE16 H1921028X;
label value PRXJA16 H1921029X;
label value PRXJL16 H1921030X;
label value PRXJU16 H1921031X;
label value PRXMA16 H1921032X;
label value PRXMY16 H1921033X;
label value PRXNO16 H1921034X;
label value PRXOC16 H1921035X;
label value PRXSE16 H1921036X;
label value PSA53 H1921037X;
label value PSTATS31 H1921038X;
label value PSTATS42 H1921039X;
label value PSTATS53 H1921040X;
label value PUB16X H1921041X;
label value PUB31X H1921042X;
label value PUB42X H1921043X;
label value PUB53X H1921044X;
label value PUBAP16X H1921045X;
label value PUBAT16X H1921046X;
label value PUBAT31X H1921047X;
label value PUBAT42X H1921048X;
label value PUBAT53X H1921049X;
label value PUBAU16X H1921050X;
label value PUBDE16X H1921051X;
label value PUBFE16X H1921052X;
label value PUBIMP16 H1921053X;
label value PUBJA16X H1921054X;
label value PUBJL16X H1921055X;
label value PUBJU16X H1921056X;
label value PUBMA16X H1921057X;
label value PUBMY16X H1921058X;
label value PUBNO16X H1921059X;
label value PUBOC16X H1921060X;
label value PUBSE16X H1921061X;
label value PYUNBL42 H1921062X;
label value PYVAC31H H1921063X;
label value PYVAC42H H1921064X;
label value PYVAC53H H1921065X;
label value RACEAX H1921066X;
label value RACEBX H1921067X;
label value RACETHX H1921068X;
label value RACEV1X H1921069X;
label value RACEV2X H1921070X;
label value RACEWX H1921071X;
label value RCHDIF31 H1921072X;
label value RCHDIF53 H1921073X;
label value REFFRL42 H1921074X;
label value REFRL16X H1921075X;
label value REFRL31X H1921076X;
label value REFRL42X H1921077X;
label value REFRL53X H1921078X;
label value REGION16 H1921079X;
label value REGION31 H1921080X;
label value REGION42 H1921081X;
label value REGION53 H1921082X;
label value RESP16 H1921083X;
label value RESP31 H1921084X;
label value RESP42 H1921085X;
label value RESP53 H1921086X;
label value RESPCT42 H1921087X;
label value RETPLN31 H1921088X;
label value RETPLN42 H1921089X;
label value RETPLN53 H1921090X;
label value RNDFLG31 H1921091X;
label value RTHLTH31 H1921092X;
label value RTHLTH42 H1921093X;
label value RTHLTH53 H1921094X;
label value RTPLN31H H1921095X;
label value RTPLN42H H1921096X;
label value RTPLN53H H1921097X;
label value RUCLAS16 H1921098X;
label value RUCLAS31 H1921099X;
label value RUCLAS42 H1921100X;
label value RUCLAS53 H1921101X;
label value RUSIZE16 H1921102X;
label value RUSIZE31 H1921103X;
label value RUSIZE42 H1921104X;
label value RUSIZE53 H1921105X;
label value SAFEST42 H1921106X;
label value SALIMP16 H1921107X;
label value SAQELIG H1921108X;
label value SCHLBH42 H1921109X;
label value SCHLIM31 H1921110X;
label value SCHLIM53 H1921111X;
label value SCHPRO42 H1921112X;
label value SCPAY31H H1921113X;
label value SCPAY42H H1921114X;
label value SCPAY53H H1921115X;
label value SEATBE53 H1921116X;
label value SELDSI42 H1921117X;
label value SELFCM31 H1921118X;
label value SELFCM42 H1921119X;
label value SELFCM53 H1921120X;
label value SEX H1921121X;
label value SFFLAG42 H1921122X;
label value SGMTRE53 H1921123X;
label value SGMTST53 H1921124X;
label value SIBPRO42 H1921125X;
label value SICPAY31 H1921126X;
label value SICPAY42 H1921127X;
label value SICPAY53 H1921128X;
label value SLFCM31H H1921129X;
label value SLFCM42H H1921130X;
label value SLFCM53H H1921131X;
label value SOCLIM31 H1921132X;
label value SOCLIM53 H1921133X;
label value SPOUID16 H1921134X;
label value SPOUID31 H1921135X;
label value SPOUID42 H1921136X;
label value SPOUID53 H1921137X;
label value SPOUIN16 H1921138X;
label value SPOUIN31 H1921139X;
label value SPOUIN42 H1921140X;
label value SPOUIN53 H1921141X;
label value SPRPRO42 H1921142X;
label value SSCIMP16 H1921143X;
label value SSIIMP16 H1921144X;
label value SSNLJB31 H1921145X;
label value SSNLJB42 H1921146X;
label value SSNLJB53 H1921147X;
label value STAAP16 H1921148X;
label value STAAU16 H1921149X;
label value STADE16 H1921150X;
label value STAFE16 H1921151X;
label value STAJA16 H1921152X;
label value STAJL16 H1921153X;
label value STAJU16 H1921154X;
label value STAMA16 H1921155X;
label value STAMY16 H1921156X;
label value STANO16 H1921157X;
label value STAOC16 H1921158X;
label value STAPR16 H1921159X;
label value STAPR31 H1921160X;
label value STAPR42 H1921161X;
label value STAPR53 H1921162X;
label value STASE16 H1921163X;
label value STJBMM31 H1921164X;
label value STJBMM42 H1921165X;
label value STJBMM53 H1921166X;
label value STJBYY31 H1921167X;
label value STJBYY42 H1921168X;
label value STJBYY53 H1921169X;
label value STNDIF31 H1921170X;
label value STNDIF53 H1921171X;
label value STOMCH53 H1921172X;
label value STPDIF31 H1921173X;
label value STPDIF53 H1921174X;
label value STPRAT16 H1921175X;
label value STPRAT31 H1921176X;
label value STPRAT42 H1921177X;
label value STPRAT53 H1921178X;
label value STRKAGED H1921179X;
label value STRKDX H1921180X;
label value TAXFRM16 H1921181X;
label value TEMPJB31 H1921182X;
label value TEMPJB42 H1921183X;
label value TEMPJB53 H1921184X;
label value TIMALN42 H1921185X;
label value TMTKUS42 H1921186X;
label value TRANS42 H1921187X;
label value TRBLE42 H1921188X;
label value TREATM42 H1921189X;
label value TRIAP16X H1921190X;
label value TRIAT16X H1921191X;
label value TRIAT31X H1921192X;
label value TRIAT42X H1921193X;
label value TRIAT53X H1921194X;
label value TRIAU16X H1921195X;
label value TRICH16X H1921196X;
label value TRICH31X H1921197X;
label value TRICH42X H1921198X;
label value TRICR16X H1921199X;
label value TRICR31X H1921200X;
label value TRICR42X H1921201X;
label value TRICR53X H1921202X;
label value TRIDE16X H1921203X;
label value TRIEV16 H1921204X;
label value TRIEX16X H1921205X;
label value TRIEX31X H1921206X;
label value TRIEX42X H1921207X;
label value TRIFE16X H1921208X;
label value TRIJA16X H1921209X;
label value TRIJL16X H1921210X;
label value TRIJU16X H1921211X;
label value TRILI16X H1921212X;
label value TRILI31X H1921213X;
label value TRILI42X H1921214X;
label value TRIMA16X H1921215X;
label value TRIMY16X H1921216X;
label value TRINO16X H1921217X;
label value TRIOC16X H1921218X;
label value TRIPR16X H1921219X;
label value TRIPR31X H1921220X;
label value TRIPR42X H1921221X;
label value TRISE16X H1921222X;
label value TRIST16X H1921223X;
label value TRIST31X H1921224X;
label value TRIST42X H1921225X;
label value TRTIMP16 H1921226X;
label value TYPEPE42 H1921227X;
label value UNABLE31 H1921228X;
label value UNABLE53 H1921229X;
label value UNEIMP16 H1921230X;
label value UNHAP42 H1921231X;
label value UNINS16 H1921232X;
label value UNION31 H1921233X;
label value UNION31H H1921234X;
label value UNION42 H1921235X;
label value UNION42H H1921236X;
label value UNION53 H1921237X;
label value UNION53H H1921238X;
label value USCNOT42 H1921239X;
label value VETIMP16 H1921240X;
label value VISWCP16 H1921241X;
label value WAGIMP16 H1921242X;
label value WASAFDC H1921243X;
label value WASCHAMP H1921244X;
label value WASESTB H1921245X;
label value WASMCAID H1921246X;
label value WASMCARE H1921247X;
label value WASOTGOV H1921248X;
label value WASOTHER H1921249X;
label value WASPRIV H1921250X;
label value WASSSI H1921251X;
label value WASSTAT1 H1921252X;
label value WASSTAT2 H1921253X;
label value WASSTAT3 H1921254X;
label value WASSTAT4 H1921255X;
label value WASVA H1921256X;
label value WCPIMP16 H1921257X;
label value WHITPR42 H1921258X;
label value WHNBPR42 H1921259X;
label value WHNBST42 H1921260X;
label value WHNDEN42 H1921261X;
label value WHNEAT42 H1921262X;
label value WHNHEL42 H1921263X;
label value WHNHGT42 H1921264X;
label value WHNLAP42 H1921265X;
label value WHNPHY42 H1921266X;
label value WHNSAF42 H1921267X;
label value WHNSMK42 H1921268X;
label value WHNWGT42 H1921269X;
label value WILFIL16 H1921270X;
label value WLKDIF31 H1921271X;
label value WLKDIF53 H1921272X;
label value WLKLIM31 H1921273X;
label value WLKLIM53 H1921274X;
label value WRGLAS42 H1921275X;
label value WRKLIM31 H1921276X;
label value WRKLIM53 H1921277X;
label value YCHJ3142 H1921278X;
label value YCHJ4253 H1921279X;
label value YNOUSC42 H1921280X;
label value YRSINUS H1921281X;
label value ZIDOPU16 H1921282X;
label value ZIFOPU16 H1921283X;
label value ZIFSTL16 H1921284X;
label value ZIFVA16 H1921285X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H192.LOG and a data file named H192.DTA.  If these files (H192.DTA and H192.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

